/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.steelworks.inventory;

import javax.annotation.Nonnull;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.library.steelworks.MixAdditive;
import knightminer.tcomplement.steelworks.inventory.ContainerHighOvenSideInventory;
import knightminer.tcomplement.steelworks.tileentity.TileHighOven;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import slimeknights.mantle.inventory.ContainerMultiModule;

public class ContainerHighOven
extends ContainerMultiModule<TileHighOven> {
    protected ContainerHighOvenSideInventory sideInventory;
    private Slot[] slots = new Slot[4];
    private int[] oldHeats;
    private int oldFuel;
    private int oldFuelQuality;
    private int oldTemperature;

    public ContainerHighOven(InventoryPlayer inventoryPlayer, TileHighOven tile) {
        super((TileEntity)tile);
        this.slots[0] = new SlotFuel(this.itemHandler, 80, 52);
        this.func_75146_a(this.slots[0]);
        for (MixAdditive type : MixAdditive.values()) {
            int index = type.getSlotIndex();
            this.slots[index + 1] = new SlotAdditive(this.itemHandler, type, 9, 16 + index * 18);
            this.func_75146_a(this.slots[index + 1]);
        }
        this.sideInventory = new ContainerHighOvenSideInventory(tile, 0, 0);
        this.addSubContainer((Container)this.sideInventory, true);
        this.addPlayerInventory(inventoryPlayer, 8, 84);
        this.oldHeats = new int[tile.func_70302_i_()];
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_71112_a((Container)this, 0, ((TileHighOven)this.tile).getFuel());
        listener.func_71112_a((Container)this, 1, ((TileHighOven)this.tile).fuelQuality);
        listener.func_71112_a((Container)this, 2, ((TileHighOven)this.tile).getTemperature());
        for (int i = 0; i < this.oldHeats.length; ++i) {
            listener.func_71112_a((Container)this, i + 3, ((TileHighOven)this.tile).getTemperature(i));
        }
    }

    private void sendUpdate(int index, int value) {
        for (IContainerListener crafter : this.field_75149_d) {
            crafter.func_71112_a((Container)this, index, value);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        int value = ((TileHighOven)this.tile).getFuel();
        if (value != this.oldFuel) {
            this.sendUpdate(0, value);
        }
        if ((value = ((TileHighOven)this.tile).fuelQuality) != this.oldFuelQuality) {
            this.sendUpdate(1, value);
        }
        if ((value = ((TileHighOven)this.tile).getTemperature()) != this.oldTemperature) {
            this.sendUpdate(2, value);
        }
        for (int i = 0; i < this.oldHeats.length; ++i) {
            value = ((TileHighOven)this.tile).getTemperature(i);
            if (value == this.oldHeats[i]) continue;
            this.oldHeats[i] = value;
            this.sendUpdate(i + 3, value);
        }
    }

    public void func_75137_b(int id, int data) {
        if (id < 3) {
            ((TileHighOven)this.tile).updateFromPacket(id, data);
        } else {
            ((TileHighOven)this.tile).updateTemperatureFromPacket(id - 3, data);
        }
    }

    private static class SlotAdditive
    extends SlotItemHandler {
        private MixAdditive type;

        public SlotAdditive(IItemHandler itemHandler, MixAdditive type, int xPosition, int yPosition) {
            super(itemHandler, type.getSlotIndex(), xPosition, yPosition);
            this.type = type;
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return !stack.func_190926_b() && TCompRegistry.isValidMixAdditive(stack, this.type);
        }
    }

    private static class SlotFuel
    extends SlotItemHandler {
        public SlotFuel(IItemHandler itemHandler, int xPosition, int yPosition) {
            super(itemHandler, 3, xPosition, yPosition);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return !stack.func_190926_b() && TCompRegistry.isHighOvenFuel(stack);
        }
    }
}

