/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.tile.tickable;

import com.valkyrieofnight.vliblegacy.lib.sys.tile.plugin.ITlePlugin;
import com.valkyrieofnight.vliblegacy.lib.tile.VLTileOwned;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public abstract class VLTileTickable
extends VLTileOwned
implements ITickable {
    private List<ITlePlugin> modules = new ArrayList<ITlePlugin>();
    private long currentTick = 0L;
    private long currentWorldTime = 0L;

    protected void addModule(ITlePlugin module) {
        if (module != null) {
            this.modules.add(module);
        }
    }

    public void onLoad() {
        for (ITlePlugin iTileModule : this.modules) {
            iTileModule.onLoad();
        }
        super.onLoad();
    }

    public final void func_73660_a() {
        if (this.func_145831_w().func_82737_E() == this.currentTick) {
            return;
        }
        this.currentTick = this.func_145831_w().func_82737_E();
        for (ITlePlugin iTileModule : this.modules) {
            iTileModule.update();
        }
        this.updateTile();
    }

    public void updateTile() {
    }

    public void func_145843_s() {
        for (ITlePlugin iTileModule : this.modules) {
            iTileModule.invalidate();
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        for (ITlePlugin iTileModule : this.modules) {
            iTileModule.onChunkUnload();
        }
        super.onChunkUnload();
    }

    @Override
    public NBTTagCompound saveTileData(NBTTagCompound nbt, boolean toItem) {
        super.saveTileData(nbt, toItem);
        for (ITlePlugin iTileModule : this.modules) {
            iTileModule.saveTileData(nbt, toItem);
        }
        return nbt;
    }

    @Override
    public void loadTileData(NBTTagCompound nbt, boolean fromItem) {
        super.loadTileData(nbt, fromItem);
        for (ITlePlugin iTileModule : this.modules) {
            iTileModule.loadTileData(nbt, fromItem);
        }
    }
}

