/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.eplus.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.client.gui.GuiItemButton;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.util.PlayerUtils;
import net.darkhax.eplus.EnchLogic;
import net.darkhax.eplus.EnchantingPlus;
import net.darkhax.eplus.api.event.InfoBoxEvent;
import net.darkhax.eplus.block.tileentity.EnchantmentLogicController;
import net.darkhax.eplus.gui.GuiButtonScroller;
import net.darkhax.eplus.gui.GuiEnchantmentLabel;
import net.darkhax.eplus.inventory.ContainerAdvancedTable;
import net.darkhax.eplus.network.messages.MessageEnchant;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiAdvancedTable
extends GuiContainer {
    private static final ItemStack SPOOKY_BONE = new ItemStack(Items.field_151103_aS);
    private static final ResourceLocation TEXTURE;
    private static final KeyBinding keyBindSneak;
    private GuiButton enchantButton;
    public final List<GuiEnchantmentLabel> enchantmentListAll = new ArrayList<GuiEnchantmentLabel>();
    public final List<GuiEnchantmentLabel> enchantmentList = new ArrayList<GuiEnchantmentLabel>();
    public GuiEnchantmentLabel selected;
    public int listOffset = 0;
    public boolean isSliding;
    public GuiButtonScroller scrollbar;
    String[] tips = new String[]{"description", "books", "treasure", "curse", "storage", "inventory", "armor"};
    private int currentTip = 0;
    private final EnchantmentLogicController logic;

    public GuiAdvancedTable(ContainerAdvancedTable container) {
        super((Container)container);
        this.field_146999_f = 235;
        this.field_147000_g = 182;
        this.currentTip = Constants.RANDOM.nextInt(this.tips.length);
        this.logic = container.logic;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.isSliding = false;
        this.scrollbar = new GuiButtonScroller(this, 1, this.field_147003_i + 206, this.field_147009_r + 16, 12, 15);
        this.enchantButton = new GuiItemButton(0, this.field_147003_i + 35, this.field_147009_r + 38, EnchLogic.isWikedNight(this.logic.getWorld()) ? SPOOKY_BONE : new ItemStack(Items.field_151134_bR));
        this.field_146292_n.add(this.enchantButton);
        this.field_146292_n.add(this.scrollbar);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateLabels();
        this.populateEnchantmentSliders();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tile.eplus.advanced.table.name", (Object[])new Object[0]), 32, 5, 0x404040);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void populateEnchantmentSliders() {
        this.enchantmentListAll.clear();
        int labelCount = 0;
        for (Enchantment enchant : this.logic.getValidEnchantments()) {
            GuiEnchantmentLabel label = new GuiEnchantmentLabel(this, this.logic, enchant, this.logic.getCurrentLevel(enchant), 61 + this.field_147003_i, 15 + this.field_147009_r + labelCount++ * 18);
            label.setCurrentLevel(this.logic.getCurrentLevel(enchant));
            this.enchantmentListAll.add(label);
        }
    }

    public void updateLabels() {
        this.enchantmentList.clear();
        int count = 0;
        for (int i = 0; i < this.enchantmentListAll.size(); ++i) {
            if (i < this.listOffset) continue;
            GuiEnchantmentLabel label = this.enchantmentListAll.get(i);
            label.setyPos(15 + this.field_147009_r + count++ * 18);
            label.setVisible(label.getyPos() >= this.field_147009_r + 15 && label.getyPos() < this.field_147009_r + 87);
            this.enchantmentList.add(label);
        }
        this.lockLabels();
    }

    public void lockLabels() {
        block0: for (GuiEnchantmentLabel label : this.enchantmentListAll) {
            label.setLocked(false);
            Enchantment enchantment = label.getEnchantment();
            for (Map.Entry<Enchantment, Integer> data : this.logic.getCurrentEnchantments().entrySet()) {
                boolean isOverLeveled;
                boolean isIncompatable = enchantment != data.getKey() && data.getValue() > 0 && !data.getKey().func_191560_c(enchantment);
                boolean bl = isOverLeveled = enchantment == data.getKey() && data.getValue() > enchantment.func_77325_b();
                if (!isOverLeveled && !isIncompatable) continue;
                label.setLocked(true);
                continue block0;
            }
        }
    }

    public GuiEnchantmentLabel getLabelUnderMouse(int mx, int my) {
        for (GuiEnchantmentLabel label : this.enchantmentList) {
            if (!label.isMouseOver(mx, my)) continue;
            return label;
        }
        return null;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (GuiEnchantmentLabel label : this.enchantmentList) {
            label.draw(this.field_146289_q);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int eventDWheel = Mouse.getEventDWheel();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.field_147003_i;
        int prevOff = this.listOffset--;
        if (eventDWheel <= 0 && eventDWheel < 0) {
            ++this.listOffset;
        }
        if (this.selected != null) {
            this.selected.updateSlider(mouseX - 62);
        }
        this.listOffset = Math.max(this.listOffset, 0);
        this.listOffset = Math.min(this.listOffset, this.enchantmentListAll.size() - 4);
        if (this.enchantmentList.size() < 4) {
            this.listOffset = 0;
        }
        if (this.listOffset != prevOff) {
            this.updateLabels();
            this.scrollbar.sliderY = 70 / Math.max(1, (this.enchantmentListAll.size() - 4) * this.listOffset - 7);
            this.scrollbar.sliderY = Math.max(1, this.scrollbar.sliderY);
            this.scrollbar.sliderY = Math.min(56, this.scrollbar.sliderY);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.selected = this.getLabelUnderMouse(mouseX, mouseY);
        if (this.selected != null && !this.selected.isLocked() && this.selected.isVisible()) {
            this.selected.setDragging(true);
        } else {
            this.selected = null;
        }
        if (this.enchantmentListAll.size() > 4 && mouseX > this.field_147003_i + 206 && mouseX < this.field_147003_i + 218 && mouseY > this.field_147009_r + 16 + this.scrollbar.sliderY && mouseY < this.field_147009_r + 31 + this.scrollbar.sliderY) {
            this.isSliding = true;
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.selected != null) {
            this.selected.setDragging(false);
            this.selected = null;
            this.lockLabels();
        }
        if (this.isSliding) {
            this.isSliding = false;
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.selected != null) {
            if (mouseX < this.selected.getxPos() || mouseX > this.selected.getxPos() + this.selected.getWidth()) {
                this.selected.setDragging(false);
                this.selected = null;
                return;
            }
            this.lockLabels();
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 0 && this.canClientAfford()) {
            EnchantingPlus.NETWORK.sendToServer((IMessage)new MessageEnchant());
            this.logic.enchantItem();
        }
    }

    protected void func_191948_b(int x, int y) {
        GuiEnchantmentLabel label;
        super.func_191948_b(x, y);
        GuiUtils.drawHoveringText(this.getInfoBox(), (int)this.field_147003_i, (int)(this.field_147009_r + 27), (int)this.field_146999_f, (int)(this.field_147009_r + this.field_147000_g), (int)(this.field_147003_i - 18), (FontRenderer)this.field_146289_q);
        if (this.enchantButton.func_146115_a()) {
            ArrayList<String> text = new ArrayList<String>();
            if (!this.canClientAfford()) {
                text.add(I18n.func_135052_a((String)"gui.eplus.tooltip.tooexpensive", (Object[])new Object[0]));
            } else if (this.logic.getCost() == 0) {
                text.add(I18n.func_135052_a((String)"gui.eplus.tooltip.nochange", (Object[])new Object[0]));
            } else {
                text.add(I18n.func_135052_a((String)"gui.eplus.tooltip.enchant", (Object[])new Object[0]));
            }
            GuiUtils.drawHoveringText(text, (int)x, (int)y, (int)this.field_146294_l, (int)this.field_146295_m, (int)(this.field_146294_l / 4), (FontRenderer)this.field_146289_q);
        }
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak) && (label = this.getLabelUnderMouse(x, y)) != null && label.isVisible()) {
            GuiUtils.drawHoveringText(Collections.singletonList(label.getDescription()), (int)x, (int)y, (int)this.field_146294_l, (int)this.field_146295_m, (int)(this.field_146294_l / 3), (FontRenderer)this.field_146289_q);
        }
    }

    private List<String> getInfoBox() {
        ArrayList<String> info = new ArrayList<String>();
        if (this.logic.getInventory().getEnchantingStack().func_190926_b()) {
            info.add(I18n.func_135052_a((String)"gui.eplus.info.noitem", (Object[])new Object[0]));
        } else if (this.enchantmentListAll.isEmpty()) {
            info.add(I18n.func_135052_a((String)"gui.eplus.info.noench", (Object[])new Object[0]));
        } else {
            boolean isCreative = PlayerUtils.getClientPlayerSP().func_184812_l_();
            int playerXP = isCreative ? Integer.MAX_VALUE : EnchLogic.getExperience(this.logic.getPlayer());
            int cost = this.logic.getCost();
            info.add(isCreative ? I18n.func_135052_a((String)"eplus.info.infinity", (Object[])new Object[0]) : I18n.func_135052_a((String)"eplus.info.playerxp", (Object[])new Object[]{playerXP}));
            info.add(I18n.func_135052_a((String)"eplus.info.costxp", (Object[])new Object[]{cost}));
            info.add(I18n.func_135052_a((String)"eplus.info.power", (Object[])new Object[]{Float.valueOf(this.logic.getEnchantmentPower())}) + "%");
            if (cost > playerXP) {
                info.add(" ");
                info.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.eplus.info.tooexpensive", (Object[])new Object[0]));
            }
        }
        info.add(" ");
        info.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"eplus.info.tip.prefix", (Object[])new Object[0]) + TextFormatting.RESET + I18n.func_135052_a((String)("eplus.info.tip." + this.tips[this.currentTip]), (Object[])new Object[]{keyBindSneak.getDisplayName()}));
        if (PlayerUtils.isPlayersBirthdate((EntityPlayer)PlayerUtils.getClientPlayerSP())) {
            info.add(" ");
            info.add(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"eplus.info.tip.bonus", (Object[])new Object[0]) + TextFormatting.RESET + I18n.func_135052_a((String)"eplus.info.tip.birthday", (Object[])new Object[0]));
        }
        MinecraftForge.EVENT_BUS.post((Event)new InfoBoxEvent(this, info));
        return info;
    }

    public boolean canClientAfford() {
        return this.logic.getCost() <= EnchLogic.getExperience(this.logic.getPlayer()) || PlayerUtils.getClientPlayerSP().func_184812_l_();
    }

    static {
        SPOOKY_BONE.func_77966_a(Enchantments.field_180308_g, 1);
        TEXTURE = new ResourceLocation("eplus", "textures/gui/enchant.png");
        keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
    }
}

