/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.degradation.effect;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.core.algorithm.OrganicSpread;
import org.cyclops.evilcraft.core.config.configurable.ConfigurableDegradationEffect;
import org.cyclops.evilcraft.core.config.extendedconfig.DegradationEffectConfig;
import org.cyclops.evilcraft.world.biome.BiomeDegraded;

public class BiomeDegradation
extends ConfigurableDegradationEffect
implements OrganicSpread.IOrganicSpreadable {
    private static BiomeDegradation _instance = null;
    private static final Class<? extends Biome> BIOME_CLASS = BiomeDegraded.class;
    private static final Biome BIOME = BiomeDegraded.getInstance();
    private static final int DIMENSIONS = 2;

    public static BiomeDegradation getInstance() {
        return _instance;
    }

    public BiomeDegradation(ExtendedConfig<DegradationEffectConfig> eConfig) {
        super(eConfig);
    }

    @Override
    public boolean canRun(IDegradable degradable) {
        return true;
    }

    @Override
    public void runClientSide(IDegradable degradable) {
    }

    @Override
    public void runServerSide(IDegradable degradable) {
        OrganicSpread spread = new OrganicSpread(degradable.getDegradationWorld(), 2, degradable.getRadius(), this);
        spread.spreadTick(LocationHelpers.copyLocation((BlockPos)degradable.getLocation()));
    }

    @Override
    public boolean isDone(World world, BlockPos location) {
        return world.func_180494_b(location).getClass().equals(BIOME_CLASS);
    }

    @Override
    public void spreadTo(World world, BlockPos location) {
        WorldHelpers.setBiome((World)world, (BlockPos)location, (Biome)BIOME);
    }
}

