/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.advancements.AetherAdvancements;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.player.IPlayerAether;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.portal.BlockAetherPortal;
import com.gildedgames.the_aether.entities.bosses.EntityValkyrie;
import com.gildedgames.the_aether.entities.passive.mountable.EntityAerbunny;
import com.gildedgames.the_aether.entities.passive.mountable.EntityFlyingCow;
import com.gildedgames.the_aether.entities.projectile.darts.EntityDartBase;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.items.accessories.ItemAccessoryDyable;
import com.gildedgames.the_aether.items.dungeon.ItemDungeonKey;
import com.gildedgames.the_aether.items.tools.ItemSkyrootBucket;
import com.gildedgames.the_aether.items.util.EnumSkyrootBucketType;
import com.gildedgames.the_aether.items.weapons.ItemSkyrootSword;
import com.gildedgames.the_aether.networking.AetherNetworkingManager;
import com.gildedgames.the_aether.networking.packets.PacketExtendedAttack;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AetherEventHandler {
    @SubscribeEvent
    public void checkBlockBannedEvent(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack currentStack = event.getItemStack();
        if (player.field_71093_bK == AetherConfig.dimension.aether_dimension_id) {
            if (currentStack.func_77973_b() == Items.field_151033_d || currentStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) || currentStack.func_77973_b() == Items.field_151059_bz) {
                for (int i = 0; i < 10; ++i) {
                    event.getWorld().func_175688_a(EnumParticleTypes.SMOKE_LARGE, event.getHitVec().field_72450_a, event.getHitVec().field_72448_b, event.getHitVec().field_72449_c, 0.0, 0.0, 0.0, new int[0]);
                }
                event.setCanceled(true);
            } else if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150324_C) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onMilkedCow(PlayerInteractEvent.EntityInteractSpecific event) {
        EntityPlayer player;
        ItemStack heldItem;
        if ((event.getTarget() instanceof EntityCow || event.getTarget() instanceof EntityFlyingCow) && (heldItem = (player = event.getEntityPlayer()).func_184586_b(event.getHand())).func_77973_b() == ItemsAether.skyroot_bucket && EnumSkyrootBucketType.getType(heldItem.func_77960_j()) == EnumSkyrootBucketType.Empty) {
            heldItem.func_190918_g(1);
            if (heldItem.func_190926_b()) {
                event.getEntityPlayer().func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
                player.func_184611_a(event.getHand(), new ItemStack(ItemsAether.skyroot_bucket, 1, EnumSkyrootBucketType.Milk.meta));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack(ItemsAether.skyroot_bucket, 1, EnumSkyrootBucketType.Milk.meta))) {
                player.func_71019_a(new ItemStack(ItemsAether.skyroot_bucket, 1, EnumSkyrootBucketType.Milk.meta), false);
            }
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        boolean validDimension;
        World worldObj = event.getWorld();
        RayTraceResult target = event.getTarget();
        ItemStack stack = event.getEmptyBucket();
        EntityPlayer player = event.getEntityPlayer();
        boolean isWater = !AetherConfig.gameplay_changes.skyroot_bucket_only && stack.func_77973_b() == Items.field_151131_as || stack.func_77973_b() == ItemsAether.skyroot_bucket && stack.func_77960_j() == 1;
        boolean isLava = stack.func_77973_b() == Items.field_151129_at;
        boolean bl = validDimension = player.field_71093_bK == 0 || player.field_71093_bK == AetherConfig.dimension.aether_dimension_id;
        if (target != null && target.field_72313_a == RayTraceResult.Type.BLOCK && validDimension) {
            BlockPos hitPos = target.func_178782_a().func_177972_a(target.field_178784_b);
            if (isWater && ((BlockAetherPortal)BlocksAether.aether_portal).func_176548_d(worldObj, hitPos)) {
                event.getEntityPlayer().func_184185_a(SoundEvents.field_187549_bG, 1.0f, 1.0f);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (stack.func_77973_b() == ItemsAether.skyroot_bucket || stack.func_77952_i() == 1) {
                        event.setFilledBucket(new ItemStack(ItemsAether.skyroot_bucket));
                    }
                    if (stack.func_77973_b() == Items.field_151131_as) {
                        event.setFilledBucket(new ItemStack(Items.field_151133_ar));
                    }
                }
                event.setResult(Event.Result.ALLOW);
            }
            if (isLava && player.field_71093_bK == AetherConfig.dimension.aether_dimension_id) {
                if (player.field_71075_bZ.field_75098_d && player.func_70093_af()) {
                    return;
                }
                if (worldObj.func_175623_d(hitPos)) {
                    worldObj.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)hitPos.func_177958_n() + 0.5, (double)(hitPos.func_177956_o() + 1), (double)hitPos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
                    event.getEntityPlayer().func_184185_a(SoundEvents.field_187541_bC, 1.0f, 1.0f);
                    worldObj.func_175656_a(hitPos, BlocksAether.aerogel.func_176223_P());
                    if (!player.field_71075_bZ.field_75098_d) {
                        event.setFilledBucket(new ItemStack(Items.field_151133_ar));
                    }
                }
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            if (this.isGravititeTool(event.crafting.func_77973_b())) {
                AetherAdvancements.GRAV_TOOLSET_TRIGGER.trigger((EntityPlayerMP)event.player);
            }
            AetherAdvancements.CRAFT_ITEM_TRIGGER.trigger((EntityPlayerMP)event.player, event.crafting);
        }
    }

    @SubscribeEvent
    public void onEntityDropLoot(LivingDropsEvent event) {
        if (event.getSource() instanceof EntityDamageSource) {
            EntityLivingBase entity = event.getEntityLiving();
            EntityDamageSource source = (EntityDamageSource)event.getSource();
            if (source.func_76364_f() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)source.func_76364_f();
                ItemStack currentItem = player.field_71071_by.func_70448_g();
                if (currentItem.func_77973_b() instanceof ItemSkyrootSword && !(entity instanceof EntityPlayer) && !(entity instanceof EntityWither) && !(entity instanceof EntityValkyrie)) {
                    for (EntityItem items : event.getDrops()) {
                        ItemStack stack = items.func_92059_d();
                        if (stack.func_77973_b() instanceof ItemDungeonKey || stack.func_77973_b() == ItemsAether.victory_medal || stack.func_77973_b() == Items.field_151144_bL) continue;
                        EntityItem item = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, items.func_92059_d());
                        entity.field_70170_p.func_72838_d((Entity)item);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player.field_71071_by.func_70448_g().func_77973_b() == ItemsAether.lightning_sword || player.field_71071_by.func_70448_g().func_77973_b() == ItemsAether.lightning_knife) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDamage(LivingAttackEvent event) {
        EntityAerbunny aerbunny;
        if (event.getEntityLiving() instanceof EntityAerbunny && (aerbunny = (EntityAerbunny)event.getEntityLiving()).func_184218_aH() && aerbunny.func_184187_bx() instanceof EntityPlayer) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityAttack(AttackEntityEvent event) {
        String s;
        if (event.getEntityPlayer().func_184614_ca().func_77973_b() == ItemsAether.flaming_sword) {
            if (event.getTarget().func_70075_an() && !event.getTarget().func_85031_j((Entity)event.getEntityPlayer()) && event.getTarget() instanceof EntityLivingBase) {
                int defaultTime = 30;
                int fireAspectModifier = EnchantmentHelper.func_90036_a((EntityLivingBase)event.getEntityPlayer());
                if (fireAspectModifier > 0) {
                    defaultTime += fireAspectModifier * 4;
                }
                event.getTarget().func_70015_d(defaultTime);
            }
        } else if (event.getEntityPlayer().func_184614_ca().func_77973_b() == ItemsAether.pig_slayer && (s = EntityList.func_75621_b((Entity)event.getTarget())) != null && (s.toLowerCase().contains("pig") || s.toLowerCase().contains("phyg") || s.toLowerCase().contains("taegore") || event.getTarget().func_110124_au().toString().equals("1d680bb6-2a9a-4f25-bf2f-a1af74361d69")) && event.getTarget().field_70170_p.field_72995_K) {
            Random rand = new Random();
            for (int j = 0; j < 20; ++j) {
                double d = rand.nextGaussian() * 0.02;
                double d1 = rand.nextGaussian() * 0.02;
                double d2 = rand.nextGaussian() * 0.02;
                double d3 = 5.0;
                event.getTarget().field_70170_p.func_175688_a(EnumParticleTypes.FLAME, event.getTarget().field_70165_t + (double)(rand.nextFloat() * event.getTarget().field_70130_N * 2.0f) - (double)event.getTarget().field_70130_N - d * d3, event.getTarget().field_70163_u + (double)(rand.nextFloat() * event.getTarget().field_70131_O) - d1 * d3, event.getTarget().field_70161_v + (double)(rand.nextFloat() * event.getTarget().field_70130_N * 2.0f) - (double)event.getTarget().field_70130_N - d2 * d3, d, d1, d2, new int[0]);
            }
        }
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        if (event.getEntity() instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)event.getEntity();
            if (!arrow.field_70170_p.field_72995_K && event.getRayTraceResult() != null && event.getRayTraceResult().field_72308_g != null && arrow.field_70250_c != null) {
                if (!arrow.field_70250_c.func_184188_bt().isEmpty() && event.getRayTraceResult().field_72308_g == arrow.field_70250_c.func_184188_bt().get(0)) {
                    event.setCanceled(true);
                } else if (event.getEntity() instanceof EntityDartBase) {
                    EntityDartBase entityDartBase = (EntityDartBase)event.getEntity();
                    if (event.getRayTraceResult().field_72308_g != entityDartBase.field_70250_c && event.getRayTraceResult().field_72313_a == RayTraceResult.Type.ENTITY) {
                        entityDartBase.func_70106_y();
                    } else {
                        entityDartBase.func_189654_d(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        IBlockState block;
        if (event.getHand() == EnumHand.MAIN_HAND && (block = event.getWorld().func_180495_p(event.getPos())).func_177230_c() == Blocks.field_150383_bp) {
            BlockCauldron cauldron = (BlockCauldron)block.func_177230_c();
            int waterLevel = (Integer)block.func_177229_b((IProperty)BlockCauldron.field_176591_a);
            if (event.getItemStack().func_77973_b() == ItemsAether.leather_gloves) {
                ItemAccessoryDyable gloves = (ItemAccessoryDyable)event.getItemStack().func_77973_b();
                if (waterLevel > 0 && gloves.hasColor(event.getItemStack()) && !event.getWorld().field_72995_K) {
                    gloves.removeColor(event.getItemStack());
                    cauldron.func_176590_a(event.getWorld(), event.getPos(), block, waterLevel - 1);
                    event.getEntityPlayer().func_71029_a(StatList.field_188079_M);
                }
            }
            if (event.getItemStack().func_77973_b() == ItemsAether.skyroot_bucket) {
                ItemSkyrootBucket bucket = (ItemSkyrootBucket)event.getItemStack().func_77973_b();
                if (EnumSkyrootBucketType.getType(bucket.getMetadata(event.getItemStack())) == EnumSkyrootBucketType.Water) {
                    if (waterLevel < 3 && !event.getWorld().field_72995_K) {
                        if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                            event.getEntityPlayer().func_184611_a(event.getHand(), new ItemStack(ItemsAether.skyroot_bucket, 1, EnumSkyrootBucketType.Empty.meta));
                        }
                        event.getEntityPlayer().func_71029_a(StatList.field_188077_K);
                        cauldron.func_176590_a(event.getWorld(), event.getPos(), block, 3);
                        event.getEntityPlayer().field_70170_p.func_184133_a(null, event.getPos(), SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                } else if (EnumSkyrootBucketType.getType(bucket.getMetadata(event.getItemStack())) == EnumSkyrootBucketType.Empty && waterLevel == 3 && !event.getWorld().field_72995_K) {
                    if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                        event.getItemStack().func_190918_g(1);
                        if (event.getItemStack().func_190926_b()) {
                            event.getEntityPlayer().func_184611_a(event.getHand(), new ItemStack(ItemsAether.skyroot_bucket, 1, EnumSkyrootBucketType.Water.meta));
                        } else if (!event.getEntityPlayer().field_71071_by.func_70441_a(new ItemStack(ItemsAether.skyroot_bucket, 1, EnumSkyrootBucketType.Water.meta))) {
                            event.getEntityPlayer().func_71019_a(new ItemStack(ItemsAether.skyroot_bucket, 1, EnumSkyrootBucketType.Water.meta), false);
                        }
                    }
                    event.getEntityPlayer().func_71029_a(StatList.field_188078_L);
                    cauldron.func_176590_a(event.getWorld(), event.getPos(), block, 0);
                    event.getWorld().func_184133_a(null, event.getPos(), SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerWakeUpEvent event) {
        World world = event.getEntityPlayer().field_70170_p;
        if (!world.field_72995_K && event.getEntityPlayer().field_71093_bK == AetherConfig.dimension.aether_dimension_id) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            WorldServer worldServer = server.func_71218_a(0);
            if (worldServer.field_73010_i.size() > 0) {
                if (worldServer.func_73056_e()) {
                    this.performTimeSet(event, world, worldServer);
                }
            } else {
                this.performTimeSet(event, world, worldServer);
            }
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        IPlayerAether playerAether;
        if (event.getEntityLiving() instanceof EntityPlayer && ((playerAether = AetherAPI.getInstance().get((EntityPlayer)event.getEntityLiving())).getAccessoryInventory().wearingArmor(new ItemStack(ItemsAether.sentry_boots)) || playerAether.getAccessoryInventory().isWearingGravititeSet() || playerAether.getAccessoryInventory().isWearingValkyrieSet())) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void interact(PlayerInteractEvent.LeftClickEmpty event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        this.handleExtendedReach(player, stack);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void interact(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        this.handleExtendedReach(player, stack);
    }

    private void handleExtendedReach(EntityPlayer player, ItemStack stack) {
        if (this.isValkyrieItem(stack.func_77973_b())) {
            Vec3d playerVision = player.func_70040_Z();
            AxisAlignedBB reachDistance = player.func_174813_aQ().func_186662_g(10.0);
            List locatedEntities = player.field_70170_p.func_72872_a(Entity.class, reachDistance);
            Entity found = null;
            double foundLen = 0.0;
            for (Object o : locatedEntities) {
                double dot;
                Vec3d vec;
                double len;
                Entity ent;
                if (o == player || !(ent = (Entity)o).func_70067_L() && !(ent instanceof EntityDragon) || (len = (vec = new Vec3d(ent.field_70165_t - player.field_70165_t, ent.func_174813_aQ().field_72338_b + (double)(ent.field_70131_O / 2.0f) - player.field_70163_u - (double)player.func_70047_e(), ent.field_70161_v - player.field_70161_v)).func_72433_c()) > 8.0 || (dot = playerVision.func_72430_b(vec = vec.func_72432_b())) < 1.0 - 0.125 / len || !player.func_70685_l(ent) || foundLen != 0.0 && !(len < foundLen)) continue;
                found = ent;
                foundLen = len;
            }
            if (found != null && player.func_184187_bx() != found) {
                stack.func_77972_a(1, (EntityLivingBase)player);
                AetherNetworkingManager.sendToServer(new PacketExtendedAttack(found.func_145782_y()));
            }
        }
    }

    private void performTimeSet(PlayerWakeUpEvent event, World world, WorldServer worldServer) {
        if (world.func_82736_K().func_82766_b("doDaylightCycle") && event.getEntityPlayer().func_71026_bH()) {
            long i = worldServer.func_72912_H().func_76073_f() + 24000L;
            worldServer.func_72912_H().func_76068_b(i - i % 24000L);
        }
    }

    public boolean isGravititeTool(Item stackID) {
        return stackID == ItemsAether.gravitite_shovel || stackID == ItemsAether.gravitite_axe || stackID == ItemsAether.gravitite_pickaxe;
    }

    public boolean isValkyrieItem(Item stackID) {
        return stackID == ItemsAether.valkyrie_shovel || stackID == ItemsAether.valkyrie_axe || stackID == ItemsAether.valkyrie_pickaxe || stackID == ItemsAether.valkyrie_lance;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        for (Entity entity : event.world.field_72996_f) {
            EntityItem entityItem;
            if (!(entity instanceof EntityItem) || (entityItem = (EntityItem)entity).func_92059_d().func_77973_b() != ItemsAether.dungeon_key) continue;
            ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)entityItem, (Object)true, (String[])new String[]{"invulnerable", "field_83001_bt"});
        }
    }
}

