/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.player;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.api.player.IPlayerAether;
import com.gildedgames.the_aether.api.player.util.IAccessoryInventory;
import com.gildedgames.the_aether.api.player.util.IAetherAbility;
import com.gildedgames.the_aether.api.player.util.IAetherBoss;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.containers.inventory.InventoryAccessories;
import com.gildedgames.the_aether.entities.passive.mountable.EntityParachute;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.networking.AetherNetworkingManager;
import com.gildedgames.the_aether.networking.packets.PacketAccessory;
import com.gildedgames.the_aether.networking.packets.PacketCapeChanged;
import com.gildedgames.the_aether.networking.packets.PacketGloveSizeChanged;
import com.gildedgames.the_aether.networking.packets.PacketGlovesChanged;
import com.gildedgames.the_aether.networking.packets.PacketPerkChanged;
import com.gildedgames.the_aether.networking.packets.PacketPortalItem;
import com.gildedgames.the_aether.networking.packets.PacketSendPoisonTime;
import com.gildedgames.the_aether.networking.packets.PacketSendSeenDialogue;
import com.gildedgames.the_aether.player.abilities.AbilityAccessories;
import com.gildedgames.the_aether.player.abilities.AbilityArmor;
import com.gildedgames.the_aether.player.abilities.AbilityFlight;
import com.gildedgames.the_aether.player.abilities.AbilityRepulsion;
import com.gildedgames.the_aether.player.perks.AetherRankings;
import com.gildedgames.the_aether.player.perks.util.DonatorMoaSkin;
import com.gildedgames.the_aether.player.perks.util.EnumAetherPerkType;
import com.gildedgames.the_aether.world.TeleporterAether;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PlayerAether
implements IPlayerAether {
    public EntityPlayer thePlayer;
    private UUID healthUUID = UUID.fromString("df6eabe7-6947-4a56-9099-002f90370706");
    private UUID extendedReachUUID = UUID.fromString("df6eabe7-6947-4a56-9099-002f90370707");
    private AttributeModifier healthModifier;
    private AttributeModifier reachModifier;
    public IAccessoryInventory accessories;
    public float wingSinage;
    public IAetherBoss currentBoss;
    private final ArrayList<IAetherAbility> abilities = new ArrayList();
    public final ArrayList<Entity> clouds = new ArrayList(2);
    private boolean isJumping;
    public int lifeShardsUsed;
    public float prevPortalAnimTime;
    public float portalAnimTime;
    public int timeInPortal;
    public boolean hasTeleported = false;
    public boolean inPortal = false;
    public boolean shouldPlayPortalSound = false;
    private String cooldownName = "Hammer of Notch";
    private int cooldown;
    private int cooldownMax;
    public boolean shouldRenderHalo;
    public boolean shouldRenderGlow;
    public boolean shouldRenderCape;
    public boolean shouldRenderGloves;
    public boolean gloveSize;
    public boolean seenSpiritDialog = false;
    public boolean isPoisoned = false;
    public boolean isCured = false;
    public int poisonTime = 0;
    public int cureTime = 0;
    public boolean shouldGetPortal;
    public DonatorMoaSkin donatorMoaSkin;
    public List<Item> extendedReachItems = Arrays.asList(ItemsAether.valkyrie_shovel, ItemsAether.valkyrie_pickaxe, ItemsAether.valkyrie_axe);

    public PlayerAether() {
    }

    public PlayerAether(EntityPlayer player) {
        this.thePlayer = player;
        this.shouldRenderHalo = true;
        this.shouldRenderGlow = false;
        this.shouldRenderCape = true;
        this.shouldRenderGloves = true;
        this.gloveSize = false;
        this.shouldGetPortal = true;
        this.donatorMoaSkin = new DonatorMoaSkin();
        this.accessories = new InventoryAccessories(player);
        this.reachModifier = new AttributeModifier(this.extendedReachUUID, "Aether Reach Modifier", 3.0, 0);
        this.abilities.addAll(Arrays.asList(new AbilityArmor(this), new AbilityAccessories(this), new AbilityFlight(this), new AbilityRepulsion(this)));
    }

    @Override
    public void onUpdate() {
        EntityLiving boss;
        int i;
        if (!this.thePlayer.field_70170_p.field_72995_K) {
            AetherNetworkingManager.sendToAll(new PacketPerkChanged(this.getEntity().func_145782_y(), EnumAetherPerkType.Halo, this.shouldRenderHalo));
            AetherNetworkingManager.sendToAll(new PacketPerkChanged(this.getEntity().func_145782_y(), EnumAetherPerkType.Glow, this.shouldRenderGlow));
            AetherNetworkingManager.sendToAll(new PacketCapeChanged(this.getEntity().func_145782_y(), this.shouldRenderCape));
            AetherNetworkingManager.sendToAll(new PacketGlovesChanged(this.getEntity().func_145782_y(), this.shouldRenderGloves));
            AetherNetworkingManager.sendToAll(new PacketSendPoisonTime(this.getEntity(), this.poisonTime));
            AetherNetworkingManager.sendToAll(new PacketSendSeenDialogue(this.getEntity(), this.seenSpiritDialog));
            AetherNetworkingManager.sendToAll(new PacketPortalItem(this.getEntity(), this.shouldGetPortal));
            AetherNetworkingManager.sendToAll(new PacketGloveSizeChanged(this.getEntity().func_145782_y(), this.gloveSize));
        }
        if (this.isPoisoned) {
            if (this.poisonTime > 0) {
                --this.poisonTime;
            } else {
                this.poisonTime = 0;
                this.isPoisoned = false;
            }
        }
        if (this.isCured) {
            if (this.cureTime > 0) {
                --this.cureTime;
            } else {
                this.cureTime = 0;
                this.isCured = false;
            }
        }
        if (this.inPortal && this.thePlayer.field_70170_p.field_72995_K && this.portalAnimTime == 0.0f) {
            this.shouldPlayPortalSound = true;
        }
        for (i = 0; i < this.abilities.size(); ++i) {
            IAetherAbility ability = this.abilities.get(i);
            if (!ability.shouldExecute()) continue;
            ability.onUpdate();
        }
        for (i = 0; i < this.clouds.size(); ++i) {
            Entity entity = this.clouds.get(i);
            if (!entity.field_70128_L) continue;
            this.clouds.remove(i);
        }
        this.wingSinage = !this.thePlayer.field_70122_E && this.thePlayer.func_184218_aH() && !this.thePlayer.func_184187_bx().field_70122_E ? (this.wingSinage += 0.75f) : (this.wingSinage += 0.15f);
        this.wingSinage = this.wingSinage > 6.283186f ? (this.wingSinage -= 6.283186f) : (this.wingSinage += 0.1f);
        if (this.currentBoss instanceof EntityLiving && ((boss = (EntityLiving)this.currentBoss).func_110143_aJ() <= 0.0f || boss.field_70128_L || Math.sqrt(Math.pow(boss.field_70165_t - this.thePlayer.field_70165_t, 2.0) + Math.pow(boss.field_70163_u - this.thePlayer.field_70163_u, 2.0) + Math.pow(boss.field_70161_v - this.thePlayer.field_70161_v, 2.0)) > 50.0)) {
            this.currentBoss = null;
        }
        if (this.isInBlock(BlocksAether.aercloud)) {
            this.thePlayer.field_70143_R = 0.0f;
        }
        if (this.getHammerCooldown() > 0) {
            --this.cooldown;
        }
        if (this.thePlayer.field_70181_x < -2.0) {
            this.activateParachute();
        }
        if (this.thePlayer.field_71093_bK == AetherConfig.dimension.aether_dimension_id && this.thePlayer.field_70163_u < -2.0 && !this.thePlayer.func_184218_aH()) {
            this.teleportPlayer(false);
        }
        this.updatePlayerReach();
        if (this.thePlayer.field_70170_p.field_72995_K) {
            this.prevPortalAnimTime = this.portalAnimTime;
            if (this.inPortal) {
                this.portalAnimTime += 0.0125f;
                this.inPortal = false;
            } else {
                if (this.portalAnimTime > 0.0f) {
                    this.portalAnimTime -= 0.05f;
                }
                if (this.portalAnimTime < 0.0f) {
                    this.portalAnimTime = 0.0f;
                }
            }
        } else if (this.inPortal) {
            int transferDimension;
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            int previousDimension = this.thePlayer.field_71093_bK;
            int n = transferDimension = previousDimension == AetherConfig.dimension.aether_dimension_id ? 0 : AetherConfig.dimension.aether_dimension_id;
            if (this.thePlayer.field_71088_bW <= 0) {
                int limit = this.thePlayer.func_82145_z();
                if (this.timeInPortal >= limit) {
                    this.timeInPortal = 0;
                    this.thePlayer.field_71088_bW = this.thePlayer.func_82147_ab();
                    this.thePlayer.changeDimension(transferDimension, (ITeleporter)new TeleporterAether(true, server.func_71218_a(transferDimension)));
                } else {
                    ++this.timeInPortal;
                }
            } else {
                this.thePlayer.field_71088_bW = this.thePlayer.func_82147_ab();
            }
            this.inPortal = false;
        } else {
            if (this.timeInPortal < 0) {
                this.timeInPortal = 0;
            }
            if (this.timeInPortal > 0) {
                this.timeInPortal -= 4;
            }
        }
    }

    public boolean onPlayerAttacked(DamageSource source) {
        return this.getAccessoryInventory().isWearingPhoenixSet() && source.func_76347_k();
    }

    public void onPlayerDeath() {
        this.isPoisoned = false;
        this.poisonTime = 0;
        this.isCured = false;
        this.cureTime = 0;
    }

    public void dropAccessories() {
        if (!this.thePlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            this.accessories.dropAccessories();
        }
    }

    public void onPlayerRespawn() {
        this.updateShardCount(0);
        this.thePlayer.func_70606_j(this.thePlayer.func_110138_aP());
        this.updateAccessories();
    }

    public void onChangedDimension(int toDim, int fromDim) {
        this.updateAccessories();
    }

    @Override
    public void saveNBTData(NBTTagCompound output) {
        if (AetherRankings.isRankedPlayer(this.thePlayer.func_110124_au())) {
            output.func_74757_a("halo", this.shouldRenderHalo);
        }
        if (AetherRankings.isDeveloper(this.thePlayer.func_110124_au())) {
            output.func_74757_a("glow", this.shouldRenderGlow);
        }
        output.func_74757_a("poisoned", this.isPoisoned);
        output.func_74768_a("poison_time", this.poisonTime);
        output.func_74757_a("cape", this.shouldRenderCape);
        output.func_74757_a("gloves", this.shouldRenderGloves);
        output.func_74757_a("glove_size", this.gloveSize);
        output.func_74757_a("seen_spirit_dialog", this.seenSpiritDialog);
        output.func_74757_a("get_portal", this.shouldGetPortal);
        output.func_74768_a("hammer_cooldown", this.cooldown);
        output.func_74778_a("notch_hammer_name", this.cooldownName);
        output.func_74768_a("max_hammer_cooldown", this.cooldownMax);
        output.func_74776_a("shard_count", (float)this.lifeShardsUsed);
        this.accessories.writeToNBT(output);
    }

    @Override
    public void loadNBTData(NBTTagCompound input) {
        if (input.func_74764_b("halo")) {
            this.shouldRenderHalo = input.func_74767_n("halo");
        }
        if (input.func_74764_b("glow")) {
            this.shouldRenderGlow = input.func_74767_n("glow");
        }
        if (input.func_74764_b("cape")) {
            this.shouldRenderCape = input.func_74767_n("cape");
        }
        if (input.func_74764_b("gloves")) {
            this.shouldRenderGloves = input.func_74767_n("gloves");
        }
        if (input.func_74764_b("glove_size")) {
            this.gloveSize = input.func_74767_n("glove_size");
        }
        if (input.func_74764_b("shards_used")) {
            input.func_74768_a("shard_count", (int)(input.func_74760_g("shards_used") / 2.0f));
        }
        if (input.func_74764_b("seen_spirit_dialog")) {
            this.seenSpiritDialog = input.func_74767_n("seen_spirit_dialog");
        }
        if (input.func_74764_b("get_portal")) {
            this.shouldGetPortal = input.func_74767_n("get_portal");
        }
        if (input.func_74764_b("poisoned")) {
            this.isPoisoned = input.func_74767_n("poisoned");
        }
        if (input.func_74764_b("poison_time")) {
            this.poisonTime = input.func_74762_e("poison_time");
        }
        this.cooldown = input.func_74762_e("hammer_cooldown");
        this.cooldownName = input.func_74779_i("notch_hammer_name");
        this.cooldownMax = input.func_74762_e("max_hammer_cooldown");
        this.updateShardCount(input.func_74762_e("shard_count"));
        this.accessories.readFromNBT(input);
    }

    public float getCurrentPlayerStrVsBlock(float original) {
        float f = original;
        if (this.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsAether.zanite_pendant))) {
            f *= 1.0f + (float)((InventoryAccessories)this.accessories).getStackFromItem(ItemsAether.zanite_pendant).func_77952_i() / ((float)((InventoryAccessories)this.accessories).getStackFromItem(ItemsAether.zanite_pendant).func_77958_k() * 3.0f);
        }
        if (this.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsAether.zanite_ring))) {
            f *= 1.0f + (float)((InventoryAccessories)this.accessories).getStackFromItem(ItemsAether.zanite_ring).func_77952_i() / ((float)((InventoryAccessories)this.accessories).getStackFromItem(ItemsAether.zanite_ring).func_77958_k() * 3.0f);
        }
        return f == original ? original : f + original;
    }

    public void updatePlayerReach() {
        ItemStack stack = this.thePlayer.func_184614_ca();
        if (!this.thePlayer.func_110148_a(EntityPlayer.REACH_DISTANCE).func_180374_a(this.reachModifier) && this.extendedReachItems.contains(stack.func_77973_b())) {
            this.thePlayer.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111121_a(this.reachModifier);
        } else if (this.thePlayer.func_110148_a(EntityPlayer.REACH_DISTANCE).func_180374_a(this.reachModifier) && !this.extendedReachItems.contains(stack.func_77973_b())) {
            this.thePlayer.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111124_b(this.reachModifier);
        }
    }

    public void teleportPlayer(boolean shouldSpawnPortal) {
        if (this.thePlayer instanceof EntityPlayerMP) {
            int transferDimension;
            int previousDimension = this.thePlayer.field_71093_bK;
            int n = transferDimension = previousDimension == AetherConfig.dimension.aether_dimension_id ? 0 : AetherConfig.dimension.aether_dimension_id;
            if (ForgeHooks.onTravelToDimension((Entity)this.thePlayer, (int)transferDimension)) {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                TeleporterAether teleporter = new TeleporterAether(shouldSpawnPortal, server.func_71218_a(transferDimension));
                for (Entity passenger : this.thePlayer.func_184188_bt()) {
                    PlayerAether.transferEntity(shouldSpawnPortal, passenger, server.func_71218_a(previousDimension), server.func_71218_a(transferDimension));
                    passenger.func_184210_p();
                }
                server.func_184103_al().transferPlayerToDimension((EntityPlayerMP)this.thePlayer, transferDimension, (Teleporter)teleporter);
                if (this.thePlayer.func_184187_bx() != null) {
                    this.thePlayer.func_184210_p();
                }
            }
        }
    }

    private static void transferEntity(boolean shouldSpawnPortal, Entity entityIn, WorldServer previousWorldIn, WorldServer newWorldIn) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        entityIn.field_71093_bK = newWorldIn.field_73011_w.getDimension();
        previousWorldIn.func_72973_f(entityIn);
        entityIn.field_70128_L = false;
        server.func_184103_al().transferEntityToWorld(entityIn, previousWorldIn.field_73011_w.getDimension(), previousWorldIn, newWorldIn, (Teleporter)new TeleporterAether(shouldSpawnPortal, newWorldIn));
    }

    private void activateParachute() {
        if (!this.thePlayer.field_71075_bZ.field_75098_d) {
            EntityParachute parachute = null;
            ItemStack itemstack = null;
            for (int i = 0; i < this.thePlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackInSlot = this.thePlayer.field_71071_by.func_70301_a(i);
                if (stackInSlot.func_77973_b() == ItemsAether.cloud_parachute) {
                    itemstack = stackInSlot;
                    break;
                }
                if (stackInSlot.func_77973_b() != ItemsAether.golden_parachute) continue;
                itemstack = stackInSlot;
                break;
            }
            if (itemstack != null) {
                if (itemstack.func_77973_b() == ItemsAether.cloud_parachute) {
                    parachute = new EntityParachute(this.thePlayer.field_70170_p, this.thePlayer, false);
                    parachute.func_70107_b(this.thePlayer.field_70165_t, this.thePlayer.field_70163_u, this.thePlayer.field_70161_v);
                    this.thePlayer.field_70170_p.func_72838_d((Entity)parachute);
                    this.thePlayer.field_71071_by.func_184437_d(itemstack);
                } else if (itemstack.func_77973_b() == ItemsAether.golden_parachute) {
                    itemstack.func_77972_a(1, (EntityLivingBase)this.thePlayer);
                    parachute = new EntityParachute(this.thePlayer.field_70170_p, this.thePlayer, true);
                    parachute.func_70107_b(this.thePlayer.field_70165_t, this.thePlayer.field_70163_u, this.thePlayer.field_70161_v);
                    this.thePlayer.field_70170_p.func_72838_d((Entity)parachute);
                }
            }
        }
    }

    public boolean isInBlock(Block blockID) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.thePlayer.field_70165_t);
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)this.thePlayer.field_70163_u), z = MathHelper.func_76128_c((double)this.thePlayer.field_70161_v));
        return this.thePlayer.field_70170_p.func_180495_p(pos).func_177230_c() == blockID || this.thePlayer.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == blockID || this.thePlayer.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == blockID;
    }

    @Override
    public void updateShardCount(int amount) {
        this.lifeShardsUsed += amount;
        this.healthModifier = new AttributeModifier(this.healthUUID, "Aether Health Modifier", (double)((float)this.lifeShardsUsed * 2.0f), 0);
        if (this.thePlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(this.healthUUID) != null) {
            this.thePlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(this.healthModifier);
        }
        this.thePlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(this.healthModifier);
    }

    @Override
    public int getShardsUsed() {
        return this.lifeShardsUsed;
    }

    @Override
    public int getMaxShardCount() {
        return AetherConfig.gameplay_changes.max_life_shards;
    }

    @Override
    public void setFocusedBoss(IAetherBoss boss) {
        this.currentBoss = boss;
    }

    @Override
    public IAetherBoss getFocusedBoss() {
        return this.currentBoss;
    }

    @Override
    public boolean setHammerCooldown(int cooldown, String hammerName) {
        if (this.cooldown == 0) {
            this.cooldown = cooldown;
            this.cooldownMax = cooldown;
            this.cooldownName = hammerName;
            return true;
        }
        return false;
    }

    @Override
    public void shouldPortalSound(boolean playSound) {
        this.shouldPlayPortalSound = playSound;
    }

    @Override
    public boolean shouldPortalSound() {
        return this.shouldPlayPortalSound;
    }

    @Override
    public String getHammerName() {
        return this.cooldownName;
    }

    @Override
    public int getHammerCooldown() {
        return this.cooldown;
    }

    @Override
    public int getHammerMaxCooldown() {
        return this.cooldownMax;
    }

    @Override
    public boolean isJumping() {
        return this.isJumping;
    }

    @Override
    public void setJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    @Override
    public boolean isDonator() {
        return true;
    }

    @Override
    public void setInPortal() {
        this.inPortal = true;
    }

    public void updateAccessories() {
        if (!this.thePlayer.field_70170_p.field_72995_K) {
            AetherNetworkingManager.sendToAll(new PacketAccessory(this));
        }
    }

    @Override
    public void setAccessoryInventory(IAccessoryInventory inventory) {
        this.accessories = inventory;
    }

    @Override
    public IAccessoryInventory getAccessoryInventory() {
        return this.accessories;
    }

    @Override
    public ArrayList<IAetherAbility> getAbilities() {
        return this.abilities;
    }

    @Override
    public EntityPlayer getEntity() {
        return this.thePlayer;
    }

    @Override
    public boolean inPortalBlock() {
        return this.inPortal;
    }

    public boolean isPoisoned() {
        return this.isPoisoned;
    }

    public void setPoisoned() {
        this.isPoisoned = true;
        this.poisonTime = 500;
    }

    public boolean isCured() {
        return this.isCured;
    }

    public void setCured(int time) {
        this.isCured = true;
        this.cureTime = time;
        this.isPoisoned = false;
        this.poisonTime = 0;
    }

    public void givePortalFrame() {
        if (this.shouldGetPortal) {
            this.thePlayer.func_191521_c(new ItemStack(ItemsAether.aether_portal_frame));
            this.shouldGetPortal = false;
        }
    }
}

