/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.player;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.advancements.AetherAdvancements;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.player.IPlayerAether;
import com.gildedgames.the_aether.api.player.IPlayerAetherProvider;
import com.gildedgames.the_aether.enchantment.AetherEnchantmentHelper;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.player.PlayerAether;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandClearInventory;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PlayerAetherEvents {
    private static final ResourceLocation PLAYER_LOCATION = new ResourceLocation("aether_legacy", "aether_players");

    @SubscribeEvent
    public void PlayerConstructingEvent(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getObject();
            IPlayerAetherProvider provider = new IPlayerAetherProvider(new PlayerAether(player));
            if (AetherAPI.getInstance().get(player) == null) {
                event.addCapability(PLAYER_LOCATION, (ICapabilityProvider)provider);
            }
        }
    }

    @SubscribeEvent
    public void checkPlayerVisibility(PlayerEvent.Visibility event) {
        IPlayerAether playerAether = AetherAPI.getInstance().get(event.getEntityPlayer());
        if (playerAether.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsAether.invisibility_cape))) {
            event.modifyVisibility(0.0);
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        IPlayerAether original = AetherAPI.getInstance().get(event.getOriginal());
        IPlayerAether newPlayer = AetherAPI.getInstance().get(event.getEntityPlayer());
        NBTTagCompound data = new NBTTagCompound();
        if (original instanceof PlayerAether) {
            original.saveNBTData(data);
            if (newPlayer instanceof PlayerAether) {
                newPlayer.loadNBTData(data);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerPickupXp(PlayerPickupXpEvent event) {
        ItemStack itemstack = AetherEnchantmentHelper.getEnchantedAccessory(Enchantments.field_185296_A, AetherAPI.getInstance().get(event.getEntityPlayer()));
        if (!itemstack.func_190926_b() && itemstack.func_77951_h()) {
            int i = Math.min(event.getOrb().field_70530_e * 2, itemstack.func_77952_i());
            event.getOrb().field_70530_e -= i / 2;
            itemstack.func_77964_b(itemstack.func_77952_i() - i);
        }
    }

    @SubscribeEvent
    public void onPlayerMount(EntityMountEvent event) {
        if (event.getEntityMounting() instanceof EntityPlayerMP) {
            AetherAdvancements.MOUNT_TRIGGER.trigger((EntityPlayerMP)event.getEntityMounting(), event.getEntityBeingMounted());
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        IPlayerAether playerAether;
        if (event.getEntity() instanceof EntityPlayer && (playerAether = AetherAPI.getInstance().get((EntityPlayer)event.getEntity())) != null) {
            ((PlayerAether)playerAether).onPlayerDeath();
        }
    }

    @SubscribeEvent
    public void onPlayerDrops(LivingDropsEvent event) {
        IPlayerAether playerAether;
        if (event.getEntity() instanceof EntityPlayer && (playerAether = AetherAPI.getInstance().get((EntityPlayer)event.getEntity())) != null) {
            ((PlayerAether)playerAether).dropAccessories();
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        IPlayerAether playerAether = AetherAPI.getInstance().get(event.player);
        if (playerAether != null) {
            ((PlayerAether)playerAether).onPlayerRespawn();
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        IPlayerAether playerAether;
        if (event.getEntityLiving() instanceof EntityPlayer && (playerAether = AetherAPI.getInstance().get((EntityPlayer)event.getEntityLiving())) != null) {
            playerAether.onUpdate();
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        IPlayerAether playerAether;
        if (event.getEntityLiving() instanceof EntityPlayer && (playerAether = AetherAPI.getInstance().get((EntityPlayer)event.getEntityLiving())) != null) {
            event.setCanceled(((PlayerAether)playerAether).onPlayerAttacked(event.getSource()));
        }
    }

    @SubscribeEvent
    public void onChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        IPlayerAether playerAether = AetherAPI.getInstance().get(event.player);
        if (playerAether != null) {
            ((PlayerAether)playerAether).onChangedDimension(event.toDim, event.fromDim);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        IPlayerAether playerAether = AetherAPI.getInstance().get(player);
        if (playerAether != null) {
            playerAether.getAccessoryInventory().func_70296_d();
            if (!AetherConfig.gameplay_changes.aether_start) {
                ((PlayerAether)playerAether).shouldGetPortal = false;
            } else {
                ((PlayerAether)playerAether).givePortalFrame();
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        IPlayerAether playerAether;
        if (event.getEntityLiving() instanceof EntityPlayer && (playerAether = AetherAPI.getInstance().get((EntityPlayer)event.getEntityLiving())).getAccessoryInventory().isWearingObsidianSet()) {
            float original = event.getAmount();
            event.setAmount(original / 2.0f);
        }
    }

    @SubscribeEvent
    public void onPlayerStrVsBlock(PlayerEvent.BreakSpeed event) {
        IPlayerAether playerAether = AetherAPI.getInstance().get(event.getEntityPlayer());
        if (playerAether != null) {
            event.setNewSpeed(((PlayerAether)playerAether).getCurrentPlayerStrVsBlock(event.getNewSpeed()));
        }
    }

    @SubscribeEvent
    public void onCommandSentEvent(CommandEvent event) {
        if (event.getCommand() instanceof CommandClearInventory && event.getParameters().length <= 1) {
            EntityPlayerMP entityplayermp = null;
            try {
                entityplayermp = event.getParameters().length == 0 ? CommandBase.func_71521_c((ICommandSender)event.getSender()) : CommandBase.func_184888_a((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance(), (ICommandSender)event.getSender(), (String)event.getParameters()[0]);
            }
            catch (Throwable var9) {
                return;
            }
            IPlayerAether playerAether = AetherAPI.getInstance().get((EntityPlayer)entityplayermp);
            if (playerAether != null && playerAether.getAccessoryInventory().func_174890_g() != 0) {
                playerAether.getAccessoryInventory().func_174888_l();
                CommandBase.func_152373_a((ICommandSender)entityplayermp, (ICommand)event.getCommand(), (String)("Cleared the accessories of " + entityplayermp.func_70005_c_()), (Object[])new Object[0]);
            }
        }
    }
}

