/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.dimensions;

import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.blocks.BlockTeleporter;
import com.rwtema.extrautils2.tile.TileTeleporter;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class TeleporterBase
extends Teleporter {
    protected final WorldServer field_85192_a;
    protected final int destDim;
    protected final int startDim;

    public TeleporterBase(WorldServer world, int destDim, int startDim) {
        super(world);
        this.field_85192_a = world;
        this.destDim = destDim;
        this.startDim = startDim;
    }

    public void func_180266_a(@Nonnull Entity entityIn, float rotationYaw) {
        if (!this.func_180620_b(entityIn, rotationYaw)) {
            this.func_85188_a(entityIn);
            this.func_180620_b(entityIn, rotationYaw);
        }
    }

    public boolean func_180620_b(Entity entityIn, float rotationYaw) {
        double x = (double)((int)Math.floor(entityIn.field_70165_t)) + 0.5;
        double z = (double)((int)Math.floor(entityIn.field_70161_v)) + 0.5;
        if (this.destDim == -1) {
            x /= 8.0;
            z /= 8.0;
        }
        if (this.startDim == -1) {
            x *= 8.0;
            z *= 8.0;
        }
        Chunk chunk = this.field_85192_a.func_175726_f(new BlockPos(x, 0.0, z));
        int y = Math.min(chunk.func_76625_h() + 16, 255);
        boolean foundFree = this.field_85192_a.field_73011_w.func_76569_d();
        BlockPos blockpos = new BlockPos(x, (double)y, z);
        while (blockpos.func_177956_o() >= 0) {
            BlockPos nextBlock = blockpos.func_177977_b();
            IBlockState state = chunk.func_177435_g(nextBlock);
            if (state.func_185904_a().func_76230_c() || state.func_185904_a() == Material.field_151586_h) {
                if (foundFree) {
                    entityIn.func_70012_b(x, (double)blockpos.func_177956_o(), z, entityIn.field_70177_z, entityIn.field_70125_A);
                    return true;
                }
            } else {
                foundFree = true;
            }
            blockpos = nextBlock;
        }
        entityIn.func_70012_b(x, (double)(this.field_85192_a.field_73011_w.func_76557_i() + 1), z, entityIn.field_70177_z, entityIn.field_70125_A);
        return false;
    }

    public boolean func_85188_a(Entity entityIn) {
        return false;
    }

    @Nullable
    public BlockPos findTeleporterDest(@Nonnull BlockPos pos, @Nullable BlockTeleporter.Type type) {
        BlockPos closest = null;
        double minDist = 0.0;
        for (int x = pos.func_177958_n() - 8 >> 4; x <= pos.func_177958_n() + 8 >> 4; ++x) {
            for (int z = pos.func_177952_p() - 8 >> 4; z <= pos.func_177952_p() + 8 >> 4; ++z) {
                Chunk chunk = this.field_85192_a.func_72964_e(x, z);
                for (Map.Entry entry2 : chunk.func_177434_r().entrySet()) {
                    IBlockState state;
                    TileEntity tileEntity = (TileEntity)entry2.getValue();
                    if (!(tileEntity instanceof TileTeleporter)) continue;
                    BlockPos key = (BlockPos)entry2.getKey();
                    if (type != null && ((state = this.field_85192_a.func_180495_p(key)).func_177230_c() != XU2Entries.teleporter.value || state.func_177229_b(BlockTeleporter.property_type) != type) || key == null) continue;
                    double dist = pos.func_177951_i((Vec3i)key);
                    if (closest != null && !(dist < minDist)) continue;
                    closest = key;
                    minDist = dist;
                }
            }
        }
        return closest;
    }
}

