/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.api.crafting.utils;

import com.sofodev.armorplus.common.container.base.InventoryCraftingImproved;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ShapedRecipeUtils {
    @Nonnull
    public static ItemStack getCraftingResult(ItemStack output, boolean copyIngredientNBT, InventoryCraftingImproved inv) {
        ItemStack itemstack = output.func_77946_l();
        if (copyIngredientNBT) {
            IntStream.range(0, inv.func_70302_i_()).mapToObj(inv::func_70301_a).filter(itemstack1 -> !itemstack1.func_190926_b() && itemstack1.func_77942_o()).map(itemstack1 -> Objects.requireNonNull(itemstack1.func_77978_p()).func_74737_b()).forEachOrdered(arg_0 -> ((ItemStack)itemstack).func_77982_d(arg_0));
        }
        return itemstack;
    }

    public static boolean matches(int width, int height, NonNullList<ItemStack> input, InventoryCraftingImproved inv) {
        return IntStream.rangeClosed(0, inv.func_174922_i() - width).anyMatch(x -> IntStream.rangeClosed(0, inv.func_174923_h() - height).anyMatch(y -> ShapedRecipeUtils.checkMatch(width, height, input, inv, x, y, true) || ShapedRecipeUtils.checkMatch(width, height, input, inv, x, y, false)));
    }

    private static boolean checkMatch(int width, int height, NonNullList<ItemStack> input, InventoryCraftingImproved inv, int startX, int startY, boolean isMirrored) {
        for (int x = 0; x < inv.func_174922_i(); ++x) {
            for (int y = 0; y < inv.func_174923_h(); ++y) {
                ItemStack slotStack;
                int subX = x - startX;
                int subY = y - startY;
                ItemStack stack = ItemStack.field_190927_a;
                if (subX >= 0 && subY >= 0 && subX < width && subY < height) {
                    ItemStack itemStack = stack = isMirrored ? (ItemStack)input.get(width - subX - 1 + subY * width) : (ItemStack)input.get(subX + subY * width);
                }
                if ((slotStack = inv.func_70463_b(x, y)).func_190926_b() && stack.func_190926_b() || slotStack.func_190926_b() == stack.func_190926_b() && stack.func_77973_b() == slotStack.func_77973_b() && (stack.func_77960_j() == Short.MAX_VALUE || stack.func_77960_j() == slotStack.func_77960_j())) continue;
                return false;
            }
        }
        return true;
    }
}

