/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.client.events;

import java.awt.Color;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="armorplus", value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    public static final Random random = new Random();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTooltipColorEvent(RenderTooltipEvent.Color event) {
        ItemStack stack = event.getStack();
        ResourceLocation rl = stack.func_77973_b().getRegistryName();
        Color gold = new Color(255, 148, 0);
        Color darkPurple = new Color(60, 26, 70);
        Color purple = new Color(100, 27, 129);
        Color lightGreen = new Color(101, 255, 93);
        Color lightBlue = new Color(53, 92, 255);
        Color blue = new Color(0, 149, 255);
        Color lightPurple = new Color(120, 29, 255);
        if (rl == null || !rl.func_110624_b().equals("armorplus")) {
            return;
        }
        String rp = rl.func_110623_a();
        if (rp.contains("lava") && rp.contains("obsidian") || rp.contains("lava") && rp.contains("infuser")) {
            ClientEventHandler.setBorderColor(event, gold, darkPurple);
        }
        ClientEventHandler.setBorder(event, Color.GRAY, rl, "Coal", "coal");
        ClientEventHandler.setBorder(event, blue, rl, "Lapis", "lapis", "blue");
        ClientEventHandler.setBorder(event, Color.RED, rl, "Redstone", "redstone", "ardite", "high_tech_bench", "red");
        ClientEventHandler.setBorder(event, Color.GREEN, rl, "Emerald", "emerald", "green");
        ClientEventHandler.setBorder(event, darkPurple, rl, "Obsidian", "obsidian");
        ClientEventHandler.setBorder(event, gold, rl, "Lava", "champion_bench", "lava", "infused_lava", "lava_infused", "infused");
        ClientEventHandler.setBorder(event, blue, rl, "Guardian", "guardian", "chicken");
        ClientEventHandler.setBorder(event, Color.WHITE, rl, "Wither", "wither", "super_star", "white");
        ClientEventHandler.setBorder(event, purple, rl, "Ender Dragon", "ender_dragon", "manyullyn", "knight_slime", "purple");
        ClientEventHandler.setBorder(event, lightPurple, rl, "Ultimate", "ultimate", "slime", "ulti_tech_bench");
        ClientEventHandler.setBorder(event, lightGreen, rl, "Slime", "slime");
        ClientEventHandler.setBorder(event, lightBlue, rl, "Cobalt", "cobalt", "workbench");
        ClientEventHandler.setBorder(event, Color.YELLOW, rl, "Yellow", "yellow");
        ClientEventHandler.setBorder(event, Color.BLACK, rl, "Black", "black");
    }

    private static void setBorder(RenderTooltipEvent.Color event, Color color, ResourceLocation rl, String name, String ... ids) {
        if (ClientEventHandler.match(rl, name, ids)) {
            ClientEventHandler.setBorderColor(event, color);
        }
    }

    private static void setBorder(RenderTooltipEvent.Color event, Color start, Color end, ResourceLocation rl, String name, String ... ids) {
        if (ClientEventHandler.match(rl, name, ids)) {
            ClientEventHandler.setBorderColor(event, start, end);
        }
    }

    private static boolean match(ResourceLocation rl, String name, String ... ids) {
        return rl != null && (ClientEventHandler.match(rl.func_110623_a(), ids) || ClientEventHandler.match(rl.func_110624_b(), name));
    }

    private static boolean match(String displayName, String name) {
        return displayName.contains(name);
    }

    private static boolean match(String rp, String ... ids) {
        return Arrays.stream(ids).anyMatch(rp::contains);
    }

    public static void setBorderColor(RenderTooltipEvent.Color event, Color color) {
        event.setBorderStart(color.getRGB());
        event.setBorderEnd(color.getRGB());
    }

    public static void setBorderColor(RenderTooltipEvent.Color event, Color start, Color end) {
        event.setBorderStart(start.getRGB());
        event.setBorderEnd(end.getRGB());
    }
}

