/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry;

import com.sofodev.armorplus.common.registry.blocks.benches.Benches;
import com.sofodev.armorplus.common.registry.blocks.benches.BlockBench;
import com.sofodev.armorplus.common.registry.blocks.castle.BrickColor;
import com.sofodev.armorplus.common.registry.blocks.castle.base.BlockStoneBrick;
import com.sofodev.armorplus.common.registry.blocks.castle.base.BlockStoneBrickCorner;
import com.sofodev.armorplus.common.registry.blocks.castle.base.BlockStoneBrickTower;
import com.sofodev.armorplus.common.registry.blocks.castle.base.BlockStoneBrickWall;
import com.sofodev.armorplus.common.registry.blocks.dungeon.BlockDungeonEnder;
import com.sofodev.armorplus.common.registry.blocks.dungeon.BlockEnderPillar;
import com.sofodev.armorplus.common.registry.blocks.dungeon.EnderType;
import com.sofodev.armorplus.common.registry.blocks.lava.BlockCrystalOre;
import com.sofodev.armorplus.common.registry.blocks.lava.BlockLavaCactus;
import com.sofodev.armorplus.common.registry.blocks.lava.BlockLavaInfuser;
import com.sofodev.armorplus.common.registry.blocks.lava.BlockLavaMaterial;
import com.sofodev.armorplus.common.registry.blocks.lava.BlockLavaNetherBrick;
import com.sofodev.armorplus.common.registry.blocks.lava.BlockMeltingObsidian;
import com.sofodev.armorplus.common.registry.blocks.metals.BlockMetal;
import com.sofodev.armorplus.common.registry.blocks.metals.Metals;
import com.sofodev.armorplus.common.registry.blocks.normal.BlockCompressedObsidian;
import com.sofodev.armorplus.common.registry.blocks.special.decorative.BlockEmptyDisplay;
import com.sofodev.armorplus.common.registry.blocks.special.decorative.BlockSwordDisplay;
import com.sofodev.armorplus.common.registry.blocks.special.decorative.BlockTrophy;
import com.sofodev.armorplus.common.registry.blocks.special.decorative.Trophy;
import com.sofodev.armorplus.common.registry.blocks.special.tp.BlockMapDevice;
import com.sofodev.armorplus.common.registry.blocks.special.tp.BlockPortal;
import com.sofodev.armorplus.common.registry.items.ItemCombinedMap;
import com.sofodev.armorplus.common.registry.items.base.special.Swords;
import com.sofodev.armorplus.common.tileentity.TileCB;
import com.sofodev.armorplus.common.tileentity.TileEntityMapDevice;
import com.sofodev.armorplus.common.tileentity.TileHTB;
import com.sofodev.armorplus.common.tileentity.TileLavaInfuser;
import com.sofodev.armorplus.common.tileentity.TilePortal;
import com.sofodev.armorplus.common.tileentity.TileSwordDisplay;
import com.sofodev.armorplus.common.tileentity.TileTrophy;
import com.sofodev.armorplus.common.tileentity.TileUTB;
import com.sofodev.armorplus.common.tileentity.TileWB;
import com.sofodev.armorplus.common.util.Utils;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="armorplus")
public class ModBlocks {
    public static BlockCrystalOre oreLavaCrystal = new BlockCrystalOre();
    public static BlockCompressedObsidian blockCompressedObsidian = new BlockCompressedObsidian();
    public static BlockLavaCactus lavaCactus = new BlockLavaCactus();
    public static BlockMetal steelBlock = new BlockMetal(Metals.STEEL);
    public static BlockMetal electricalBlock = new BlockMetal(Metals.ELECTRICAL);
    public static BlockLavaNetherBrick blockLavaNetherBrick = new BlockLavaNetherBrick();
    public static BlockBench[] benches = new BlockBench[4];
    public static BlockStoneBrick[] stoneBricks = new BlockStoneBrick[7];
    public static BlockStoneBrickTower[] stoneBrickTowers = new BlockStoneBrickTower[7];
    public static BlockStoneBrickCorner[] stoneBrickCorners = new BlockStoneBrickCorner[7];
    public static BlockStoneBrickWall[] stonebrickWalls = new BlockStoneBrickWall[7];
    public static BlockLavaInfuser lavaInfuser = new BlockLavaInfuser("lava_infuser", false);
    public static BlockLavaInfuser lavaInfuserInfusing = new BlockLavaInfuser("lava_infuser_infusing", true);
    public static BlockLavaMaterial blockLavaCrystal = new BlockLavaMaterial(BlockLavaMaterial.LavaMaterial.LAVA_CRYSTAL);
    public static BlockLavaMaterial blockInfusedLavaCrystal = new BlockLavaMaterial(BlockLavaMaterial.LavaMaterial.INFUSED_LAVA_CRYSTAL);
    public static BlockLavaMaterial blockCompressedLavaCrystal = new BlockLavaMaterial(BlockLavaMaterial.LavaMaterial.COMPRESSED_LAVA_CRYSTAL);
    public static BlockLavaMaterial blockCompressedInfusedLavaCrystal = new BlockLavaMaterial(BlockLavaMaterial.LavaMaterial.COMPRESSED_INFUSED_LAVA_CRYSTAL);
    public static BlockLavaMaterial blockLavaInfusedObsidian = new BlockLavaMaterial(BlockLavaMaterial.LavaMaterial.LAVA_INFUSED_OBSIDIAN);
    public static BlockDungeonEnder[] enderBlocks = new BlockDungeonEnder[6];
    public static BlockEnderPillar enderPillar = new BlockEnderPillar();
    public static BlockTrophy[] trophies = new BlockTrophy[42];
    public static BlockMeltingObsidian blockMeltingObsidian = new BlockMeltingObsidian();
    public static BlockSwordDisplay[] blockSwordDisplays = new BlockSwordDisplay[Swords.values().length];
    public static BlockEmptyDisplay blockEmptyDisplay = new BlockEmptyDisplay();
    public static BlockMapDevice blockMapDevice = new BlockMapDevice();
    public static BlockPortal portal = new BlockPortal(ItemCombinedMap.Variants.MAP);
    public static BlockPortal overworldPortal = new BlockPortal(ItemCombinedMap.Variants.MAP_OF_OVERWORLD);
    public static BlockPortal netherPortal = new BlockPortal(ItemCombinedMap.Variants.MAP_OF_THE_NETHER);
    public static BlockPortal endPortal = new BlockPortal(ItemCombinedMap.Variants.MAP_OF_THE_END);
    public static BlockPortal arenaPortal = new BlockPortal(ItemCombinedMap.Variants.MAP_OF_ARENA);
    public static BlockPortal shaperPortal = new BlockPortal(ItemCombinedMap.Variants.MAP_OF_THE_SHAPER);
    public static BlockPortal elderPortal = new BlockPortal(ItemCombinedMap.Variants.MAP_OF_THE_ELDER);
    public static BlockPortal sacrificePortal = new BlockPortal(ItemCombinedMap.Variants.MAP_OF_SACRIFICE);
    public static BlockPortal realmPortal = new BlockPortal(ItemCombinedMap.Variants.MAP_OF_THE_REALM);

    public static void registerBlocks() {
        Arrays.setAll(benches, type -> new BlockBench(Benches.values()[type]));
        Arrays.setAll(stoneBricks, type -> new BlockStoneBrick(BrickColor.values()[type]));
        Arrays.setAll(stoneBrickTowers, type -> new BlockStoneBrickTower(BrickColor.values()[type]));
        Arrays.setAll(stoneBrickCorners, type -> new BlockStoneBrickCorner(BrickColor.values()[type], stoneBricks[type].func_176223_P()));
        Arrays.setAll(stonebrickWalls, type -> new BlockStoneBrickWall(stoneBricks[type]));
        Arrays.setAll(enderBlocks, type -> new BlockDungeonEnder(EnderType.values()[type]));
        Arrays.setAll(trophies, type -> new BlockTrophy(Trophy.values()[type]));
        Swords[] values = Swords.values();
        for (int index = 0; index < values.length; ++index) {
            ModBlocks.blockSwordDisplays[index] = new BlockSwordDisplay(values[index]);
        }
    }

    private static void registerAllBlocks(RegistryEvent.Register<Block> event, Block[] ... blocksArray) {
        Arrays.stream(blocksArray).forEachOrdered(blockList -> ModBlocks.registerAllBlocks(event, blockList));
    }

    private static void registerAllBlocks(RegistryEvent.Register<Block> event, Block ... blockList) {
        Arrays.stream(blockList).filter(Utils::isNotNull).forEachOrdered(block -> event.getRegistry().register((IForgeRegistryEntry)block));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.registerAllBlocks(event, (Block[])benches);
        ModBlocks.registerAllBlocks(event, new Block[]{oreLavaCrystal, blockCompressedObsidian, steelBlock, electricalBlock, blockLavaNetherBrick, lavaCactus, lavaInfuser, lavaInfuserInfusing, blockLavaInfusedObsidian, blockLavaCrystal, blockInfusedLavaCrystal, blockCompressedLavaCrystal, blockCompressedInfusedLavaCrystal, blockMeltingObsidian, blockMapDevice});
        ModBlocks.registerAllBlocks(event, new Block[][]{stoneBricks, stoneBrickTowers, stoneBrickCorners, stonebrickWalls});
        ModBlocks.registerAllBlocks(event, new Block[][]{enderBlocks, trophies});
        ModBlocks.registerAllBlocks(event, (Block[])blockSwordDisplays);
        ModBlocks.registerAllBlocks(event, blockEmptyDisplay);
        ModBlocks.registerAllBlocks(event, new Block[]{portal, overworldPortal, netherPortal, endPortal, arenaPortal, sacrificePortal, realmPortal, shaperPortal, elderPortal});
        ModBlocks.registerAllBlocks(event, enderPillar);
        ModBlocks.registerTileEntities();
        ModBlocks.registerTEFixes();
    }

    private static void registerTEFixes() {
        CompoundDataFixer dataFixer = FMLCommonHandler.instance().getDataFixer();
        TileLavaInfuser.registerFixesLavaInfuser((DataFixer)dataFixer);
    }

    private static void registerTileEntities() {
        GameRegistry.registerTileEntity(TileLavaInfuser.class, (ResourceLocation)Utils.setRL("lava_infuser_tile_entity"));
        GameRegistry.registerTileEntity(TileWB.class, (ResourceLocation)Utils.setRL("workbench_tile_entity"));
        GameRegistry.registerTileEntity(TileHTB.class, (ResourceLocation)Utils.setRL("high_tech_bench_tile_entity"));
        GameRegistry.registerTileEntity(TileUTB.class, (ResourceLocation)Utils.setRL("ulti_tech_tile_entity"));
        GameRegistry.registerTileEntity(TileCB.class, (ResourceLocation)Utils.setRL("champion_tile_entity"));
        GameRegistry.registerTileEntity(TileTrophy.class, (ResourceLocation)Utils.setRL("trophy_tile_entity"));
        GameRegistry.registerTileEntity(TilePortal.class, (ResourceLocation)Utils.setRL("portal_tile_entity"));
        GameRegistry.registerTileEntity(TileEntityMapDevice.class, (ResourceLocation)Utils.setRL("map_device_tile_entity"));
        GameRegistry.registerTileEntity(TileSwordDisplay.class, (ResourceLocation)Utils.setRL("sword_display_tile_entity"));
    }
}

