/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.blocks.lava;

import com.sofodev.armorplus.common.iface.IModdedBlock;
import com.sofodev.armorplus.common.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMeltingObsidian
extends BlockBreakable
implements IModdedBlock {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);

    public BlockMeltingObsidian() {
        super(Material.field_151576_e, false);
        this.setRegistryName(Utils.setRL("block_melting_obsidian"));
        this.func_149663_c(Utils.setName("block_melting_obsidian"));
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.func_149713_g(3);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)meta, (int)0, (int)3)));
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((rand.nextInt(3) == 0 || this.countNeighbors(worldIn, pos) < 4) && worldIn.func_175671_l(pos) > 11 - (Integer)state.func_177229_b((IProperty)AGE) - state.getLightOpacity((IBlockAccess)worldIn, pos)) {
            this.slightlyMelt(worldIn, pos, state, rand, true);
        } else {
            worldIn.func_175684_a(pos, (Block)this, MathHelper.func_76136_a((Random)rand, (int)20, (int)40));
        }
    }

    protected void turnIntoLava(World worldIn, BlockPos pos) {
        if (worldIn.field_73011_w.func_177495_o()) {
            worldIn.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
            worldIn.func_190524_a(pos, (Block)Blocks.field_150353_l, pos);
        } else {
            this.func_176226_b(worldIn, pos, worldIn.func_180495_p(pos), 0);
            worldIn.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
            worldIn.func_190524_a(pos, (Block)Blocks.field_150353_l, pos);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        if (this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(this.func_180643_i(state));
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack is : items) {
                BlockMeltingObsidian.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)is);
            }
        } else {
            if (worldIn.field_73011_w.func_177495_o()) {
                worldIn.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
                return;
            }
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            this.harvesters.set(player);
            this.func_176226_b(worldIn, pos, state, i);
            this.harvesters.set(null);
            Material material = worldIn.func_180495_p(pos.func_177977_b()).func_185904_a();
            if (material.func_76230_c() || material.func_76224_d()) {
                worldIn.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int count;
        if (worldIn.func_180495_p(pos).func_177230_c() == this && (count = this.countNeighbors(worldIn, pos)) < 2) {
            this.turnIntoLava(worldIn, pos);
        }
    }

    private int countNeighbors(World access, BlockPos pos) {
        return (int)Arrays.stream(EnumFacing.values()).filter(enumfacing -> access.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() == this).limit(4L).count();
    }

    protected void slightlyMelt(World worldIn, BlockPos pos, IBlockState state, Random rand, boolean meltNeighbors) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age < 3) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            worldIn.func_175684_a(pos, (Block)this, MathHelper.func_76136_a((Random)rand, (int)20, (int)40));
        } else {
            this.turnIntoLava(worldIn, pos);
            if (meltNeighbors) {
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    BlockPos blockpos = pos.func_177972_a(enumfacing);
                    IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                    if (iblockstate.func_177230_c() != this) continue;
                    this.slightlyMelt(worldIn, blockpos, iblockstate, rand, false);
                }
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        this.initModel(0, "normal");
    }
}

