/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.blocks.special.tp;

import com.sofodev.armorplus.common.registry.items.ItemCombinedMap;
import com.sofodev.armorplus.common.tileentity.TilePortal;
import com.sofodev.armorplus.common.util.Utils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPortal
extends BlockContainer {
    private final ItemCombinedMap.Variants variant;
    public int dimensionID;

    public BlockPortal(ItemCombinedMap.Variants variant) {
        super(Material.field_151567_E);
        this.variant = variant;
        this.dimensionID = variant.getType() != null ? variant.getType().func_186068_a() : 0;
        String name = "portal_to_" + variant.getName().replace("map_of_", "");
        this.setRegistryName(Utils.setRL(name));
        this.func_149663_c(name);
        this.func_149711_c(-1.0f);
        this.func_149752_b(6000000.0f);
        this.func_149715_a(1.0f);
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("USE THIS AT OWN RISK, UNSTABLE.. BEST TO IGNORE");
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        return !iblockstate.func_185914_p() && block != Blocks.field_185775_db;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TilePortal) {
            int i = ((TilePortal)tileentity).getParticleAmount();
            for (int j = 0; j < i; ++j) {
                double xChunk = (float)pos.func_177958_n() + rand.nextFloat();
                double yChunk = (float)pos.func_177956_o() + rand.nextFloat();
                double zChunk = (float)pos.func_177952_p() + rand.nextFloat();
                double xSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
                double ySpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
                double zSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
                int randMulti = rand.nextInt(2) * 2 - 1;
                if (rand.nextBoolean()) {
                    zChunk = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)randMulti;
                    zSpeed = rand.nextFloat() * 2.0f * (float)randMulti;
                } else {
                    xChunk = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)randMulti;
                    xSpeed = rand.nextFloat() * 2.0f * (float)randMulti;
                }
                worldIn.func_175688_a(EnumParticleTypes.PORTAL, xChunk, yChunk, zChunk, xSpeed, ySpeed, zSpeed, new int[0]);
            }
        }
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151646_E;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack itemstack = super.getPickBlock(state, target, world, pos, player);
        TilePortal portal = (TilePortal)world.func_175625_s(pos);
        NBTTagCompound nbttagcompound = portal.saveToNbt(new NBTTagCompound());
        if (!nbttagcompound.func_82582_d()) {
            itemstack.func_77983_a("DimID", (NBTBase)nbttagcompound);
        }
        return itemstack;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        TilePortal portal = new TilePortal();
        if (this.variant == ItemCombinedMap.Variants.MAP || this.variant.getType() == null) {
            portal.setDimensionID(0);
        } else {
            portal.setDimensionID(this.dimensionID);
        }
        return portal;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        TilePortal portal = new TilePortal();
        if (this.variant == ItemCombinedMap.Variants.MAP || this.variant.getType() == null) {
            portal.setDimensionID(0);
        } else {
            portal.setDimensionID(this.dimensionID);
        }
        return portal;
    }
}

