/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.items;

import com.sofodev.armorplus.common.registry.items.base.ItemBase;
import com.sofodev.armorplus.common.util.TextUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemFragment
extends ItemBase {
    private final Fragments fragment;

    public ItemFragment(Fragments fragment) {
        super(fragment.getName());
        this.fragment = fragment;
    }

    public EntityEntry getHolderEntry() {
        return (EntityEntry)ForgeRegistries.ENTITIES.getValue(this.fragment.getHolderRL());
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return this.getRarity(TextFormatting.DARK_RED, "fragment");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String name = this.getHolderEntry().getName();
        if (name != null) {
            tooltip.add(String.format("%s%s %s", TextFormatting.BLUE, TextUtils.translatedText("item.armorplus.fragment.info", new Object[0]), name));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static enum Fragments {
        DUSK(0, "villager_golem"),
        NOON(1, "wither"),
        MIDNIGHT(2, "ender_dragon"),
        DAWN(3, "elder_guardian");

        private final int index;
        private final ResourceLocation entityRL;

        private Fragments(int index, String dropEntityRegName) {
            this.index = index;
            this.entityRL = new ResourceLocation(dropEntityRegName);
        }

        public int getIndex() {
            return this.index;
        }

        public ResourceLocation getHolderRL() {
            return this.entityRL;
        }

        public String getName() {
            return this.name().toLowerCase();
        }
    }
}

