/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.items.armors.base;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.api.caps.abilities.AbilityData;
import com.sofodev.armorplus.api.caps.abilities.AbilityDataHandler;
import com.sofodev.armorplus.api.caps.abilities.ISpecialItem;
import com.sofodev.armorplus.api.caps.abilities.ImplementedAbilities;
import com.sofodev.armorplus.api.caps.abilities.MaterialType;
import com.sofodev.armorplus.client.utils.ToolTipUtils;
import com.sofodev.armorplus.common.registry.items.armors.base.ItemArmorBase;
import com.sofodev.armorplus.common.util.EnumHelperUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorV2
extends ItemArmorBase
implements ISpecialItem {
    public final MaterialType field_77878_bZ;
    public EntityEquipmentSlot slot;
    private EnumAction wear = EnumHelperUtil.addAction("WEAR");

    public ItemArmorV2(MaterialType material, EntityEquipmentSlot slot) {
        super(material.getArmorMaterial(), slot, material.getName() + "_prototype", "prototype");
        this.field_77878_bZ = material;
        this.slot = slot;
        this.func_77637_a(ArmorPlus.tabArmorPlusPrototypes);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        AbilityDataHandler.IAbilityHandler handler = AbilityDataHandler.getHandler(stack);
        if (ToolTipUtils.isKeyDown() && handler != null) {
            tooltip.add(1, this.updateLimitToolTip(stack));
            tooltip.add(2, "");
            this.addTTAbility(tooltip, stack, ImplementedAbilities.ABILITY_REGISTRY.getValuesCollection());
            ToolTipUtils.addToolTip(tooltip, "", "__________");
        } else {
            ToolTipUtils.showInfo(tooltip, keyBindSneak, TextFormatting.GOLD);
        }
    }

    private void addTTAbility(List<String> tooltip, ItemStack stack, Collection<AbilityData> dataList) {
        for (AbilityData data : dataList) {
            this.addTTAbility(tooltip, stack, data);
        }
    }

    private void addTTAbility(List<String> tooltip, ItemStack stack, AbilityData data) {
        AbilityDataHandler.IAbilityHandler handler = AbilityDataHandler.getHandler(stack);
        if (handler == null) {
            return;
        }
        String ability = this.getTTAbility(handler, stack, data);
        if (!ability.equals("")) {
            tooltip.add(ability);
        }
        if (this.isNotNull(tooltip)) {
            tooltip.set(2, this.notSpecial(stack));
        }
    }

    private boolean isNotNull(List<String> tooltip) {
        return tooltip.get(2) != null;
    }

    private String notSpecial(ItemStack stack) {
        AbilityDataHandler.IAbilityHandler handler = AbilityDataHandler.getHandler(stack);
        if (handler != null) {
            boolean notSpecial = !ItemArmorV2.canProvideAny(stack) && !AbilityData.hasAbilities(handler);
            return notSpecial ? TextFormatting.ITALIC + new TextComponentTranslation("info.armorplus.items.ability.not_found", new Object[0]).func_150254_d() : "";
        }
        return "";
    }

    public static boolean canProvideAny(ItemStack stack) {
        List array = ImplementedAbilities.ABILITY_REGISTRY.getValuesCollection().stream().map(data -> AbilityData.canProvide(stack, data)).collect(Collectors.toList());
        Iterator iterator = array.iterator();
        while (iterator.hasNext()) {
            boolean canProvide = (Boolean)iterator.next();
            if (!canProvide) continue;
            return true;
        }
        return false;
    }

    private String getTTAbility(AbilityDataHandler.IAbilityHandler handler, ItemStack stack, AbilityData data) {
        boolean flag;
        ResourceLocation id = data.getRegistryName();
        String name = "- " + data.getName();
        boolean canProvide = AbilityData.canProvide(stack, id);
        if (handler == null) {
            return "";
        }
        boolean bl = flag = AbilityData.contains(handler, id) && canProvide;
        if (flag) {
            return TextFormatting.DARK_GREEN + name;
        }
        if (!canProvide) {
            return "";
        }
        if (!AbilityData.hasRoomForAbilities(handler)) {
            return TextFormatting.RED + name;
        }
        return TextFormatting.DARK_GRAY + name;
    }

    private String updateLimitToolTip(ItemStack stack) {
        AbilityDataHandler.IAbilityHandler handler = AbilityDataHandler.getHandler(stack);
        if (handler == null) {
            return "";
        }
        return TextFormatting.GOLD + new TextComponentTranslation("info.armorplus.items.ability.display_limit", new Object[]{handler.getAbilities().size(), handler.getLimit()}).func_150254_d();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.wear;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        AbilityData.provideArmorAbilities(stack, world, player);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        AbilityDataHandler.Provider provider = new AbilityDataHandler.Provider();
        AbilityDataHandler.IAbilityHandler handler = provider.getCapability(AbilityDataHandler.CAPABILITY_ABILITIES, null);
        if (handler != null && this.field_77878_bZ != null) {
            handler.setLimit(this.field_77878_bZ.getLimit());
        }
        return provider;
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        if (super.getNBTShareTag(stack) != null) {
            tag.func_74782_a("super", (NBTBase)super.getNBTShareTag(stack));
            tag.func_74782_a("capability", AbilityDataHandler.CAPABILITY_ABILITIES.writeNBT((Object)AbilityDataHandler.getHandler(stack), null));
        }
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        super.readNBTShareTag(stack, nbt.func_74775_l("super"));
        AbilityDataHandler.CAPABILITY_ABILITIES.readNBT((Object)AbilityDataHandler.getHandler(stack), null, nbt.func_74781_a("capability"));
    }

    @Override
    public boolean isSpecial(ItemStack stack) {
        return true;
    }

    @Override
    public MaterialType getMaterial() {
        return this.field_77878_bZ;
    }

    @Override
    public boolean hasSpecialMaterial() {
        return true;
    }

    @Override
    public EntityEquipmentSlot getSlot() {
        return this.slot;
    }
}

