/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.items.base;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.client.utils.ToolTipUtils;
import com.sofodev.armorplus.common.config.ModConfig;
import com.sofodev.armorplus.common.iface.IModdedItem;
import com.sofodev.armorplus.common.registry.items.base.special.Pickaxes;
import com.sofodev.armorplus.common.util.ArmorPlusItemUtils;
import com.sofodev.armorplus.common.util.Utils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpecialPickaxe
extends ItemPickaxe
implements IModdedItem {
    public static final Item.ToolMaterial COAL_PICKAXE = EnumHelper.addToolMaterial((String)"coalPickaxe", (int)1, (int)ModConfig.RegistryConfig.coal.tools.pickaxe.durability, (float)((float)ModConfig.RegistryConfig.coal.tools.pickaxe.efficiency), (float)1.0f, (int)10);
    public static final Item.ToolMaterial LAPIS_PICKAXE = EnumHelper.addToolMaterial((String)"lapisPickaxe", (int)2, (int)ModConfig.RegistryConfig.lapis.tools.pickaxe.durability, (float)((float)ModConfig.RegistryConfig.lapis.tools.pickaxe.efficiency), (float)2.0f, (int)10);
    public static final Item.ToolMaterial REDSTONE_PICKAXE = EnumHelper.addToolMaterial((String)"redstonePickaxe", (int)2, (int)ModConfig.RegistryConfig.redstone.tools.pickaxe.durability, (float)((float)ModConfig.RegistryConfig.redstone.tools.pickaxe.efficiency), (float)2.0f, (int)10);
    public static final Item.ToolMaterial EMERALD_PICKAXE = EnumHelper.addToolMaterial((String)"emeraldPickaxe", (int)3, (int)ModConfig.RegistryConfig.emerald.tools.pickaxe.durability, (float)((float)ModConfig.RegistryConfig.emerald.tools.pickaxe.efficiency), (float)4.0f, (int)10);
    public static final Item.ToolMaterial OBSIDIAN_PICKAXE = EnumHelper.addToolMaterial((String)"obsidianPickaxe", (int)2, (int)ModConfig.RegistryConfig.obsidian.tools.pickaxe.durability, (float)((float)ModConfig.RegistryConfig.obsidian.tools.pickaxe.efficiency), (float)3.0f, (int)22);
    public static final Item.ToolMaterial INFUSED_LAVA_PICKAXE = EnumHelper.addToolMaterial((String)"infusedLavaPickaxe", (int)3, (int)ModConfig.RegistryConfig.lava.tools.pickaxe.durability, (float)((float)ModConfig.RegistryConfig.lava.tools.pickaxe.efficiency), (float)5.5f, (int)22);
    public static final Item.ToolMaterial GUARDIAN_PICKAXE = EnumHelper.addToolMaterial((String)"guardianPickaxe", (int)4, (int)ModConfig.RegistryConfig.guardian.tools.pickaxe.durability, (float)((float)ModConfig.RegistryConfig.guardian.tools.pickaxe.efficiency), (float)6.5f, (int)30);
    public static final Item.ToolMaterial SUPER_STAR_PICKAXE = EnumHelper.addToolMaterial((String)"superStarPickaxe", (int)4, (int)ModConfig.RegistryConfig.super_star.tools.pickaxe.durability, (float)((float)ModConfig.RegistryConfig.super_star.tools.pickaxe.efficiency), (float)7.5f, (int)30);
    public static final Item.ToolMaterial ENDER_DRAGON_PICKAXE = EnumHelper.addToolMaterial((String)"enderDragonPickaxe", (int)4, (int)ModConfig.RegistryConfig.ender_dragon.tools.pickaxe.durability, (float)((float)ModConfig.RegistryConfig.ender_dragon.tools.pickaxe.efficiency), (float)8.5f, (int)30);
    public final Pickaxes pickaxes;
    public ItemStack itemExpert;
    private Random random = new Random();

    public ItemSpecialPickaxe(Pickaxes pickaxes) {
        super(pickaxes.getMaterial());
        this.pickaxes = pickaxes;
        this.itemExpert = pickaxes.getRepairStack();
        this.setRegistryName(pickaxes.getName() + "_pickaxe");
        this.func_77655_b(Utils.setName(pickaxes.getName() + "_pickaxe"));
        this.func_77637_a(ArmorPlus.tabArmorPlusTools);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ArmorPlusItemUtils.isItemRepairable(repair, this.itemExpert);
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return this.getRarity(this.pickaxes.getFormatting(), "Special Pickaxe");
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            this.pickaxes.onBlockStartBreak(itemstack, pos, player);
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    public void setEfficiency(float value) {
        this.field_77864_a = value;
    }

    public float getEfficiency() {
        return this.field_77864_a;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase player) {
        if (!world.field_72995_K) {
            this.pickaxes.onBlockDestroyed(stack, world, state, pos, player);
        }
        return super.func_179218_a(stack, world, state, pos, player);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (this.pickaxes.hasAbilities()) {
            if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
                ToolTipUtils.addToolTip(tooltip, this.pickaxes.getAbilityDesc());
            } else {
                ToolTipUtils.showInfo(tooltip, keyBindSneak, this.pickaxes.getFormatting());
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return super.canHarvestBlock(state, stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        this.initModel(this.pickaxes.getName(), 0);
    }
}

