/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.registry.items.materials;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.common.iface.IModdedItem;
import com.sofodev.armorplus.common.util.Utils;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.thedragonlib.util.ItemStackUtils;

public class ItemMaterial
extends Item
implements IModdedItem {
    private String[] materialNames = new String[]{"chainmail", "guardian_scale", "wither_bone", "ender_dragon_scale", "the_ultimate_material"};

    public ItemMaterial() {
        this.setRegistryName(Utils.setRL("material"));
        this.func_77655_b(Utils.setName("material"));
        this.func_77627_a(true);
        this.func_77637_a(ArmorPlus.tabArmorPlusItems);
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return this.getUnlocalizedNames(stack, this.materialNames);
    }

    private String getUnlocalizedNames(ItemStack stack, String ... names) {
        for (int i = 0; i < names.length; ++i) {
            if (stack.func_77952_i() != i) continue;
            return super.func_77667_c(stack) + "_" + names[i];
        }
        return super.func_77658_a();
    }

    public IRarity getForgeRarity(ItemStack stack) {
        int i = stack.func_77960_j();
        if (i == 0) {
            return this.getRarity(TextFormatting.GRAY, "Chainmail");
        }
        if (i == 1) {
            return this.getRarity(TextFormatting.BLUE, "Guardian Scale");
        }
        if (i == 2) {
            return this.getRarity(TextFormatting.WHITE, "Wither Bone");
        }
        if (i == 3) {
            return this.getRarity(TextFormatting.DARK_PURPLE, "Ender Dragon Scale");
        }
        if (i == 4) {
            return this.getRarity(TextFormatting.DARK_PURPLE, "The Ultimate Material");
        }
        return this.getRarity(TextFormatting.WHITE, "Default");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            IntStream.range(0, this.materialNames.length).mapToObj(i -> ItemStackUtils.getItemStack((Object)this, (int)i)).forEachOrdered(arg_0 -> subItems.add(arg_0));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        IntStream.range(0, this.materialNames.length).forEachOrdered(i -> this.initModel(Utils.setRL(this.materialNames[i]), "material", i));
    }
}

