/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.common.tileentity;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TilePortal
extends TileEntity {
    private int dimID;
    private String dimensionID = "DimID";

    public String getName() {
        return "container.portal";
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderFace(EnumFacing facing) {
        return facing == EnumFacing.UP;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.loadFromNbt(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.saveToNbt(nbt);
        return nbt;
    }

    public float getDimensionID() {
        return this.dimID;
    }

    public void setDimensionID(int id) {
        this.dimID = id;
    }

    public void loadFromNbt(NBTTagCompound nbt) {
        if (nbt.func_150297_b(this.dimensionID, 99)) {
            this.dimID = nbt.func_74762_e(this.dimensionID);
        }
    }

    public NBTTagCompound saveToNbt(NBTTagCompound nbt) {
        nbt.func_74768_a(this.dimensionID, this.dimID);
        return nbt;
    }

    public World func_145831_w() {
        return this.field_145850_b;
    }

    public BlockPos func_174877_v() {
        return this.field_174879_c;
    }

    @SideOnly(value=Side.CLIENT)
    public int getParticleAmount() {
        return Arrays.stream(EnumFacing.values()).mapToInt(facing -> this.shouldRenderFace((EnumFacing)facing) ? 1 : 0).sum();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 12, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean func_183000_F() {
        return false;
    }

    public boolean func_145842_c(int id, int type) {
        return super.func_145842_c(id, type);
    }
}

