/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.effects.enchantments.DTScrollEnchantments;
import pegbeard.dungeontactics.entities.DTEntityCompanion;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTEffects;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.items.DTItemGeneric;
import pegbeard.dungeontactics.items.DTSoulgem;

public class DTMagic
extends DTItemGeneric {
    static int breakChance = DTConfigHandler.configuration.get("1-Feature", "Spell Scroll Break Chance", 4).getInt(4);
    static int maxUses = DTConfigHandler.configuration.get("1-Feature", "Spell Scroll Max Uses", 0).getInt(0);
    private static final List<Enchantment> spells = Lists.newArrayList();

    public DTMagic(String name) {
        super(name);
        spells.add(DTEffects.RESTORATION);
        spells.add(DTEffects.SATIATE);
        spells.add(DTEffects.FORGEING);
        spells.add(DTEffects.COOKING);
        spells.add(DTEffects.FREEZING);
        spells.add(DTEffects.UNCOVER);
        spells.add(DTEffects.DISARM);
        spells.add(DTEffects.DISORIENT);
        spells.add(DTEffects.PUNISH);
        spells.add(DTEffects.WITHER);
        spells.add(DTEffects.SMITE);
        spells.add(DTEffects.MAGICMISSILE);
        spells.add(DTEffects.PINMISSILE);
        spells.add(DTEffects.TRANSPORT);
        spells.add(DTEffects.COMPANION);
        spells.add(DTEffects.SUNDER);
        spells.add(DTEffects.RAGE);
        spells.add(DTEffects.SOULSTEAL);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        if (stack.func_77973_b() == DTItems.MAGIC_SCROLL) {
            if (stack.func_77948_v()) {
                Enchantment ench = this.getEnchant(stack);
                if (spells.contains(ench) && ench instanceof DTScrollEnchantments) {
                    return TextFormatting.LIGHT_PURPLE + I18n.func_74838_a((String)"item.dungeontactics:scroll_of.name").trim() + " " + I18n.func_74838_a((String)ench.func_77320_a()).trim();
                }
                return TextFormatting.DARK_PURPLE + I18n.func_74838_a((String)"item.dungeontactics:scroll_dud.name").trim();
            }
            return TextFormatting.DARK_PURPLE + super.func_77653_i(stack);
        }
        return super.func_77653_i(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        if (stack.func_77973_b() == DTItems.MAGIC_POWDER) {
            return true;
        }
        return stack.func_77948_v();
    }

    public int func_77619_b() {
        if (this == DTItems.MAGIC_SCROLL) {
            return 1;
        }
        return 0;
    }

    public boolean func_77616_k(ItemStack stack) {
        return this == DTItems.MAGIC_SCROLL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        int cost;
        Enchantment ench;
        if (stack.func_77973_b() != DTItems.MAGIC_POWDER && stack.func_77973_b() != DTItems.MAGIC_POUCH && stack.func_77948_v() && (ench = this.getEnchant(stack)) != null && ench instanceof DTScrollEnchantments && (cost = ((DTScrollEnchantments)ench).getCost()) > 0) {
            tooltip.add("Cast Cost = " + cost);
        }
    }

    public Enchantment getEnchant(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        NBTTagList nbttaglist = stack.func_77986_q();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            Enchantment enchantment = Enchantment.func_185262_c((int)nbttagcompound.func_74765_d("id"));
            if (!(enchantment instanceof DTScrollEnchantments)) continue;
            return enchantment;
        }
        return null;
    }

    private ItemStack hasMcguffin(EntityPlayer player) {
        if (this.isMcguffin(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isMcguffin(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isMcguffin(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isMcguffin(@Nullable ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == DTItems.MAGIC_POWDER;
    }

    private ItemStack hasPouch(EntityPlayer player) {
        if (this.isPouch(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isPouch(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isPouch(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isPouch(@Nullable ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == DTItems.MAGIC_POUCH && stack.func_77952_i() < stack.func_77958_k();
    }

    private ItemStack hasSmeltable(EntityPlayer player) {
        if (this.isSmeltable(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isSmeltable(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isSmeltable(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isSmeltable(@Nullable ItemStack stack) {
        return !stack.func_190926_b() && !FurnaceRecipes.func_77602_a().func_151395_a(stack).func_190926_b();
    }

    protected boolean handleCost(EntityPlayer player, ItemStack mcguffin, ItemStack pouch, int cost) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        cost = this.reduceCost(player, cost);
        if (!mcguffin.func_190926_b()) {
            if (mcguffin.func_190916_E() >= cost) {
                mcguffin.func_190918_g(cost);
                player.func_71020_j((float)(cost / 10));
                return true;
            }
            cost -= mcguffin.func_190916_E();
            player.field_71071_by.func_184437_d(mcguffin);
            mcguffin = this.hasMcguffin(player);
            return this.handleCost(player, mcguffin, pouch, cost);
        }
        if (!pouch.func_190926_b() && pouch.func_77952_i() <= pouch.func_77958_k() - cost && !pouch.func_96631_a(cost, player.func_70681_au(), player instanceof EntityPlayerMP ? (EntityPlayerMP)player : null)) {
            player.func_71020_j((float)(cost / 10));
            return true;
        }
        return false;
    }

    protected int reduceCost(EntityPlayer player, int cost) {
        int reduction;
        ItemStack stack = ItemStack.field_190927_a;
        if (!player.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && EnchantmentHelper.func_77506_a((Enchantment)DTEffects.MAGEAFFINITY, (ItemStack)(stack = player.func_184582_a(EntityEquipmentSlot.HEAD))) > 0) {
            reduction = (int)((double)cost / Math.PI);
            cost -= reduction;
        }
        if (!player.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && EnchantmentHelper.func_77506_a((Enchantment)DTEffects.MAGEAFFINITY, (ItemStack)(stack = player.func_184582_a(EntityEquipmentSlot.CHEST))) > 0) {
            reduction = (int)((double)cost / Math.PI);
            cost -= reduction;
        }
        if (!player.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() && EnchantmentHelper.func_77506_a((Enchantment)DTEffects.MAGEAFFINITY, (ItemStack)(stack = player.func_184582_a(EntityEquipmentSlot.LEGS))) > 0) {
            reduction = (int)((double)cost / Math.PI);
            cost -= reduction;
        }
        if (!player.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b() && EnchantmentHelper.func_77506_a((Enchantment)DTEffects.MAGEAFFINITY, (ItemStack)(stack = player.func_184582_a(EntityEquipmentSlot.FEET))) > 0) {
            reduction = (int)((double)cost / Math.PI);
            cost -= reduction;
        }
        if (cost <= 0) {
            cost = 1;
        }
        return cost;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        int j;
        AxisAlignedBB axisalignedbb;
        List list;
        List list2;
        AxisAlignedBB axisalignedbb2;
        DTScrollEnchantments ench;
        int i;
        ItemStack mcguffin = this.hasMcguffin(player);
        ItemStack pouch = this.hasPouch(player);
        ItemStack stack = player.func_184586_b(hand);
        boolean flag = player.field_71075_bZ.field_75098_d;
        boolean pet = false;
        if (player.func_184614_ca().func_190926_b() && player.func_184592_cb().func_190926_b()) return new ActionResult(EnumActionResult.PASS, (Object)stack);
        if (stack.func_77973_b() == DTItems.MAGIC_POUCH) {
            if (player.func_70093_af()) {
                if (stack.func_77951_h() && stack.func_77952_i() >= stack.func_77958_k()) return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                ItemStack dust = new ItemStack(DTItems.MAGIC_POWDER);
                stack.func_77964_b(stack.func_77952_i() + 1);
                if (!player.field_71071_by.func_70441_a(dust)) {
                    player.func_71019_a(dust, false);
                }
            } else if (!mcguffin.func_190926_b()) {
                int stacksize = mcguffin.func_190916_E();
                for (i = 0; i < stacksize; ++i) {
                    if (stack.func_77952_i() <= 0 || mcguffin.func_190916_E() <= 0) {
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                    }
                    stack.func_77964_b(stack.func_77952_i() - 1);
                    mcguffin.func_190918_g(1);
                }
            }
        }
        if (stack.func_77973_b() != DTItems.MAGIC_SCROLL || !stack.func_77948_v()) return new ActionResult(EnumActionResult.PASS, (Object)stack);
        Enchantment enchant = this.getEnchant(stack);
        if (!spells.contains(enchant) || !(enchant instanceof DTScrollEnchantments)) {
            if (!world.field_72995_K) return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            for (i = 0; i < 30; ++i) {
                world.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, player.field_70165_t, player.field_70163_u, player.field_70161_v, field_77697_d.nextGaussian() * 0.05, -player.field_70181_x * 0.5, field_77697_d.nextGaussian() * 0.05, new int[0]);
            }
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Fizzle fizzle"));
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187687_ch, SoundCategory.NEUTRAL, 1.0f, field_77697_d.nextFloat());
            if (flag) return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
            stack.func_190918_g(1);
            if (!stack.func_190926_b()) return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            player.field_71071_by.func_184437_d(stack);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!(enchant instanceof DTScrollEnchantments) || !spells.contains((Object)(ench = (DTScrollEnchantments)enchant)) || !this.handleCost(player, mcguffin, pouch, ench.getCost())) return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        if (field_77697_d.nextInt(4) == 0) {
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187687_ch, SoundCategory.NEUTRAL, 1.0f, field_77697_d.nextFloat());
            if (flag || world.field_72995_K) return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
            if (field_77697_d.nextInt(4) == 0) {
                stack.func_190918_g(1);
            }
            if (!stack.func_190926_b()) return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            player.field_71071_by.func_184437_d(stack);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (ench == DTEffects.RESTORATION && !world.field_72995_K) {
            if (!player.func_70093_af()) {
                axisalignedbb2 = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
                list2 = world.func_72872_a(EntityLivingBase.class, axisalignedbb2);
                if (!list2.isEmpty()) {
                    for (EntityLivingBase entitylivingbase : list2) {
                        pet = false;
                        if (entitylivingbase instanceof EntityTameable) {
                            pet = ((EntityTameable)entitylivingbase).func_70909_n();
                        }
                        if (!entitylivingbase.func_184603_cC() || !pet && !entitylivingbase.func_184191_r((Entity)player)) continue;
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 1, 1));
                    }
                }
            } else {
                axisalignedbb2 = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
                list2 = world.func_72872_a(EntityLivingBase.class, axisalignedbb2);
                if (!list2.isEmpty()) {
                    for (EntityLivingBase entitylivingbase : list2) {
                        if (!entitylivingbase.func_184603_cC()) continue;
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 1, 0));
                    }
                }
            }
        }
        if (ench == DTEffects.SATIATE && !world.field_72995_K) {
            if (!player.func_70093_af()) {
                axisalignedbb2 = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
                list2 = world.func_72872_a(EntityLivingBase.class, axisalignedbb2);
                if (!list2.isEmpty()) {
                    for (EntityLivingBase entitylivingbase : list2) {
                        pet = false;
                        if (entitylivingbase instanceof EntityTameable) {
                            pet = ((EntityTameable)entitylivingbase).func_70909_n();
                        }
                        if (!entitylivingbase.func_184603_cC() || !pet && !entitylivingbase.func_184191_r((Entity)player)) continue;
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76443_y, 2, 1));
                    }
                }
            } else {
                axisalignedbb2 = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
                list2 = world.func_72872_a(EntityLivingBase.class, axisalignedbb2);
                if (!list2.isEmpty()) {
                    for (EntityLivingBase entitylivingbase : list2) {
                        if (!entitylivingbase.func_184603_cC()) continue;
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76443_y, 2, 0));
                    }
                }
            }
        }
        if (ench == DTEffects.FORGEING && !world.field_72995_K && !this.hasSmeltable(player).func_190926_b()) {
            if (!player.func_70093_af()) {
                for (int i2 = 0; i2 < player.field_71071_by.func_70302_i_(); ++i2) {
                    ItemStack smeltable = this.hasSmeltable(player);
                    int smeltableSize = smeltable.func_190916_E();
                    if (smeltable.func_190926_b() || smeltable.func_77973_b() instanceof ItemFood) continue;
                    ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(smeltable);
                    ItemStack smelted = result.func_77946_l();
                    smelted.func_190920_e(smeltableSize);
                    player.field_71071_by.func_184437_d(smeltable);
                    player.func_70099_a(smelted, player.func_70047_e() - 1.0f);
                }
            } else {
                ItemStack smeltable = this.hasSmeltable(player);
                int smeltableSize = smeltable.func_190916_E();
                if (!smeltable.func_190926_b() && !(smeltable.func_77973_b() instanceof ItemFood)) {
                    ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(smeltable);
                    ItemStack smelted = result.func_77946_l();
                    smelted.func_190920_e(smeltableSize);
                    player.field_71071_by.func_184437_d(smeltable);
                    player.func_70099_a(smelted, player.func_70047_e() - 1.0f);
                    player.func_70099_a(smelted, player.func_70047_e() - 1.0f);
                }
            }
        }
        if (ench == DTEffects.COOKING && !world.field_72995_K && !this.hasSmeltable(player).func_190926_b()) {
            if (!player.func_70093_af()) {
                for (int i3 = 0; i3 < player.field_71071_by.func_70302_i_(); ++i3) {
                    ItemStack cookable = this.hasSmeltable(player);
                    int cookableSize = cookable.func_190916_E();
                    if (cookable.func_190926_b() || !(cookable.func_77973_b() instanceof ItemFood)) continue;
                    ItemStack cooked = FurnaceRecipes.func_77602_a().func_151395_a(cookable);
                    int cookedSize = cookableSize;
                    cooked.func_190920_e(cookedSize);
                    player.field_71071_by.func_184437_d(cookable);
                    player.func_70099_a(cooked.func_77946_l(), player.func_70047_e() - 1.0f);
                }
            } else {
                ItemStack cookable = this.hasSmeltable(player);
                int cookableSize = cookable.func_190916_E();
                if (!cookable.func_190926_b() && cookable.func_77973_b() instanceof ItemFood) {
                    ItemStack cooked = FurnaceRecipes.func_77602_a().func_151395_a(cookable);
                    int cookedSize = cookableSize;
                    cooked.func_190920_e(cookedSize);
                    player.field_71071_by.func_184437_d(cookable);
                    player.func_70099_a(cooked.func_77946_l(), player.func_70047_e() - 1.0f);
                    player.func_70099_a(cooked.func_77946_l(), player.func_70047_e() - 1.0f);
                }
            }
        }
        if (ench == DTEffects.FREEZING && !world.field_72995_K && !(list = world.func_72872_a(EntityLivingBase.class, axisalignedbb = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0))).isEmpty()) {
            for (EntityLivingBase entitylivingbase : list) {
                int amp;
                if (!player.func_70093_af()) {
                    pet = false;
                    if (entitylivingbase instanceof EntityTameable) {
                        pet = ((EntityTameable)entitylivingbase).func_152114_e((EntityLivingBase)player);
                    }
                    if (!entitylivingbase.func_184603_cC() || entitylivingbase == player || pet || entitylivingbase.func_184191_r((Entity)player)) continue;
                    entitylivingbase.func_70097_a(DamageSource.func_76354_b((Entity)player, (Entity)player), 2.0f);
                    if (entitylivingbase.func_70660_b(MobEffects.field_76421_d) != null) {
                        amp = entitylivingbase.func_70660_b(MobEffects.field_76421_d).func_76458_c();
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, amp + 1));
                    } else {
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 1));
                    }
                    if (entitylivingbase.func_70660_b(DTEffects.CRYO) != null) {
                        amp = entitylivingbase.func_70660_b(DTEffects.CRYO).func_76458_c();
                        entitylivingbase.func_70690_d(new PotionEffect(DTEffects.CRYO, 200, amp + 1));
                        continue;
                    }
                    entitylivingbase.func_70690_d(new PotionEffect(DTEffects.CRYO, 200, 1));
                    continue;
                }
                pet = false;
                if (entitylivingbase instanceof EntityTameable) {
                    pet = ((EntityTameable)entitylivingbase).func_70909_n();
                }
                if (!entitylivingbase.func_184603_cC() || entitylivingbase instanceof EntityPlayerMP || pet) continue;
                entitylivingbase.func_70097_a(DamageSource.func_76354_b((Entity)player, (Entity)player), 10.0f);
                if (entitylivingbase.func_70660_b(MobEffects.field_76421_d) != null) {
                    amp = entitylivingbase.func_70660_b(MobEffects.field_76421_d).func_76458_c();
                    entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, amp + 1));
                } else {
                    entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 1));
                }
                if (entitylivingbase.func_70660_b(DTEffects.CRYO) != null) {
                    amp = entitylivingbase.func_70660_b(DTEffects.CRYO).func_76458_c();
                    entitylivingbase.func_70690_d(new PotionEffect(DTEffects.CRYO, 200, amp + 1));
                    continue;
                }
                entitylivingbase.func_70690_d(new PotionEffect(DTEffects.CRYO, 200, 1));
            }
        }
        if (ench == DTEffects.UNCOVER && !world.field_72995_K && !(list = world.func_72872_a(EntityLivingBase.class, axisalignedbb = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0))).isEmpty()) {
            for (EntityLivingBase entitylivingbase : list) {
                ItemStack armour;
                int a;
                if (!player.func_70093_af()) {
                    if (entitylivingbase == player || entitylivingbase.func_184191_r((Entity)player)) continue;
                    block10: for (a = 0; a < 4; ++a) {
                        armour = ItemStack.field_190927_a;
                        if (a == 0 && !entitylivingbase.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
                            armour = entitylivingbase.func_184582_a(EntityEquipmentSlot.HEAD);
                        }
                        if (a == 1 && !entitylivingbase.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b()) {
                            armour = entitylivingbase.func_184582_a(EntityEquipmentSlot.CHEST);
                        }
                        if (a == 2 && !entitylivingbase.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b()) {
                            armour = entitylivingbase.func_184582_a(EntityEquipmentSlot.LEGS);
                        }
                        if (a == 3 && !entitylivingbase.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b()) {
                            armour = entitylivingbase.func_184582_a(EntityEquipmentSlot.FEET);
                        }
                        if (!armour.func_190926_b() && entitylivingbase instanceof EntityPlayerMP) {
                            for (int s = 0; s < ((EntityPlayerMP)entitylivingbase).field_71071_by.field_70462_a.size(); ++s) {
                                if (!((EntityPlayerMP)entitylivingbase).field_71071_by.func_70301_a(s).func_190926_b()) continue;
                                ((EntityPlayerMP)entitylivingbase).field_71071_by.func_70441_a(armour.func_77946_l());
                                ((EntityPlayerMP)entitylivingbase).field_71071_by.func_184437_d(armour);
                                continue block10;
                            }
                            continue;
                        }
                        if (armour.func_190926_b()) continue;
                        entitylivingbase.func_70099_a(armour, entitylivingbase.func_70047_e() - 0.5f);
                        if (a == 0) {
                            entitylivingbase.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                        }
                        if (a == 1) {
                            entitylivingbase.func_184201_a(EntityEquipmentSlot.CHEST, ItemStack.field_190927_a);
                        }
                        if (a == 2) {
                            entitylivingbase.func_184201_a(EntityEquipmentSlot.LEGS, ItemStack.field_190927_a);
                        }
                        if (a != 3) continue;
                        entitylivingbase.func_184201_a(EntityEquipmentSlot.FEET, ItemStack.field_190927_a);
                    }
                    continue;
                }
                if (entitylivingbase instanceof EntityPlayerMP) continue;
                for (a = 0; a < 4; ++a) {
                    armour = ItemStack.field_190927_a;
                    if (a == 0 && !entitylivingbase.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
                        armour = entitylivingbase.func_184582_a(EntityEquipmentSlot.HEAD);
                    }
                    if (a == 1 && !entitylivingbase.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b()) {
                        armour = entitylivingbase.func_184582_a(EntityEquipmentSlot.CHEST);
                    }
                    if (a == 2 && !entitylivingbase.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b()) {
                        armour = entitylivingbase.func_184582_a(EntityEquipmentSlot.LEGS);
                    }
                    if (a == 3 && !entitylivingbase.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b()) {
                        armour = entitylivingbase.func_184582_a(EntityEquipmentSlot.FEET);
                    }
                    if (armour.func_190926_b()) continue;
                    entitylivingbase.func_70099_a(armour, entitylivingbase.func_70047_e() - 0.5f);
                    if (a == 0) {
                        entitylivingbase.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                    }
                    if (a == 1) {
                        entitylivingbase.func_184201_a(EntityEquipmentSlot.CHEST, ItemStack.field_190927_a);
                    }
                    if (a == 2) {
                        entitylivingbase.func_184201_a(EntityEquipmentSlot.LEGS, ItemStack.field_190927_a);
                    }
                    if (a != 3) continue;
                    entitylivingbase.func_184201_a(EntityEquipmentSlot.FEET, ItemStack.field_190927_a);
                }
            }
        }
        if (ench == DTEffects.DISARM && !world.field_72995_K && !(list = world.func_72872_a(EntityLivingBase.class, axisalignedbb = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0))).isEmpty()) {
            for (EntityLivingBase entitylivingbase : list) {
                ItemStack offhand;
                ItemStack mainhand;
                if (!player.func_70093_af()) {
                    if (entitylivingbase == player || entitylivingbase.func_184191_r((Entity)player)) continue;
                    mainhand = ItemStack.field_190927_a;
                    offhand = ItemStack.field_190927_a;
                    if (!entitylivingbase.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
                        mainhand = entitylivingbase.func_184582_a(EntityEquipmentSlot.MAINHAND);
                    }
                    if (!entitylivingbase.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b()) {
                        offhand = entitylivingbase.func_184582_a(EntityEquipmentSlot.OFFHAND);
                    }
                    if (!mainhand.func_190926_b()) {
                        entitylivingbase.func_70099_a(mainhand.func_77946_l(), entitylivingbase.func_70047_e() - 0.5f);
                        entitylivingbase.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                    }
                    if (offhand.func_190926_b()) continue;
                    entitylivingbase.func_70099_a(offhand.func_77946_l(), entitylivingbase.func_70047_e() - 0.5f);
                    entitylivingbase.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                    continue;
                }
                if (entitylivingbase instanceof EntityPlayerMP) continue;
                mainhand = ItemStack.field_190927_a;
                offhand = ItemStack.field_190927_a;
                if (!entitylivingbase.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
                    mainhand = entitylivingbase.func_184582_a(EntityEquipmentSlot.MAINHAND);
                }
                if (!entitylivingbase.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b()) {
                    offhand = entitylivingbase.func_184582_a(EntityEquipmentSlot.OFFHAND);
                }
                if (!mainhand.func_190926_b()) {
                    entitylivingbase.func_70099_a(mainhand.func_77946_l(), entitylivingbase.func_70047_e() - 0.5f);
                    entitylivingbase.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                }
                if (offhand.func_190926_b()) continue;
                entitylivingbase.func_70099_a(offhand.func_77946_l(), entitylivingbase.func_70047_e() - 0.5f);
                entitylivingbase.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
            }
        }
        if (ench == DTEffects.DISORIENT && !world.field_72995_K && !(list = world.func_72872_a(EntityLivingBase.class, axisalignedbb = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0))).isEmpty()) {
            for (EntityLivingBase entitylivingbase : list) {
                float yawNew;
                float yawStart;
                if (!player.func_70093_af()) {
                    pet = false;
                    if (entitylivingbase instanceof EntityTameable) {
                        pet = ((EntityTameable)entitylivingbase).func_152114_e((EntityLivingBase)player);
                    }
                    if (entitylivingbase == player || pet || entitylivingbase.func_184191_r((Entity)player)) continue;
                    if (entitylivingbase.func_184603_cC()) {
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200, 1));
                    }
                    yawStart = entitylivingbase.field_70759_as;
                    entitylivingbase.field_70177_z = yawNew = yawStart - 180.0f;
                    entitylivingbase.func_70034_d(yawNew);
                    continue;
                }
                pet = false;
                if (entitylivingbase instanceof EntityTameable) {
                    pet = ((EntityTameable)entitylivingbase).func_70909_n();
                }
                if (entitylivingbase instanceof EntityPlayerMP || pet) continue;
                if (entitylivingbase.func_184603_cC()) {
                    entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200, 0));
                }
                yawStart = entitylivingbase.field_70759_as;
                entitylivingbase.field_70177_z = yawNew = yawStart - 180.0f;
                entitylivingbase.func_70034_d(yawNew);
            }
        }
        if (ench == DTEffects.PUNISH && !world.field_72995_K && !(list = world.func_72872_a(EntityLivingBase.class, axisalignedbb = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0))).isEmpty()) {
            for (EntityLivingBase entitylivingbase : list) {
                double d1;
                double d0;
                if (!player.func_70093_af()) {
                    pet = false;
                    if (entitylivingbase instanceof EntityTameable) {
                        pet = ((EntityTameable)entitylivingbase).func_152114_e((EntityLivingBase)player);
                    }
                    if (entitylivingbase == player || pet || entitylivingbase.func_184191_r((Entity)player) || !((d0 = player.func_70068_e((Entity)entitylivingbase)) < 16.0)) continue;
                    d1 = 4.0 - Math.sqrt(d0) / 4.0;
                    j = (int)(d1 * 60.0 + 0.5);
                    entitylivingbase.func_70097_a(DamageSource.func_76354_b((Entity)player, (Entity)player), (float)(j / 6) / 10.0f);
                    continue;
                }
                pet = false;
                if (entitylivingbase instanceof EntityTameable) {
                    pet = ((EntityTameable)entitylivingbase).func_70909_n();
                }
                if (entitylivingbase instanceof EntityPlayerMP || pet || !((d0 = player.func_70068_e((Entity)entitylivingbase)) < 16.0)) continue;
                d1 = 4.0 - Math.sqrt(d0) / 4.0;
                j = (int)(d1 * 60.0 + 0.5);
                entitylivingbase.func_70097_a(DamageSource.func_76354_b((Entity)player, (Entity)player), (float)(j / 6) / 10.0f);
            }
        }
        if (ench == DTEffects.WITHER && !world.field_72995_K && !(list = world.func_72872_a(EntityLivingBase.class, axisalignedbb = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0))).isEmpty()) {
            for (EntityLivingBase entitylivingbase : list) {
                double d1;
                double d0;
                if (!player.func_70093_af()) {
                    pet = false;
                    if (entitylivingbase instanceof EntityTameable) {
                        pet = ((EntityTameable)entitylivingbase).func_152114_e((EntityLivingBase)player);
                    }
                    if (!entitylivingbase.func_184603_cC() || entitylivingbase == player || pet || entitylivingbase.func_184191_r((Entity)player) || !((d0 = player.func_70068_e((Entity)entitylivingbase)) < 16.0)) continue;
                    d1 = 4.0 - Math.sqrt(d0) / 4.0;
                    j = (int)(d1 * 60.0 + 0.5);
                    entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_82731_v, j, 0));
                    continue;
                }
                pet = false;
                if (entitylivingbase instanceof EntityTameable) {
                    pet = ((EntityTameable)entitylivingbase).func_70909_n();
                }
                if (!entitylivingbase.func_184603_cC() || entitylivingbase instanceof EntityPlayerMP || pet || !((d0 = player.func_70068_e((Entity)entitylivingbase)) < 16.0)) continue;
                d1 = 4.0 - Math.sqrt(d0) / 4.0;
                j = (int)(d1 * 60.0 + 0.5);
                entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_82731_v, j, 0));
            }
        }
        if (ench == DTEffects.SMITE && !world.field_72995_K && !(list = world.func_72872_a(EntityLivingBase.class, axisalignedbb = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0))).isEmpty()) {
            for (EntityLivingBase entitylivingbase : list) {
                if (!player.func_70093_af()) {
                    pet = false;
                    if (entitylivingbase instanceof EntityTameable) {
                        pet = ((EntityTameable)entitylivingbase).func_152114_e((EntityLivingBase)player);
                    }
                    if (entitylivingbase == player || pet || entitylivingbase.func_184191_r((Entity)player)) continue;
                    world.func_72838_d((Entity)new EntityLightningBolt(world, entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, false));
                    continue;
                }
                pet = false;
                if (entitylivingbase instanceof EntityTameable) {
                    pet = ((EntityTameable)entitylivingbase).func_70909_n();
                }
                if (entitylivingbase instanceof EntityPlayerMP || pet) continue;
                world.func_72838_d((Entity)new EntityLightningBolt(world, entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, false));
            }
        }
        if (ench == DTEffects.MAGICMISSILE && !world.field_72995_K && !(list = world.func_72872_a(EntityLivingBase.class, axisalignedbb = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0))).isEmpty()) {
            for (EntityLivingBase entitylivingbase : list) {
                EntityShulkerBullet missile;
                if (!player.func_70093_af()) {
                    pet = false;
                    if (entitylivingbase instanceof EntityTameable) {
                        pet = ((EntityTameable)entitylivingbase).func_152114_e((EntityLivingBase)player);
                    }
                    if (entitylivingbase == player || pet || entitylivingbase.func_184191_r((Entity)player)) continue;
                    missile = new EntityShulkerBullet(world, (EntityLivingBase)player, (Entity)entitylivingbase, null);
                    world.func_72838_d((Entity)missile);
                    continue;
                }
                pet = false;
                if (entitylivingbase instanceof EntityTameable) {
                    pet = ((EntityTameable)entitylivingbase).func_70909_n();
                }
                if (entitylivingbase instanceof EntityPlayerMP || pet) continue;
                missile = new EntityShulkerBullet(world, (EntityLivingBase)player, (Entity)entitylivingbase, null);
                world.func_72838_d((Entity)missile);
            }
        }
        if (ench == DTEffects.PINMISSILE && !world.field_72995_K) {
            float rotation = player.field_70759_as;
            for (int i4 = 0; i4 < 18; ++i4) {
                ItemArrow itemarrow = (ItemArrow)Items.field_151032_g;
                EntityArrow entityarrow = itemarrow.func_185052_a(world, new ItemStack(Items.field_151032_g), (EntityLivingBase)player);
                entityarrow.func_184547_a((Entity)player, 0.0f, rotation + (float)(i4 * 20), 0.0f, 1.5f, 1.0f);
                entityarrow.func_70243_d(true);
                entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                world.func_72838_d((Entity)entityarrow);
            }
        }
        if (ench == DTEffects.TRANSPORT && !world.field_72995_K) {
            if (field_77697_d.nextInt(100) == 0) {
                EntityLlama llama = new EntityLlama(world);
                llama.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70759_as, 0.0f);
                llama.func_110263_g(player);
                llama.func_110251_o(true);
                world.func_72838_d((Entity)llama);
            } else {
                EntitySkeletonHorse horse = new EntitySkeletonHorse(world);
                horse.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70759_as, 0.0f);
                horse.func_110263_g(player);
                horse.func_110251_o(true);
                world.func_72838_d((Entity)horse);
            }
        }
        if (ench == DTEffects.COMPANION && !world.field_72995_K) {
            DTEntityCompanion wolf = new DTEntityCompanion(world, 1000);
            wolf.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70759_as, 0.0f);
            wolf.func_193101_c(player);
            world.func_72838_d((Entity)wolf);
        }
        if (ench == DTEffects.SUNDER && !world.field_72995_K && !(list = world.func_72872_a(EntityLivingBase.class, axisalignedbb = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0))).isEmpty()) {
            for (EntityLivingBase entitylivingbase : list) {
                if (!player.func_70093_af()) {
                    pet = false;
                    if (entitylivingbase instanceof EntityTameable) {
                        pet = ((EntityTameable)entitylivingbase).func_152114_e((EntityLivingBase)player);
                    }
                    if (entitylivingbase == player || pet || entitylivingbase.func_184191_r((Entity)player)) continue;
                    if (entitylivingbase instanceof EntityPlayerMP) {
                        entitylivingbase.func_70097_a(DamageSource.func_76354_b((Entity)player, (Entity)player), 18.0f);
                        continue;
                    }
                    if (!entitylivingbase.func_184222_aU()) {
                        entitylivingbase.func_70097_a(DamageSource.func_76354_b((Entity)player, (Entity)player), 25.0f);
                        continue;
                    }
                    entitylivingbase.func_70097_a(DamageSource.func_76354_b((Entity)player, (Entity)player), 100.0f);
                    continue;
                }
                pet = false;
                if (entitylivingbase instanceof EntityTameable) {
                    pet = ((EntityTameable)entitylivingbase).func_70909_n();
                }
                if (entitylivingbase instanceof EntityPlayerMP || pet) continue;
                entitylivingbase.func_70097_a(DamageSource.func_76354_b((Entity)player, (Entity)player), 100.0f);
            }
        }
        if (ench == DTEffects.RAGE && !world.field_72995_K) {
            if (!player.func_70093_af()) {
                axisalignedbb = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
                list = world.func_72872_a(EntityLivingBase.class, axisalignedbb);
                if (!list.isEmpty()) {
                    for (EntityLivingBase entitylivingbase : list) {
                        pet = false;
                        if (entitylivingbase instanceof EntityTameable) {
                            pet = ((EntityTameable)entitylivingbase).func_70909_n();
                        }
                        if (!entitylivingbase.func_184603_cC() || !pet && !entitylivingbase.func_184191_r((Entity)player)) continue;
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 200, 0));
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 1));
                    }
                }
            } else {
                axisalignedbb = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
                list = world.func_72872_a(EntityLivingBase.class, axisalignedbb);
                if (!list.isEmpty()) {
                    for (EntityLivingBase entitylivingbase : list) {
                        if (!entitylivingbase.func_184603_cC()) continue;
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 200, 0));
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 1));
                    }
                }
            }
        }
        if (ench == DTEffects.SOULSTEAL && !world.field_72995_K) {
            ItemStack soulgem = ItemStack.field_190927_a;
            if (!player.field_71071_by.func_70431_c(new ItemStack(DTItems.SOULGEM))) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            AxisAlignedBB axisalignedbb3 = player.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
            List list3 = world.func_72872_a(EntityLivingBase.class, axisalignedbb3);
            if (!list3.isEmpty()) {
                for (EntityLivingBase entitylivingbase : list3) {
                    if (entitylivingbase instanceof EntityPlayerMP) continue;
                    for (int i5 = 0; i5 < player.field_71071_by.func_70302_i_(); ++i5) {
                        ItemStack itemstack = player.field_71071_by.func_70301_a(i5);
                        if (itemstack.func_190926_b() || itemstack.func_77973_b() != DTItems.SOULGEM) continue;
                        Boolean b = false;
                        ResourceLocation storedSoul = DTSoulgem.getSoulIdFrom(player.field_71071_by.func_70301_a(i5));
                        if (storedSoul != null) {
                            b = storedSoul.equals((Object)EntityList.func_191301_a((Entity)entitylivingbase));
                        }
                        if (storedSoul != null && !b.booleanValue()) continue;
                        soulgem = player.field_71071_by.func_70301_a(i5);
                        break;
                    }
                    if (soulgem.func_190926_b()) continue;
                    DTSoulgem.prepareEntity(soulgem, player, entitylivingbase);
                }
            }
        }
        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187687_ch, SoundCategory.NEUTRAL, 1.0f, field_77697_d.nextFloat());
        if (flag || world.field_72995_K) return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), this.reduceCost(player, ench.getCost()));
        if (field_77697_d.nextInt(4) == 0) {
            stack.func_190918_g(1);
        }
        if (!stack.func_190926_b()) return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        player.field_71071_by.func_184437_d(stack);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

