/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.coordselector;

import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.coordselector.TelepadTarget;
import crazypants.enderio.util.Prep;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateLocationPrintout
implements IMessage {
    @Nonnull
    private ItemStack stack = Prep.getEmpty();
    private EntityEquipmentSlot slot;
    private int paperSlot;

    public PacketUpdateLocationPrintout() {
    }

    public PacketUpdateLocationPrintout(@Nonnull ItemStack stack, EntityEquipmentSlot slot, int paperSlot) {
        this.stack = stack;
        this.slot = slot;
        this.paperSlot = paperSlot;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        int ord = -1;
        if (this.slot != null) {
            ord = this.slot.ordinal();
        }
        buf.writeShort(ord);
        buf.writeShort(this.paperSlot);
    }

    public void fromBytes(ByteBuf buf) {
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        short ord = buf.readShort();
        this.slot = ord < 0 || ord >= EntityEquipmentSlot.values().length ? null : EntityEquipmentSlot.values()[ord];
        this.paperSlot = buf.readShort();
    }

    public static class Handler
    implements IMessageHandler<PacketUpdateLocationPrintout, IMessage> {
        public IMessage onMessage(PacketUpdateLocationPrintout message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack stack = message.stack;
            EntityEquipmentSlot slot = message.slot;
            int paperSlot = message.paperSlot;
            if (Prep.isInvalid(stack) || stack.func_77973_b() != ModObject.itemLocationPrintout.getItemNN()) {
                return null;
            }
            TelepadTarget telepadTarget = TelepadTarget.readFromNBT(stack);
            if (telepadTarget == null) {
                return null;
            }
            if (slot != null) {
                this.updatePrintout(player, slot, telepadTarget);
            } else if (paperSlot >= 0) {
                this.createPrintout(player, telepadTarget, paperSlot);
            }
            return null;
        }

        private void createPrintout(@Nonnull EntityPlayerMP player, @Nonnull TelepadTarget telepadTarget, int paperSlot) {
            if (telepadTarget.getDimension() != player.field_70170_p.field_73011_w.getDimension()) {
                return;
            }
            BlockPos blockPos = new BlockPos((Entity)player);
            if (telepadTarget.getLocation().func_177951_i((Vec3i)blockPos) > 25600.0) {
                return;
            }
            ItemStack invItem = ((Slot)player.field_71069_bz.field_75151_b.get(paperSlot)).func_75211_c();
            if (Prep.isValid(invItem) && invItem.func_77973_b() == Items.field_151121_aF) {
                ((Slot)player.field_71069_bz.field_75151_b.get(paperSlot)).func_75209_a(1);
                player.field_71069_bz.func_75142_b();
                ItemStack stack = new ItemStack(ModObject.itemLocationPrintout.getItemNN());
                telepadTarget.writeToNBT(stack);
                if (!player.field_71071_by.func_70441_a(stack)) {
                    player.func_71019_a(stack, false);
                }
            }
        }

        private void updatePrintout(@Nonnull EntityPlayerMP player, @Nonnull EntityEquipmentSlot slot, @Nonnull TelepadTarget telepadTarget) {
            ItemStack existingStack = player.func_184582_a(slot);
            if (Prep.isInvalid(existingStack) || existingStack.func_77973_b() != ModObject.itemLocationPrintout.getItemNN()) {
                return;
            }
            TelepadTarget existingTarget = TelepadTarget.readFromNBT(existingStack);
            if (existingTarget == null) {
                return;
            }
            existingTarget.setName(telepadTarget.getName());
            existingTarget.writeToNBT(existingStack);
            player.func_184201_a(slot, existingStack);
        }
    }
}

