/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.glass;

import com.enderio.core.common.interfaces.IOverlayRenderAware;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.block.painted.BlockItemPaintedBlock;
import crazypants.enderio.base.config.config.BaseConfig;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.material.glass.FusedQuartzType;
import crazypants.enderio.base.material.glass.IFusedBlockstate;
import crazypants.enderio.base.render.ICustomItemResourceLocation;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.itemoverlay.FusedQuartzOverlayRenderHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFusedQuartzBase<T extends TileEntityEio>
extends BlockEio<T>
implements ISmartRenderAwareBlock {
    public BlockFusedQuartzBase(@Nonnull IModObject modObject) {
        super(modObject, Material.field_151592_s);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(EnderIOTab.tabEnderIO);
        this.setShape(this.mkShape(BlockFaceShape.SOLID));
    }

    @Nonnull
    protected PropertyEnum<FusedQuartzType> getKind() {
        return FusedQuartzType.KIND;
    }

    @Nonnull
    public abstract IFusedBlockstate getFusedBlockstate(@Nonnull IBlockState var1);

    public float getExplosionResistance(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity exploder, @Nonnull Explosion explosion) {
        if (IFusedBlockstate.get(world.func_180495_p(pos)).isBlastResistant()) {
            return ((Float)BaseConfig.explosionResistantBlockHardness.get()).floatValue();
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public int func_149717_k(@Nonnull IBlockState state) {
        return IFusedBlockstate.get(state).getLightOpacity();
    }

    @Deprecated
    public int func_149750_m(@Nonnull IBlockState state) {
        return IFusedBlockstate.get(state).isEnlightened() ? 15 : super.func_149750_m(state);
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean isSideSolid(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return side != EnumFacing.UP;
    }

    public boolean canPlaceTorchOnTop(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    public boolean doesSideBlockChestOpening(@Nonnull IBlockState blockStateIn, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return side != EnumFacing.DOWN;
    }

    @Override
    public boolean canBeWrenched() {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public void func_185477_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (entityIn == null || !this.getFusedBlockstate(state).canPass(entityIn)) {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        }
    }

    public static class BlockItemFusedQuartzBase
    extends BlockItemPaintedBlock
    implements ICustomItemResourceLocation,
    IOverlayRenderAware {
        public BlockItemFusedQuartzBase(@Nonnull BlockFusedQuartzBase<?> block) {
            super((Block)block);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
            this.determineQuartzType(stack).addInformation(stack, worldIn, tooltip, flagIn);
        }

        @SideOnly(value=Side.CLIENT)
        @Nonnull
        protected FusedQuartzType determineQuartzType(ItemStack par1ItemStack) {
            return IFusedBlockstate.get(this.field_150939_a.func_176203_a(par1ItemStack.func_77952_i())).getType();
        }

        @Override
        @Nonnull
        public ResourceLocation getRegistryNameForCustomModelResourceLocation() {
            return ModObject.blockFusedQuartz.getItemNN().getRegistryName();
        }

        public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
            FusedQuartzOverlayRenderHelper.doItemOverlayIntoGUI(this.determineQuartzType(stack), xPosition, yPosition);
        }
    }
}

