/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power;

import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.base.power.forge.PowerInterfaceForge;
import crazypants.enderio.base.power.forge.tile.ILegacyPoweredTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class PowerHandlerUtil {
    @Nullable
    public static IPowerInterface getPowerInterface(@Nullable ICapabilityProvider provider, EnumFacing side) {
        IEnergyStorage capability;
        if (provider != null && (capability = (IEnergyStorage)provider.getCapability(CapabilityEnergy.ENERGY, side)) != null) {
            return new PowerInterfaceForge(provider, capability);
        }
        return null;
    }

    @Nullable
    public static IEnergyStorage getCapability(@Nonnull ItemStack stack) {
        return (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
    }

    @Nullable
    public static IEnergyStorage getCapability(@Nullable ICapabilityProvider provider, EnumFacing side) {
        return provider == null ? null : (IEnergyStorage)provider.getCapability(CapabilityEnergy.ENERGY, side);
    }

    public static int recieveInternal(@Nonnull ILegacyPoweredTile.Receiver target, int maxReceive, EnumFacing from, boolean simulate) {
        int result = Math.min(target.getMaxEnergyRecieved(from), maxReceive);
        result = Math.min(target.getMaxEnergyStored() - target.getEnergyStored(), result);
        if ((result = Math.max(0, result)) > 0 && !simulate) {
            target.setEnergyStored(target.getEnergyStored() + result);
        }
        return result;
    }
}

