/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.registry;

import com.enderio.core.common.vecmath.Vector4d;
import crazypants.enderio.base.render.model.FacadeSmartItemModel;
import crazypants.enderio.base.render.model.RotatingSmartItemModel;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public final class ItemModelRegistry {
    private static final Map<ModelResourceLocation, Registry> registries = new HashMap<ModelResourceLocation, Registry>();

    public static void register(@Nonnull String resource, @Nonnull Registry registry) {
        registries.put(new ModelResourceLocation("enderio:" + resource + "#inventory"), registry);
    }

    public static void register(@Nonnull ModelResourceLocation resource, @Nonnull Registry registry) {
        registries.put(resource, registry);
    }

    public static void registerRotating(@Nonnull String resource, final @Nonnull Vector4d rot) {
        ItemModelRegistry.register(resource, new Registry(){

            @Override
            @Nonnull
            public IBakedModel wrap(@Nonnull IBakedModel model) {
                return new RotatingSmartItemModel(model, rot);
            }
        });
    }

    public static void registerRotating(@Nonnull ModelResourceLocation resource, final @Nonnull Vector4d rot) {
        ItemModelRegistry.register(resource, new Registry(){

            @Override
            @Nonnull
            public IBakedModel wrap(@Nonnull IBakedModel model) {
                return new RotatingSmartItemModel(model, rot);
            }
        });
    }

    public static void registerFacade(@Nonnull ModelResourceLocation resource) {
        ItemModelRegistry.register(resource, new Registry(){

            @Override
            @Nonnull
            public IBakedModel wrap(@Nonnull IBakedModel model) {
                return new FacadeSmartItemModel(model);
            }
        });
    }

    @SubscribeEvent
    public static void bakeModels(@Nonnull ModelBakeEvent event) {
        for (Map.Entry<ModelResourceLocation, Registry> entry : registries.entrySet()) {
            ModelResourceLocation resource = entry.getKey();
            if (resource == null) continue;
            IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)resource);
            Registry registry = entry.getValue();
            if (registry == null || model == null) continue;
            event.getModelRegistry().func_82595_a((Object)resource, (Object)registry.wrap(model));
        }
    }

    public static interface Registry {
        @Nonnull
        public IBakedModel wrap(@Nonnull IBakedModel var1);
    }
}

