/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.patcher;

import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.listinject.EntityObject;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class EntityInjector
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!transformedName.equals("net.minecraft.entity.Entity") && !transformedName.equals("net.minecraft.tileentity.TileEntity")) {
            return basicClass;
        }
        TickDynamicMod.logInfo("Entity Inject: " + transformedName, new Object[0]);
        ClassReader cr = new ClassReader(basicClass);
        ClassWriter cw = new ClassWriter(0);
        ClassInjectorVisitor iv = new ClassInjectorVisitor(262144, (ClassVisitor)cw);
        cr.accept((ClassVisitor)iv, 8);
        return cw.toByteArray();
    }

    private class MedthodInjectorVisitor
    extends MethodVisitor {
        boolean gotInit;

        public MedthodInjectorVisitor(int api, MethodVisitor mv) {
            super(api, mv);
            this.gotInit = false;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (!this.gotInit && opcode == 183) {
                super.visitMethodInsn(opcode, EntityObject.class.getName().replace('.', '/'), name, desc, itf);
                this.gotInit = true;
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    private class ClassInjectorVisitor
    extends ClassVisitor {
        boolean done;

        public ClassInjectorVisitor(int api, ClassVisitor cv) {
            super(api, cv);
            this.done = false;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (!superName.equals("java/lang/Object")) {
                TickDynamicMod.logWarn("WARNING: " + name + " already has a super class which will be overwritten: " + superName + "\nThis means that some other mod might no longer work properly!", new Object[0]);
            }
            super.visit(version, access + 32, name, signature, EntityObject.class.getName().replace('.', '/'), interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!this.done && name.equals("<init>")) {
                this.done = true;
                return new MedthodInjectorVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions));
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

