/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.patcher;

import com.wildex999.tickdynamic.TickDynamicMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatchParser {
    List<CommandToken> tokens;
    Map<String, String> variableMap;

    public void parsePatch(String patch) throws Exception {
        this.tokens = new ArrayList<CommandToken>();
        patch = patch.replace("\r", "");
        boolean inMultiLineComment = false;
        TokenType currentCommand = null;
        int commandContentIndex = 0;
        TickDynamicMod.logInfo("Patch length: " + patch.length(), new Object[0]);
        block30: for (int i = 0; i < patch.length(); ++i) {
            if (inMultiLineComment && patch.charAt(i) != '!') continue;
            switch (patch.charAt(i)) {
                case '@': {
                    TokenType command;
                    char currentChar = patch.charAt(++i);
                    switch (currentChar) {
                        case 'O': {
                            command = TokenType.CommandOrigin;
                            break;
                        }
                        case 'L': {
                            command = TokenType.CommandLimit;
                            break;
                        }
                        case 'R': {
                            command = TokenType.CommandReset;
                            break;
                        }
                        case 'U': {
                            command = TokenType.CommandUnlimit;
                            break;
                        }
                        case 'S': {
                            command = TokenType.CommandStart;
                            break;
                        }
                        case 'E': {
                            command = TokenType.CommandEnd;
                            break;
                        }
                        case '+': {
                            command = TokenType.CommandAdd;
                            break;
                        }
                        case '-': {
                            command = TokenType.CommandSubtract;
                            break;
                        }
                        case '|': {
                            command = null;
                            break;
                        }
                        default: {
                            throw new Exception("(" + i + ")Unknown command: " + currentChar);
                        }
                    }
                    if (currentCommand != null) {
                        this.tokens.add(new CommandToken(currentCommand, patch.substring(commandContentIndex, i - 1)));
                        TickDynamicMod.logInfo("Wrote command: " + (Object)((Object)currentCommand) + " with Text: " + this.tokens.get((int)(this.tokens.size() - 1)).text, new Object[0]);
                    }
                    if (command != null) {
                        currentCommand = command;
                        commandContentIndex = i + 1;
                        continue block30;
                    }
                    currentCommand = null;
                    continue block30;
                }
                case '%': {
                    ++i;
                    continue block30;
                }
                case '\"': {
                    if (currentCommand != null || (i = patch.indexOf(10, i)) != -1) continue block30;
                    i = patch.length();
                    continue block30;
                }
                case '!': {
                    if (currentCommand != null) continue block30;
                    inMultiLineComment = !inMultiLineComment;
                    continue block30;
                }
            }
        }
        TickDynamicMod.logInfo("Done parsing step 1", new Object[0]);
        for (CommandToken token : this.tokens) {
            StringBuilder str = new StringBuilder(token.text);
            int startIndex = 0;
            block32: for (int i = 0; i < str.length(); ++i) {
                char currentChar = str.charAt(i);
                switch (currentChar) {
                    case '*': {
                        token.replacementTokens.add(new ReplacementToken(TokenType.Text, str.substring(startIndex, i)));
                        token.replacementTokens.add(new ReplacementToken(TokenType.Anything));
                        startIndex = i + 1;
                        continue block32;
                    }
                    case '+': {
                        token.replacementTokens.add(new ReplacementToken(TokenType.Text, str.substring(startIndex, i)));
                        token.replacementTokens.add(new ReplacementToken(TokenType.AnythingLine));
                        startIndex = i + 1;
                        continue block32;
                    }
                    case '#': 
                    case '<': 
                    case '>': 
                    case '^': {
                        TokenType type;
                        token.replacementTokens.add(new ReplacementToken(TokenType.Text, str.substring(startIndex, i)));
                        int index = str.indexOf("]", i);
                        switch (currentChar) {
                            case '<': {
                                type = TokenType.AnythingLess;
                                break;
                            }
                            case '>': {
                                type = TokenType.AnythingMore;
                                break;
                            }
                            case '#': {
                                type = TokenType.AnythingExact;
                                break;
                            }
                            default: {
                                type = TokenType.TouchVar;
                            }
                        }
                        token.replacementTokens.add(new ReplacementToken(type, Integer.parseInt(str.substring(i + 1, index))));
                        startIndex = index + 1;
                        i = index;
                        continue block32;
                    }
                    case '=': 
                    case '?': {
                        token.replacementTokens.add(new ReplacementToken(TokenType.Text, str.substring(startIndex, i)));
                        int index = str.indexOf("]", i);
                        TokenType type = currentChar == '?' ? TokenType.AnythingSet : TokenType.AnythingGet;
                        token.replacementTokens.add(new ReplacementToken(type, str.substring(i + 1, index)));
                        startIndex = index + 1;
                        i = index;
                        continue block32;
                    }
                    case '{': {
                        token.replacementTokens.add(new ReplacementToken(TokenType.Text, str.substring(startIndex, i)));
                        int index = str.indexOf("]", i);
                        String[] var = new String[2];
                        var[0] = str.substring(i + 1, index);
                        int regStart = index;
                        while (str.charAt((index = str.indexOf("}", index)) - 1) == '%') {
                            str.deleteCharAt(index - 1);
                        }
                        var[1] = str.substring(regStart, index);
                        token.replacementTokens.add(new ReplacementToken(TokenType.RegEx, var));
                        startIndex = index + 1;
                        i = index;
                        continue block32;
                    }
                    case '%': {
                        str.deleteCharAt(i);
                    }
                }
            }
            if (startIndex < str.length()) {
                token.replacementTokens.add(new ReplacementToken(TokenType.Text, str.substring(startIndex)));
            }
            TickDynamicMod.logInfo("Replacements for " + (Object)((Object)token.type) + ": ", new Object[0]);
            for (ReplacementToken t : token.replacementTokens) {
                TickDynamicMod.logInfo("- " + (Object)((Object)t.type) + " :: " + t.var, new Object[0]);
            }
        }
    }

    public String patch(String basee) throws Exception {
        basee = basee.replace("\r", "");
        StringBuilder output = new StringBuilder(basee);
        this.variableMap = new HashMap<String, String>();
        int baseOrigin = 0;
        int baseLimit = basee.length();
        if (this.tokens == null) {
            throw new Exception("parsePatch must be run before patch, can not patch without tokens!");
        }
        block4: for (int i = 0; i < this.tokens.size(); ++i) {
            Matcher matcher;
            Pattern pattern;
            HashMap<String, Boolean> varSet;
            StringBuilder regEx;
            CommandToken token = this.tokens.get(i);
            if (token.type == TokenType.CommandOrigin) {
                regEx = new StringBuilder();
                varSet = new HashMap<String, Boolean>();
                this.generateReplacementRegEx(token, regEx, varSet);
                pattern = Pattern.compile(regEx.toString());
                matcher = pattern.matcher(output);
                if (!matcher.find()) {
                    throw new Exception("(Token:" + i + ")Unable to match Origin: " + regEx.toString());
                }
                baseOrigin = matcher.start();
                continue;
            }
            if (token.type == TokenType.CommandLimit) {
                regEx = new StringBuilder();
                varSet = new HashMap();
                this.generateReplacementRegEx(token, regEx, varSet);
                pattern = Pattern.compile(regEx.toString());
                matcher = pattern.matcher(output);
                if (!matcher.find()) {
                    throw new Exception("(Token:" + i + ")Unable to match Limit: " + regEx.toString());
                }
                baseLimit = matcher.start();
                continue;
            }
            if (token.type == TokenType.CommandReset) {
                baseOrigin = 0;
                continue;
            }
            if (token.type == TokenType.CommandUnlimit) {
                baseLimit = output.length();
                continue;
            }
            if (token.type != TokenType.CommandStart) {
                throw new Exception("(Token:" + i + ")Expected CommandStart, but got: " + (Object)((Object)token.type) + " with content: " + token.text);
            }
            int startIndex = i;
            StringBuilder detectionRegEx = new StringBuilder();
            varSet = new HashMap();
            boolean ended = false;
            while (i < this.tokens.size()) {
                token = this.tokens.get(i);
                if (token.type != TokenType.CommandAdd) {
                    if (token.type == TokenType.CommandOrigin) {
                        new Exception("(Token:" + i + ")Can not define an Origin between Start and End.");
                    } else if (token.type == TokenType.CommandLimit) {
                        new Exception("(Token:" + i + ")Can not define an Limit between Start and End.");
                    } else if (token.type == TokenType.CommandEnd && token.text.length() == 0) {
                        ended = true;
                        break;
                    }
                    if (token.type == TokenType.CommandStart) {
                        detectionRegEx.append("(");
                    } else {
                        detectionRegEx.append("(?<t").append(token.tokenId).append(">");
                    }
                    this.generateReplacementRegEx(token, detectionRegEx, varSet);
                    detectionRegEx.append(")");
                    if (token.type == TokenType.CommandEnd) {
                        ended = true;
                        break;
                    }
                }
                ++i;
            }
            if (!ended) {
                throw new Exception("Reached end of stream without End command!");
            }
            TickDynamicMod.logInfo("(" + (Object)((Object)token.type) + ") RegEx: " + detectionRegEx.toString(), new Object[0]);
            String subBase = output.substring(baseOrigin, baseLimit);
            pattern = Pattern.compile(detectionRegEx.toString(), 32);
            matcher = pattern.matcher(subBase);
            if (!matcher.find()) {
                throw new Exception("Failed to match: '" + detectionRegEx.toString() + "'\nOn base: '" + subBase + "'");
            }
            for (String varName : varSet.keySet()) {
                String varValue = matcher.group(varName);
                if (varValue == null) {
                    throw new Exception("Variable '" + varName + "' was marked as set, but was null!");
                }
                this.variableMap.put(varName, varValue);
            }
            int offset = baseOrigin + matcher.end(1);
            for (i = startIndex; i < this.tokens.size(); ++i) {
                token = this.tokens.get(i);
                if (token.type == TokenType.CommandEnd) break;
                if (token.type != TokenType.CommandSubtract) continue;
                int length = matcher.group("t" + token.tokenId).length();
                output.delete(offset, offset + length);
                baseLimit -= length;
            }
            for (i = startIndex; i < this.tokens.size(); ++i) {
                token = this.tokens.get(i);
                if (token.type == TokenType.CommandEnd) continue block4;
                if (token.type != TokenType.CommandAdd) continue;
                for (ReplacementToken repToken : token.replacementTokens) {
                    String in;
                    switch (repToken.type) {
                        case Text: {
                            in = (String)repToken.var;
                            break;
                        }
                        case AnythingGet: {
                            in = this.variableMap.get((String)repToken.var);
                            if (in != null) break;
                            throw new Exception("Tried to use nonexistent variable '" + (String)repToken.var + "' during Add command.");
                        }
                        default: {
                            throw new Exception("Unsuported action during CommandAdd: " + (Object)((Object)repToken.type));
                        }
                    }
                    output.insert(offset, in);
                    baseLimit += in.length();
                    offset += in.length();
                }
            }
        }
        return output.toString();
    }

    protected void generateReplacementRegEx(CommandToken token, StringBuilder detectionRegEx, Map<String, Boolean> varSet) throws Exception {
        block12: for (int repToken = 0; repToken < token.replacementTokens.size(); ++repToken) {
            ReplacementToken action = token.replacementTokens.get(repToken);
            switch (action.type) {
                case Text: {
                    detectionRegEx.append(Pattern.quote((String)action.var));
                    continue block12;
                }
                case Anything: {
                    detectionRegEx.append(".+");
                    continue block12;
                }
                case AnythingLine: {
                    detectionRegEx.append("[^<>\\r\\n]+");
                    continue block12;
                }
                case AnythingExact: {
                    detectionRegEx.append(".{").append(action.var).append("}");
                    continue block12;
                }
                case AnythingLess: {
                    detectionRegEx.append(".{0,").append((Integer)action.var + 1).append("}");
                    continue block12;
                }
                case AnythingMore: {
                    detectionRegEx.append(".{").append(action.var).append(",}");
                    continue block12;
                }
                case AnythingSet: {
                    if (varSet.get((String)action.var) != null) {
                        throw new Exception("(Token:" + (Object)((Object)token.type) + ") Trying to set a variable(" + action.var + ") that has already been set!");
                    }
                    detectionRegEx.append("(?<").append(action.var).append(">[^<>\\r\\n]+)");
                    varSet.put((String)action.var, true);
                    continue block12;
                }
                case AnythingGet: {
                    if (varSet.get((String)action.var) == null) {
                        if (this.variableMap.get((String)action.var) == null) {
                            throw new Exception("(Token:" + (Object)((Object)token.type) + ") Trying to get a variable(" + action.var + ") which has not yet been set!");
                        }
                        detectionRegEx.append("(?<").append(action.var).append(">").append(this.variableMap.get((String)action.var)).append(")");
                        varSet.put((String)action.var, true);
                        continue block12;
                    }
                    detectionRegEx.append("\\k<").append(action.var).append(">");
                    continue block12;
                }
                case RegEx: {
                    detectionRegEx.append("(?<").append(((String[])action.var)[0]).append(">").append(((String[])action.var)[1]).append(")");
                    varSet.put(((String[])action.var)[0], true);
                    continue block12;
                }
                case TouchVar: {
                    varSet.put((String)action.var, true);
                }
            }
        }
    }

    public static class ReplacementToken {
        public TokenType type;
        public Object var;

        public ReplacementToken(TokenType type) {
            this.type = type;
        }

        public ReplacementToken(TokenType type, Object var) {
            this.type = type;
            this.var = var;
        }
    }

    public static class CommandToken {
        public TokenType type;
        public String text;
        public List<ReplacementToken> replacementTokens = new ArrayList<ReplacementToken>();
        public static int tokenCounter = 0;
        public int tokenId;

        public CommandToken(TokenType type) {
            this.type = type;
            this.tokenId = tokenCounter++;
        }

        public CommandToken(TokenType type, String text) {
            this.type = type;
            this.text = text;
            this.tokenId = tokenCounter++;
        }
    }

    public static enum TokenType {
        Anything,
        AnythingLine,
        AnythingLess,
        AnythingMore,
        AnythingExact,
        AnythingSet,
        AnythingGet,
        RegEx,
        TouchVar,
        Text,
        CommandOrigin,
        CommandLimit,
        CommandReset,
        CommandUnlimit,
        CommandStart,
        CommandEnd,
        CommandAdd,
        CommandSubtract;

    }
}

