/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.commands;

import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.commands.CommandEnabled;
import com.wildex999.tickdynamic.commands.CommandListWorlds;
import com.wildex999.tickdynamic.commands.CommandReload;
import com.wildex999.tickdynamic.commands.CommandReloadGroups;
import com.wildex999.tickdynamic.commands.CommandWorld;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandHandler
implements ICommand {
    private List<String> aliases = new ArrayList<String>();
    private Map<String, ICommand> subCommandHandlers;
    private String listSubCommands;

    public CommandHandler() {
        SubCommands[] subs;
        this.aliases.add("tickdynamic");
        this.aliases.add("td");
        this.subCommandHandlers = new HashMap<String, ICommand>();
        this.subCommandHandlers.put("reload", new CommandReload());
        this.subCommandHandlers.put("reloadgroups", new CommandReloadGroups());
        this.subCommandHandlers.put("listworlds", new CommandListWorlds());
        this.subCommandHandlers.put("world", new CommandWorld());
        this.subCommandHandlers.put("enabled", new CommandEnabled());
        StringBuilder builderSubCommands = new StringBuilder();
        for (SubCommands command : subs = SubCommands.values()) {
            builderSubCommands.append((Object)command).append(", ");
        }
        builderSubCommands.delete(builderSubCommands.length() - 2, builderSubCommands.length());
        this.listSubCommands = builderSubCommands.toString();
    }

    public String func_71517_b() {
        return "tickdynamic";
    }

    public String func_71518_a(ICommandSender sender) {
        return "tickdynamic [" + this.listSubCommands + "]";
    }

    public List func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: " + this.func_71518_a(sender)));
            return;
        }
        switch (args[0]) {
            case "tps": {
                sender.func_145747_a((ITextComponent)new TextComponentString("Average TPS: " + CommandHandler.getTPSFormatted() + " TPS"));
                return;
            }
            case "identify": {
                sender.func_145747_a((ITextComponent)new TextComponentString("Command not yet implemented! This will allow you to check what group a Tile or Entity belongs to by right clicking it.(And other info, like TPS)"));
                return;
            }
            case "help": {
                sender.func_145747_a((ITextComponent)new TextComponentString("You can find the documentation over at http://mods.stjerncraft.com/tickdynamic"));
                return;
            }
        }
        ICommand subHandler = this.subCommandHandlers.get(args[0]);
        if (subHandler == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "No handler for the command " + TextFormatting.ITALIC + args[0]));
            return;
        }
        subHandler.func_184881_a(server, sender, args);
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(1, this.func_71517_b());
    }

    public List func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            SubCommands[] subCommands;
            LinkedList<String> listOut = new LinkedList<String>();
            String lastArg = args[args.length - 1];
            for (SubCommands command : subCommands = SubCommands.values()) {
                if (!command.toString().contains(lastArg)) continue;
                listOut.add(command.toString());
            }
            return listOut;
        }
        ICommand subHandler = this.subCommandHandlers.get(args[0]);
        if (subHandler == null) {
            return null;
        }
        return subHandler.func_184883_a(server, sender, args, pos);
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    public static String getTPSFormatted() {
        String color = TickDynamicMod.instance.averageTPS >= 19.0 ? TextFormatting.GREEN.toString() : (TickDynamicMod.instance.averageTPS > 10.0 ? TextFormatting.YELLOW.toString() : TextFormatting.RED.toString());
        DecimalFormat tpsFormat = new DecimalFormat("#.00");
        String tpsOut = color + tpsFormat.format(TickDynamicMod.instance.averageTPS) + TextFormatting.RESET;
        return tpsOut;
    }

    public static enum SubCommands {
        tps,
        listworlds,
        world,
        identify,
        reload,
        reloadgroups,
        enabled,
        help;

    }
}

