/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.commands;

import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.timemanager.TimeManager;
import com.wildex999.tickdynamic.timemanager.TimedGroup;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.commons.lang3.StringUtils;

public class CommandListWorlds
implements ICommand {
    private String formatCode = "\u00a7";
    private int borderWidth = 50;
    private int rowsPerPage = 6;
    private int currentPage;
    private int maxPages;

    public String func_71517_b() {
        return "tickdynamic listworlds";
    }

    public String func_71518_a(ICommandSender sender) {
        return "tickdynamic listworlds [page]";
    }

    public List func_71514_a() {
        return null;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length > 1 && args[1].equals("help")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: " + this.func_71518_a(sender)));
            return;
        }
        StringBuilder outputBuilder = new StringBuilder();
        DecimalFormat decimalFormat = new DecimalFormat("#.00");
        this.currentPage = 1;
        this.maxPages = 0;
        if (args.length == 2) {
            try {
                this.currentPage = Integer.parseInt(args[1]);
                if (this.currentPage <= 0) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Page number must be 1 and up, got: " + args[1]));
                    this.currentPage = 1;
                }
            }
            catch (Exception e) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Expected a page number, got: " + args[1]));
                return;
            }
        }
        this.writeHeader(outputBuilder);
        int extraCount = 2;
        int listSize = server.field_71305_c.length + extraCount;
        this.maxPages = listSize > this.rowsPerPage ? (int)Math.ceil((float)listSize / (float)this.rowsPerPage) : 1;
        if (this.currentPage > this.maxPages) {
            this.currentPage = this.maxPages;
        }
        int toSkip = (this.currentPage - 1) * this.rowsPerPage;
        int toSend = this.rowsPerPage;
        for (WorldServer world : server.field_71305_c) {
            if (toSkip-- > 0) continue;
            if (toSend-- <= 0) break;
            TimeManager worldManager = TickDynamicMod.instance.getWorldTimeManager((World)world);
            if (world == null || worldManager == null) continue;
            outputBuilder.append(TextFormatting.GRAY + "| ").append(TextFormatting.RESET).append(world.field_73011_w.func_186058_p().func_186065_b());
            String usedTime = decimalFormat.format((double)worldManager.getTimeUsedAverage() / 1000000.0);
            String maxTime = decimalFormat.format((double)worldManager.getTimeMax() / 1000000.0);
            outputBuilder.append(TextFormatting.GRAY + " || ").append(TextFormatting.RESET).append(usedTime).append("/").append(maxTime);
            outputBuilder.append(TextFormatting.GRAY + " || ").append(TextFormatting.RESET).append(worldManager.getSliceMax()).append("\n");
        }
        if (this.currentPage == this.maxPages) {
            TimedGroup other = TickDynamicMod.instance.getTimedGroup("other");
            if (other != null) {
                outputBuilder.append(TextFormatting.GRAY + "| ").append(TextFormatting.RESET + "(Other)");
                String usedTime = decimalFormat.format((double)other.getTimeUsedAverage() / 1000000.0);
                outputBuilder.append(TextFormatting.GRAY + " || ").append(TextFormatting.RESET).append(usedTime);
                outputBuilder.append(TextFormatting.GRAY + " || ").append(TextFormatting.RESET).append("N/A\n");
            }
            TimedGroup external = TickDynamicMod.instance.getTimedGroup("external");
            if (other != null) {
                outputBuilder.append(TextFormatting.GRAY + "| ").append(TextFormatting.RESET + "(External)");
                String usedTime = decimalFormat.format((double)external.getTimeUsedAverage() / 1000000.0);
                outputBuilder.append(TextFormatting.GRAY + " || ").append(TextFormatting.RESET).append(usedTime);
                outputBuilder.append(TextFormatting.GRAY + " || ").append(TextFormatting.RESET).append("N/A\n");
            }
        }
        this.writeFooter(outputBuilder);
        this.splitAndSend(sender, outputBuilder);
    }

    public void writeHeader(StringBuilder builder) {
        builder.append(TextFormatting.GREEN + "Worlds list with time. Usage: tickdynamic worldList [page]\n");
        builder.append(TextFormatting.GRAY + "+").append(StringUtils.repeat((String)"=", (int)this.borderWidth)).append("+\n");
        builder.append(TextFormatting.GRAY + "| ").append(TextFormatting.GOLD + "World").append(TextFormatting.GRAY);
        builder.append(" || ").append(TextFormatting.GOLD + "Time(Used/Allocated)").append(TextFormatting.GRAY);
        builder.append(" || ").append(TextFormatting.GOLD + "MaxSlices").append(TextFormatting.GRAY);
        builder.append("\n");
    }

    public void writeFooter(StringBuilder builder) {
        if (this.maxPages == 0) {
            builder.append(TextFormatting.GRAY + "+").append(StringUtils.repeat((String)"=", (int)this.borderWidth)).append("+\n");
        } else {
            String pagesStr = TextFormatting.GREEN + "Page " + this.currentPage + "/" + this.maxPages;
            int pagesLength = this.getVisibleLength(pagesStr);
            int otherLength = this.borderWidth - pagesLength;
            builder.append(TextFormatting.GRAY + "+").append(StringUtils.repeat((String)"=", (int)(otherLength / 2)));
            builder.append(pagesStr);
            builder.append(TextFormatting.GRAY).append(StringUtils.repeat((String)"=", (int)(otherLength / 2))).append("+\n");
        }
    }

    public void splitAndSend(ICommandSender sender, StringBuilder outputBuilder) {
        String[] chatLines;
        for (String chatLine : chatLines = outputBuilder.toString().split("\n")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(chatLine));
        }
    }

    public int getVisibleLength(String str) {
        return str.length() - StringUtils.countMatches((CharSequence)str, (CharSequence)this.formatCode) * 2;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(1, this.func_71517_b());
    }

    public List func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return null;
    }

    public boolean func_82358_a(String[] p_82358_1_, int p_82358_2_) {
        return false;
    }

    public int compareTo(ICommand o) {
        return 0;
    }
}

