/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.commands;

import com.wildex999.tickdynamic.listinject.EntityGroup;
import com.wildex999.tickdynamic.listinject.ListManager;
import com.wildex999.tickdynamic.timemanager.TimedEntities;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.StringUtils;

public class CommandWorld
implements ICommand {
    private int borderWidth = 50;
    private World world;
    private int rowsPerPage = 6;
    private int currentPage;
    private int maxPages;
    private final DecimalFormat decimalFormat = new DecimalFormat("#.00");
    private final String formatCode = "\u00a7";

    public String func_71517_b() {
        return "tickdynamic world";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "tickdynamic world (world dim) [page]";
    }

    public List func_71514_a() {
        return null;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        int worldDim;
        String worldDimStr;
        if (args.length <= 1) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: " + this.func_71518_a(sender)));
            return;
        }
        StringBuilder outputBuilder = new StringBuilder();
        this.currentPage = 1;
        this.maxPages = 0;
        if (args.length == 3) {
            try {
                this.currentPage = Integer.parseInt(args[2]);
                if (this.currentPage <= 0) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Page number must be 1 and up, got: " + args[2]));
                    this.currentPage = 1;
                }
            }
            catch (Exception e) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Expected a page number, got: " + args[2]));
                return;
            }
        }
        if ((worldDimStr = args[1]).startsWith("dim")) {
            worldDimStr = worldDimStr.substring(3);
        }
        try {
            worldDim = Integer.parseInt(worldDimStr);
        }
        catch (Exception e) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Expected a world dimension(Ex: dim0 or just 0), got: " + worldDimStr));
            return;
        }
        this.world = DimensionManager.getWorld((int)worldDim);
        if (this.world == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "No world with dimension id: " + worldDimStr));
            return;
        }
        this.writeHeader(outputBuilder);
        ArrayList<EntityGroup> groups = new ArrayList<EntityGroup>();
        if (this.world.field_72996_f instanceof ListManager) {
            this.addGroupsFromList(groups, (ListManager)this.world.field_72996_f);
        }
        if (this.world.field_175730_i instanceof ListManager) {
            this.addGroupsFromList(groups, (ListManager)this.world.field_175730_i);
        }
        groups.sort((o1, o2) -> {
            EntityGroup group1 = o1;
            EntityGroup group2 = o2;
            return group1.getName().compareTo(group2.getName());
        });
        int listSize = groups.size();
        this.maxPages = listSize > this.rowsPerPage ? (int)Math.ceil((float)listSize / (float)this.rowsPerPage) : 1;
        if (this.currentPage > this.maxPages) {
            this.currentPage = this.maxPages;
        }
        int toSkip = (this.currentPage - 1) * this.rowsPerPage;
        int toSend = this.rowsPerPage;
        for (EntityGroup group : groups) {
            if (toSkip-- > 0) continue;
            if (toSend-- <= 0) break;
            this.writeGroup(outputBuilder, group);
        }
        this.writeFooter(outputBuilder);
        this.splitAndSend(sender, outputBuilder);
    }

    private void addGroupsFromList(List<EntityGroup> targetList, ListManager worldList) {
        Iterator<EntityGroup> it = worldList.getGroupIterator();
        while (it.hasNext()) {
            targetList.add(it.next());
        }
    }

    private void writeHeader(StringBuilder builder) {
        builder.append(TextFormatting.GREEN + "Groups for world: ").append(TextFormatting.RESET).append(this.world.field_73011_w.func_186058_p().func_186065_b()).append("(DIM: ").append(this.world.field_73011_w.getDimension()).append(")\n");
        builder.append(TextFormatting.GRAY + "+").append(StringUtils.repeat((String)"=", (int)this.borderWidth)).append("+\n");
        builder.append(TextFormatting.GRAY + "| ").append(TextFormatting.GOLD + "Group").append(TextFormatting.GRAY);
        builder.append(" || ").append(TextFormatting.GOLD + "Time(Avg.)").append(TextFormatting.GRAY);
        builder.append(" || ").append(TextFormatting.GOLD + "EntitiesRun(Avg.)").append(TextFormatting.GRAY);
        builder.append(" || ").append(TextFormatting.GOLD + "MaxSlices").append(TextFormatting.GRAY);
        builder.append(" || ").append(TextFormatting.GOLD + "TPS(Avg.)").append(TextFormatting.GRAY);
        builder.append("\n");
    }

    private void writeGroup(StringBuilder builder, EntityGroup group) {
        TimedEntities timedGroup = group.timedGroup;
        builder.append(TextFormatting.GRAY + "| ").append(TextFormatting.RESET).append(group.getName());
        if (timedGroup == null) {
            builder.append(TextFormatting.RED + " N/A\n");
            return;
        }
        String usedTime = this.decimalFormat.format((double)timedGroup.getTimeUsedAverage() / 1000000.0);
        String maxTime = this.decimalFormat.format((double)timedGroup.getTimeMax() / 1000000.0);
        builder.append(TextFormatting.GRAY + " || ").append(TextFormatting.RESET).append(usedTime).append("/").append(maxTime);
        int runObjects = timedGroup.getObjectsRunAverage();
        int countObjects = group.entities.size();
        builder.append(TextFormatting.GRAY + " || ").append(TextFormatting.RESET).append(runObjects).append("/").append(countObjects);
        builder.append(TextFormatting.GRAY + " || ").append(TextFormatting.RESET).append(timedGroup.getSliceMax());
        String color = timedGroup.averageTPS >= 19.0 ? TextFormatting.GREEN.toString() : (timedGroup.averageTPS > 10.0 ? TextFormatting.YELLOW.toString() : TextFormatting.RED.toString());
        builder.append(TextFormatting.GRAY + " || ").append(color).append(this.decimalFormat.format(timedGroup.averageTPS)).append(TextFormatting.RESET + "TPS");
        builder.append("\n");
    }

    private void writeFooter(StringBuilder builder) {
        if (this.maxPages == 0) {
            builder.append(TextFormatting.GRAY + "+").append(StringUtils.repeat((String)"=", (int)this.borderWidth)).append("+\n");
        } else {
            String pagesStr = TextFormatting.GREEN + "Page " + this.currentPage + "/" + this.maxPages;
            int pagesLength = this.getVisibleLength(pagesStr);
            int otherLength = this.borderWidth - pagesLength;
            builder.append(TextFormatting.GRAY + "+").append(StringUtils.repeat((String)"=", (int)(otherLength / 2)));
            builder.append(pagesStr);
            builder.append(TextFormatting.GRAY).append(StringUtils.repeat((String)"=", (int)(otherLength / 2))).append("+\n");
        }
    }

    public int getVisibleLength(String str) {
        return str.length() - StringUtils.countMatches((CharSequence)str, (CharSequence)"\u00a7") * 2;
    }

    public void splitAndSend(ICommandSender sender, StringBuilder outputBuilder) {
        String[] chatLines;
        for (String chatLine : chatLines = outputBuilder.toString().split("\n")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(chatLine));
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(1, this.func_71517_b());
    }

    public List func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return null;
    }

    public boolean func_82358_a(String[] p_82358_1_, int p_82358_2_) {
        return false;
    }

    public int compareTo(ICommand o) {
        return 0;
    }
}

