/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.listinject;

import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.listinject.EntityGroup;
import com.wildex999.tickdynamic.listinject.EntityObject;
import com.wildex999.tickdynamic.listinject.ListManager;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class EntityIteratorTimed
implements Iterator<EntityObject> {
    private ListManager list;
    private int currentAge;
    private int remainingCount;
    private int currentOffset;
    private int updateCount;
    private boolean startedTimer;
    private EntityGroup currentGroup;
    private EntityObject currentObject;
    private Iterator<EntityGroup> groupIterator;
    private List<EntityObject> entityList;

    public EntityIteratorTimed(ListManager list, int currentAge) {
        this.list = list;
        this.currentAge = currentAge;
        this.groupIterator = list.getGroupIterator();
        this.remainingCount = 0;
        this.startedTimer = false;
    }

    @Override
    public boolean hasNext() {
        if (!this.ageMatches(this.list.age)) {
            throw new ConcurrentModificationException("List modified before going to next entry.");
        }
        if (this.remainingCount > 0 && !this.entityList.isEmpty()) {
            return true;
        }
        if (this.startedTimer && this.currentGroup != null) {
            this.currentGroup.timedGroup.endUpdateObjects(this.updateCount);
            this.currentGroup.timedGroup.endTimer();
        }
        this.updateCount = 0;
        this.currentGroup = null;
        this.startedTimer = false;
        this.entityList = null;
        while (this.entityList == null) {
            if (!this.groupIterator.hasNext()) {
                return false;
            }
            this.currentGroup = this.groupIterator.next();
            this.entityList = this.currentGroup.entities;
            if (this.entityList.size() <= 0) {
                this.entityList = null;
                continue;
            }
            this.currentOffset = this.currentGroup.timedGroup.startUpdateObjects();
            this.remainingCount = this.currentGroup.timedGroup.getUpdateCount();
            this.updateCount = 0;
        }
        return true;
    }

    @Override
    public EntityObject next() {
        if (!this.ageMatches(this.list.age)) {
            throw new ConcurrentModificationException("List modified before going to next entry");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (!this.startedTimer) {
            this.startedTimer = true;
            this.currentGroup.timedGroup.startTimer();
        }
        if (this.currentOffset >= this.entityList.size()) {
            this.currentOffset = 0;
        }
        this.currentObject = this.entityList.get(this.currentOffset);
        --this.remainingCount;
        ++this.currentOffset;
        ++this.updateCount;
        return this.currentObject;
    }

    @Override
    public void remove() {
        if (!this.ageMatches(this.list.age)) {
            throw new ConcurrentModificationException("List modified before going to next entry");
        }
        if (this.currentObject == null) {
            return;
        }
        if (this.list.remove(this.currentObject)) {
            ++this.currentAge;
            --this.currentOffset;
        } else {
            TickDynamicMod.logError("Failed to remove: " + this.currentObject + " from loaded entity list!", new Object[0]);
        }
        if (this.currentAge != this.list.age) {
            throw new RuntimeException("ASSERT FAILED: " + this.currentAge + " : " + this.list.age);
        }
        if (this.currentOffset < 0) {
            this.currentOffset = 0;
        }
    }

    public boolean ageMatches(int age) {
        return this.currentAge == age;
    }
}

