/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.listinject;

import com.wildex999.tickdynamic.TickDynamicConfig;
import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.listinject.CustomProfiler;
import com.wildex999.tickdynamic.listinject.EntityGroup;
import com.wildex999.tickdynamic.listinject.EntityIterator;
import com.wildex999.tickdynamic.listinject.EntityIteratorTimed;
import com.wildex999.tickdynamic.listinject.EntityObject;
import com.wildex999.tickdynamic.listinject.EntityType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.common.config.ConfigCategory;
import org.apache.commons.lang3.NotImplementedException;

public class ListManager<T extends EntityObject>
implements List<T> {
    protected World world;
    protected EntityType entityType;
    protected HashSet<EntityGroup> localGroups;
    protected Map<Class, EntityGroup> groupMap;
    protected EntityGroup ungroupedEntities;
    protected Queue<EntityObject> queuedEntities;
    protected List<EntityPlayer> playerEntities;
    protected CustomProfiler customProfiler;
    protected int entityCount;
    protected int age;

    public ListManager(World world, EntityType type) {
        this.world = world;
        this.customProfiler = (CustomProfiler)world.field_72984_F;
        this.entityType = type;
        this.localGroups = new HashSet();
        this.groupMap = new HashMap<Class, EntityGroup>();
        this.playerEntities = new ArrayList<EntityPlayer>();
        this.queuedEntities = new ArrayDeque<EntityObject>();
        this.entityCount = 0;
        this.age = 0;
        TickDynamicMod.logDebug("Initializing " + (Object)((Object)type) + " list for world: " + world.field_73011_w.func_186058_p().func_186065_b() + "(DIM" + world.field_73011_w.getDimension() + ")", new Object[0]);
        this.loadLocalGroups();
        this.loadGlobalGroups();
        this.ungroupedEntities = type == EntityType.Entity ? TickDynamicMod.instance.getWorldEntityGroup(world, "entity", type, false, false) : TickDynamicMod.instance.getWorldEntityGroup(world, "tileentity", type, false, false);
        if (this.ungroupedEntities == null || !this.localGroups.contains(this.ungroupedEntities)) {
            throw new RuntimeException("TickDynamic Assert failure: Could not find " + (Object)((Object)type) + " group during world initialization!");
        }
        this.createGroupMap();
    }

    private void loadLocalGroups() {
        ConfigCategory config = TickDynamicMod.instance.getWorldConfigCategory(this.world);
        for (ConfigCategory localGroupCategory : config.getChildren()) {
            String name = localGroupCategory.getName();
            EntityGroup localGroup = TickDynamicMod.instance.getWorldEntityGroup(this.world, name, this.entityType, true, true);
            if (localGroup.getGroupType() != this.entityType || this.localGroups.contains(localGroup)) continue;
            TickDynamicMod.logDebug("Load local group: " + name, new Object[0]);
            this.localGroups.add(localGroup);
            localGroup.list = this;
        }
    }

    private void loadGlobalGroups() {
        ConfigCategory config = TickDynamicMod.instance.config.getCategory("groups");
        for (ConfigCategory groupCategory : config.getChildren()) {
            EntityGroup localGroup;
            String name = groupCategory.getName();
            EntityGroup globalGroup = TickDynamicMod.instance.getEntityGroup("groups." + name);
            if (globalGroup == null || globalGroup.getGroupType() != this.entityType || this.localGroups.contains(localGroup = TickDynamicMod.instance.getWorldEntityGroup(this.world, name, this.entityType, true, false))) continue;
            TickDynamicMod.logDebug("Load global group: " + name, new Object[0]);
            this.localGroups.add(localGroup);
            localGroup.list = this;
        }
    }

    public void createGroupMap() {
        TickDynamicMod.logDebug("Creating Group map", new Object[0]);
        this.groupMap.clear();
        for (EntityGroup group : this.localGroups) {
            Set<Class> entries = group.getEntityEntries();
            for (Class entityClass : entries) {
                if (TickDynamicMod.debugGroups) {
                    String localPath = group.getConfigEntry();
                    if (localPath == null) {
                        localPath = "-";
                    }
                    String parentPath = "None";
                    if (group.base != null) {
                        parentPath = group.base.getConfigEntry();
                    }
                    TickDynamicMod.logInfo("Mapping: " + entityClass + " -> " + localPath + "(Global: " + parentPath + ")", new Object[0]);
                }
                this.groupMap.put(entityClass, group);
            }
        }
        TickDynamicMod.logDebug("Done!", new Object[0]);
    }

    public void reloadGroups() {
        TickDynamicMod.logDebug("Reloading Groups!", new Object[0]);
        TickDynamicConfig.loadGroups("worlds.dim" + this.world.field_73011_w.getDimension());
        ArrayList<EntityObject> entityList = new ArrayList<EntityObject>(this.entityCount);
        Iterator<EntityGroup> groupIterator = this.localGroups.iterator();
        while (groupIterator.hasNext()) {
            EntityGroup group = groupIterator.next();
            entityList.addAll(group.entities);
            group.clearEntities();
            if (!group.valid || group.base != null && !group.base.valid) {
                groupIterator.remove();
                continue;
            }
            group.readConfig(false);
        }
        this.loadLocalGroups();
        this.loadGlobalGroups();
        this.createGroupMap();
        for (EntityObject entity : entityList) {
            this.assignToGroup(entity);
        }
    }

    public void assignToGroup(EntityObject object) {
        if (object == null) {
            TickDynamicMod.logError("Error: Could not assign null object to group!", new Object[0]);
            return;
        }
        EntityGroup group = object.TD_entityGroup;
        if (group != null) {
            group.removeEntity(object);
        }
        if ((group = this.groupMap.get(object.getClass())) == null) {
            if (TickDynamicMod.debugGroups) {
                TickDynamicMod.logDebug("Adding Entity: " + object.getClass() + " -> Ungrouped(" + (Object)((Object)this.entityType) + ")", new Object[0]);
            }
            this.ungroupedEntities.addEntity(object);
        } else {
            if (TickDynamicMod.debugGroups) {
                TickDynamicMod.logDebug("Adding Entity: " + object.getClass() + " -> " + group.getName(), new Object[0]);
            }
            group.addEntity(object);
        }
    }

    public int getAge() {
        return this.age;
    }

    public Iterator<EntityGroup> getGroupIterator() {
        return this.localGroups.iterator();
    }

    @Override
    public boolean add(EntityObject element) {
        if (element.TD_entityGroup != null) {
            return false;
        }
        if (element.TD_selfTileEntity != null && !(element.TD_selfTileEntity instanceof ITickable)) {
            return false;
        }
        this.assignToGroup(element);
        ++this.entityCount;
        return true;
    }

    @Override
    public void add(int index, EntityObject element) {
        this.add(element);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (EntityObject element : c) {
            this.add(element);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.addAll(c);
    }

    @Override
    public void clear() {
        for (EntityGroup group : this.localGroups) {
            group.clearEntities();
        }
        this.entityCount = 0;
        ++this.age;
        TickDynamicMod.logDebug("Cleared all loaded object of the type " + (Object)((Object)this.entityType) + " from world: " + (this.world == null ? "Unknown" : this.world.field_73011_w.func_186058_p().func_186065_b()), new Object[0]);
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof EntityObject)) {
            return false;
        }
        EntityObject entityObject = (EntityObject)object;
        return entityObject.TD_entityGroup != null && entityObject.TD_entityGroup.list == this;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int index) {
        if (index >= this.entityCount || index < 0) {
            throw new IndexOutOfBoundsException("Tried to get index: " + index + ", but size is: " + this.entityCount);
        }
        int offset = 0;
        for (EntityGroup group : this.localGroups) {
            if (offset + group.getEntityCount() > index) {
                return (T)group.entities.get(index - offset);
            }
            offset += group.getEntityCount();
        }
        throw new IndexOutOfBoundsException("Reached end of groups before finding index: " + index);
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof EntityObject)) {
            return -1;
        }
        EntityObject obj = (EntityObject)o;
        if (obj.TD_entityGroup == null || obj.TD_entityGroup.list != this) {
            return -1;
        }
        int offset = 0;
        for (EntityGroup group : this.localGroups) {
            if (obj.TD_entityGroup == group) {
                int index = group.entities.indexOf(obj);
                if (index == -1) {
                    return -1;
                }
                return offset + index;
            }
            offset += group.getEntityCount();
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.entityCount == 0;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof EntityObject)) {
            return -1;
        }
        EntityObject obj = (EntityObject)o;
        if (obj.TD_entityGroup == null || obj.TD_entityGroup.list != this) {
            return -1;
        }
        int offset = 0;
        int lastIndex = -1;
        for (EntityGroup group : this.localGroups) {
            if (obj.TD_entityGroup == group) {
                int index = group.entities.indexOf(obj);
                if (index == -1) {
                    return -1;
                }
                lastIndex = offset + index;
            }
            offset += group.getEntityCount();
        }
        return lastIndex;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.customProfiler.reachedTile) {
            this.customProfiler.reachedTile = false;
            return new EntityIteratorTimed(this, this.getAge());
        }
        return new EntityIterator(this, this.getAge());
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new NotImplementedException("listIterator is not implemented in TickDynamic's List implementation!");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new NotImplementedException("listIterator(index) is not implemented in TickDynamic's List implementation!");
    }

    @Override
    public boolean remove(Object object) {
        if (!this.contains(object)) {
            TickDynamicMod.logWarn("Failed to remove: " + object + " as it does not exist in the list.", new Object[0]);
            return false;
        }
        EntityObject entityObject = (EntityObject)object;
        if (entityObject.TD_entityGroup.removeEntity(entityObject)) {
            --this.entityCount;
            ++this.age;
            return true;
        }
        TickDynamicMod.logError("Failed to remove: " + object + " unknown reason!", new Object[0]);
        return false;
    }

    @Override
    public T remove(int index) {
        Thread.dumpStack();
        TickDynamicMod.logDebug("Debug Warning: Using slow remove of objects(Remove by index)!", new Object[0]);
        Object entityObject = this.get(index);
        if (this.remove(entityObject)) {
            return (T)entityObject;
        }
        return null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object obj : c) {
            this.remove(obj);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new NotImplementedException("retainAll is not implemented in TickDynamic's List implementation!");
    }

    @Override
    public T set(int index, EntityObject element) {
        throw new NotImplementedException("set is not implemented in TickDynamic's List implementation!");
    }

    @Override
    public int size() {
        return this.entityCount;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new NotImplementedException("subList is not implemented in TickDynamic's List implementation!");
    }

    @Override
    public Object[] toArray() {
        TickDynamicMod.logDebug("SLOW toArray call on Entity/TileEntity list!", new Object[0]);
        Object[] objects = new Object[this.entityCount];
        int offset = 0;
        for (EntityGroup group : this.localGroups) {
            System.arraycopy(group.entities.toArray(), 0, objects, offset, group.entities.size());
            offset += group.entities.size();
        }
        return objects;
    }

    @Override
    @Nonnull
    public <E> E[] toArray(E[] a) {
        if (a.length < this.size()) {
            return Arrays.copyOf(this.toArray(), this.size(), a.getClass());
        }
        System.arraycopy(this.toArray(), 0, a, 0, this.size());
        if (a.length > this.size()) {
            a[this.size()] = null;
        }
        return a;
    }
}

