/*
 * Decompiled with CFR 0.152.
 */
package com.wildex999.tickdynamic.timemanager;

import com.wildex999.tickdynamic.TickDynamicMod;
import com.wildex999.tickdynamic.timemanager.ITimed;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.World;

public class TimeManager
implements ITimed {
    private int sliceMax;
    private long timeMax;
    private List<ITimed> children = new ArrayList<ITimed>();
    private boolean useCached;
    private long cachedTimeUsedAverage;
    private long cachedTimeReserved;
    public final String name;
    public final World world;
    public String configEntry;

    public TimeManager(World world, String name, String configEntry) {
        if (configEntry != null) {
            TickDynamicMod.instance.timedObjects.put(configEntry, this);
        } else {
            TickDynamicMod.instance.timedObjects.put(name, this);
        }
        this.name = name;
        this.world = world;
        this.configEntry = configEntry;
    }

    @Override
    public void init() {
        this.setTimeMax(0L);
        this.cachedTimeUsedAverage = 0L;
        this.cachedTimeReserved = 0L;
        int configSlices = 100;
        if (this.configEntry != null) {
            this.loadConfig(true);
        } else {
            this.setSliceMax(TickDynamicMod.instance.defaultWorldSlicesMax);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void loadConfig(boolean saveDefaults) {
        if (this.configEntry == null) {
            return;
        }
        this.setSliceMax(TickDynamicMod.instance.config.get(this.configEntry, "slicesMax", TickDynamicMod.instance.defaultWorldSlicesMax).getInt());
        if (saveDefaults) {
            TickDynamicMod.instance.config.save();
        }
    }

    @Override
    public void writeConfig(boolean saveFile) {
        if (this.configEntry == null) {
            return;
        }
        TickDynamicMod.instance.config.get(this.configEntry, "slicesMax", TickDynamicMod.instance.defaultWorldSlicesMax).setValue(this.getSliceMax());
        if (saveFile) {
            TickDynamicMod.instance.config.save();
        }
    }

    public void balanceTime() {
        if (!TickDynamicMod.instance.enabled) {
            return;
        }
        if (TickDynamicMod.debugTimer) {
            TickDynamicMod.logTrace(this.name + ": balanceTime for " + this.children.size() + " children, with " + this.timeMax + " to give.", new Object[0]);
        }
        long leftover = this.timeMax;
        int allSlices = 0;
        ArrayList<ITimed> childrenLeft = new ArrayList<ITimed>(this.children);
        Iterator it = childrenLeft.iterator();
        while (it.hasNext()) {
            ITimed timed = (ITimed)it.next();
            timed.setTimeMax(0L);
            allSlices += timed.getSliceMax();
            if (timed.getSliceMax() == 0) {
                if (TickDynamicMod.debugTimer) {
                    TickDynamicMod.logTrace(timed.getName() + " reserved: " + timed.getTimeUsedAverage(), new Object[0]);
                }
                it.remove();
                if ((leftover -= timed.getTimeUsedAverage()) > 0L) continue;
                leftover = 1L;
                continue;
            }
            long reserved = timed.getReservedTime();
            if (TickDynamicMod.debugTimer) {
                TickDynamicMod.logTrace(timed.getName() + " children Reserved: " + reserved, new Object[0]);
            }
            timed.setTimeMax(reserved);
            if ((leftover -= reserved) > 0L) continue;
            leftover = 1L;
        }
        int allSlicesPrev = allSlices;
        boolean firstPass = true;
        while (leftover > 0L && childrenLeft.size() > 0) {
            long before = leftover;
            if (TickDynamicMod.debugTimer) {
                TickDynamicMod.logTrace("Leftover: " + leftover, new Object[0]);
            }
            Iterator it2 = childrenLeft.iterator();
            while (it2.hasNext()) {
                long reserved;
                ITimed child = (ITimed)it2.next();
                long slice = 1L + (long)((double)before * ((double)child.getSliceMax() / (double)allSlices));
                if (firstPass && (slice -= (reserved = child.getReservedTime())) < 0L) {
                    slice = 0L;
                }
                long currentMax = child.getTimeMax() + slice;
                leftover -= slice;
                long left = currentMax - child.getTimeUsedAverage();
                if ((double)left > (double)currentMax / 100.0) {
                    long giveBack = (long)((double)left - (double)currentMax / 100.0);
                    leftover += giveBack;
                    currentMax -= giveBack;
                    it2.remove();
                    allSlices -= child.getSliceMax();
                }
                child.setTimeMax(currentMax + 1L);
                if (!TickDynamicMod.debugTimer) continue;
                TickDynamicMod.logTrace(child.getName() + " currentMax: " + currentMax, new Object[0]);
            }
            firstPass = false;
        }
        if (leftover > 0L) {
            for (ITimed child : this.children) {
                long slice = (long)((double)leftover * ((double)child.getSliceMax() / (double)allSlicesPrev));
                child.setTimeMax(child.getTimeMax() + slice);
            }
        }
        for (ITimed child : this.children) {
            if (!child.isManager()) continue;
            ((TimeManager)child).balanceTime();
        }
    }

    public void addChild(ITimed object) {
        this.children.add(object);
    }

    public void removeChild(ITimed object) {
        this.children.remove(object);
    }

    @Override
    public void setTimeMax(long newTimeMax) {
        if (TickDynamicMod.debugTimer) {
            TickDynamicMod.logTrace(this.name + ": setTimeMax: " + newTimeMax, new Object[0]);
        }
        this.timeMax = newTimeMax;
    }

    @Override
    public long getTimeMax() {
        return this.timeMax;
    }

    @Override
    public void setSliceMax(int newSliceMax) {
        this.sliceMax = newSliceMax;
    }

    @Override
    public int getSliceMax() {
        return this.sliceMax;
    }

    @Override
    public long getTimeUsed() {
        long output = 0L;
        for (ITimed child : this.children) {
            output += child.getTimeUsed();
        }
        return output;
    }

    @Override
    public long getTimeUsedAverage() {
        long output = 0L;
        if (this.useCached) {
            return this.cachedTimeUsedAverage;
        }
        for (ITimed child : this.children) {
            output += child.getTimeUsedAverage();
        }
        return output;
    }

    @Override
    public long getTimeUsedLast() {
        long output = 0L;
        for (ITimed child : this.children) {
            output += child.getTimeUsedLast();
        }
        return output;
    }

    @Override
    public long getReservedTime() {
        long reservedTime = 0L;
        if (this.useCached) {
            return this.cachedTimeReserved;
        }
        for (ITimed child : this.children) {
            reservedTime += child.getReservedTime();
        }
        return reservedTime;
    }

    @Override
    public void newTick(boolean recursive) {
        if (recursive) {
            for (ITimed aChildren : this.children) {
                aChildren.newTick(true);
            }
        }
        this.useCached = false;
    }

    @Override
    public void endTick(boolean recursive) {
        if (recursive) {
            for (ITimed aChildren : this.children) {
                aChildren.endTick(recursive);
            }
        }
        this.cachedTimeUsedAverage = this.getTimeUsedAverage();
        this.cachedTimeReserved = this.getReservedTime();
        this.useCached = true;
    }

    public List<ITimed> getChildren() {
        return this.children;
    }

    @Override
    public boolean isManager() {
        return true;
    }
}

