/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;

public class CraftingHelpers {
    private static final LoadingCache<Pair<CacheableInventoryCrafting, Integer>, Optional<IRecipe>> CACHE_RECIPES = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Pair<CacheableInventoryCrafting, Integer>, Optional<IRecipe>>(){

        public Optional<IRecipe> load(Pair<CacheableInventoryCrafting, Integer> key) throws Exception {
            IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)((CacheableInventoryCrafting)key.getLeft()).getInventoryCrafting(), (World)DimensionManager.getWorld((int)((Integer)key.getRight())));
            return Optional.ofNullable(recipe);
        }
    });

    public static IRecipe findCraftingRecipe(ItemStack itemStack, int index) throws IllegalArgumentException {
        int indexAttempt = index;
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            if (!CraftingHelpers.itemStacksEqual(recipe.func_77571_b(), itemStack) || indexAttempt-- != 0) continue;
            return recipe;
        }
        throw new IllegalArgumentException("Could not find crafting recipe for " + itemStack + "::" + itemStack.func_77978_p() + " with index " + index);
    }

    public static IRecipe findMatchingRecipeCached(InventoryCrafting inventoryCrafting, World world, boolean uniqueInventory) {
        return ((Optional)CACHE_RECIPES.getUnchecked((Object)Pair.of((Object)new CacheableInventoryCrafting(inventoryCrafting, !uniqueInventory), (Object)world.field_73011_w.getDimension()))).orElse(null);
    }

    public static Map.Entry<ItemStack, ItemStack> findFurnaceRecipe(ItemStack itemStack, int index) throws IllegalArgumentException {
        int indexAttempt = index;
        for (Map.Entry<ItemStack, ItemStack> entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            if (!CraftingHelpers.itemStacksEqual((ItemStack)entry.getValue(), itemStack) || indexAttempt-- != 0) continue;
            return entry;
        }
        throw new IllegalArgumentException("Could not find furnace recipe for " + itemStack + "::" + itemStack.func_77978_p() + " with index " + index);
    }

    public static ResourceLocation newRecipeIdentifier(ItemStack output) {
        ResourceLocation id = new ResourceLocation(Loader.instance().activeModContainer().getModId(), output.func_77973_b().getRegistryName().func_110623_a());
        int counter = 10;
        while (ForgeRegistries.RECIPES.containsKey(id)) {
            id = new ResourceLocation(id.func_110624_b(), output.func_77973_b().getRegistryName().func_110623_a() + "_" + ++counter);
        }
        return id;
    }

    public static IRecipe registerRecipe(ResourceLocation id, IRecipe recipe) {
        recipe.setRegistryName(id);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
        return recipe;
    }

    public static boolean itemStacksEqual(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack1 != null && itemStack2 != null && itemStack1.func_77973_b() == itemStack2.func_77973_b() && ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2) && (itemStack1.func_77952_i() == itemStack2.func_77952_i() || itemStack1.func_77952_i() == Short.MAX_VALUE || itemStack2.func_77952_i() == Short.MAX_VALUE || itemStack1.func_77973_b().func_77645_m());
    }

    public static class CacheableInventoryCrafting {
        private final InventoryCrafting inventoryCrafting;

        public CacheableInventoryCrafting(InventoryCrafting inventoryCrafting, boolean copyInventory) {
            if (copyInventory) {
                this.inventoryCrafting = new InventoryCrafting(new Container(){

                    public boolean func_75145_c(EntityPlayer playerIn) {
                        return false;
                    }
                }, inventoryCrafting.func_174922_i(), inventoryCrafting.func_174923_h());
                for (int i = 0; i < inventoryCrafting.func_70302_i_(); ++i) {
                    this.inventoryCrafting.func_70299_a(i, inventoryCrafting.func_70301_a(i).func_77946_l());
                }
            } else {
                this.inventoryCrafting = inventoryCrafting;
            }
        }

        public InventoryCrafting getInventoryCrafting() {
            return this.inventoryCrafting;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheableInventoryCrafting)) {
                return false;
            }
            for (int i = 0; i < this.getInventoryCrafting().func_70302_i_(); ++i) {
                if (ItemStack.func_77989_b((ItemStack)this.getInventoryCrafting().func_70301_a(i), (ItemStack)((CacheableInventoryCrafting)obj).getInventoryCrafting().func_70301_a(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 11 + this.getInventoryCrafting().func_70302_i_();
            for (int i = 0; i < this.getInventoryCrafting().func_70302_i_(); ++i) {
                hash <<= 1;
                hash |= ItemStackHelpers.getItemStackHashCode(this.getInventoryCrafting().func_70301_a(i));
            }
            return hash;
        }
    }
}

