/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.command;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.base.command.ConfigCategoryDescriptor;
import vazkii.quark.base.command.ConfigPropertyDescriptor;
import vazkii.quark.base.module.GlobalConfig;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.network.message.MessageChangeConfig;

public class CommandConfig
extends CommandBase {
    private final Multimap<String, ConfigPropertyDescriptor> configKeys = HashMultimap.create();
    private final List<String> categoryNames = Lists.newArrayList();
    private final Multimap<String, String> keyNames = HashMultimap.create();

    public CommandConfig() {
        Configuration config = ModuleLoader.config;
        List toProcess = config.getCategoryNames().stream().map(name -> new ConfigCategoryDescriptor(null, config, (String)name)).collect(Collectors.toList());
        while (!toProcess.isEmpty()) {
            ConfigCategoryDescriptor key = (ConfigCategoryDescriptor)toProcess.remove(0);
            ConfigCategory category = key.category();
            if (category == null) continue;
            String fullKey = key.getFullKey();
            this.categoryNames.add(fullKey);
            for (Property property : category.getOrderedValues()) {
                this.keyNames.put((Object)fullKey, (Object)property.getName());
                this.configKeys.put((Object)fullKey, (Object)new ConfigPropertyDescriptor(property.getName(), property.getType()));
            }
            for (String subKey : key.subCategories()) {
                toProcess.add(new ConfigCategoryDescriptor(category, config, subKey));
            }
        }
    }

    @Nonnull
    public String func_71517_b() {
        return "quark-config";
    }

    @Nonnull
    public List<String> func_71514_a() {
        return Collections.singletonList("quarkconfig");
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "commands.quarkconfig.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length < 3) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        boolean save = args.length >= 5 && args[4].equals("save");
        String category = args[0];
        String key = args[1];
        String value = args[2];
        if (!this.configKeys.containsKey((Object)category)) {
            throw new CommandException("commands.quarkconfig.invalid_category", new Object[]{category});
        }
        Optional<ConfigPropertyDescriptor> descriptor = this.configKeys.get((Object)category).stream().filter(desc -> desc.key.equals(key)).findFirst();
        if (descriptor.isPresent()) {
            EntityPlayerMP player;
            Property.Type type = descriptor.get().type;
            GlobalConfig.changeConfig(category, key, value, type, save);
            EntityPlayerMP entityPlayerMP = player = args.length >= 4 ? CommandConfig.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[3]) : null;
            if (player != null) {
                NetworkHandler.INSTANCE.sendTo((IMessage)new MessageChangeConfig(category, key, value, type, save), player);
            } else {
                NetworkHandler.INSTANCE.sendToAll((IMessage)new MessageChangeConfig(category, key, value, type, false));
            }
        } else {
            throw new CommandException("commands.quarkconfig.invalid_property", new Object[]{category, key});
        }
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandConfig.func_175762_a((String[])args, this.categoryNames);
        }
        if (args.length == 2) {
            Collection keyNameSet = this.keyNames.get((Object)args[0]);
            if (keyNameSet == null) {
                return Collections.emptyList();
            }
            return CommandConfig.func_175762_a((String[])args, (Collection)keyNameSet);
        }
        if (args.length == 4) {
            return CommandConfig.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 3;
    }
}

