/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.recipe;

import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemFirework;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.arl.recipe.ModRecipe;
import vazkii.arl.util.ItemNBTHelper;

public class FireworkCloningRecipe
extends ModRecipe {
    public FireworkCloningRecipe() {
        super(new ResourceLocation("quark", "firework_cloning"));
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting var1, @Nonnull World var2) {
        boolean foundSource = false;
        boolean foundTarget = false;
        ItemStack source = ItemStack.field_190927_a;
        ItemStack target = ItemStack.field_190927_a;
        for (int i = 0; i < var1.func_70302_i_(); ++i) {
            ItemStack stack = var1.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemFirework) {
                if (stack.func_77978_p() != null && this.hasExplosions(stack)) {
                    if (foundSource) {
                        return false;
                    }
                    source = stack;
                    foundSource = true;
                    continue;
                }
                if (foundTarget) {
                    return false;
                }
                target = stack;
                foundTarget = true;
                continue;
            }
            return false;
        }
        return foundSource && foundTarget && this.getFlight(source) == this.getFlight(target);
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting var1) {
        ItemStack source = ItemStack.field_190927_a;
        ItemStack target = ItemStack.field_190927_a;
        for (int i = 0; i < var1.func_70302_i_(); ++i) {
            ItemStack stack = var1.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (this.hasExplosions(stack)) {
                source = stack;
                continue;
            }
            target = stack;
        }
        if (!source.func_190926_b() && !target.func_190926_b()) {
            ItemStack copy = target.func_77946_l();
            NBTTagCompound cmp = new NBTTagCompound();
            cmp.func_74782_a("Fireworks", (NBTBase)ItemNBTHelper.getCompound((ItemStack)source, (String)"Fireworks", (boolean)false));
            copy.func_77982_d(cmp);
            copy.func_190920_e(1);
            return copy;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return new ItemStack(Items.field_151152_bP);
    }

    public boolean func_192399_d() {
        return true;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList remaining = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !this.hasExplosions(stack)) continue;
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            remaining.set(i, (Object)copy);
        }
        return remaining;
    }

    private byte getFlight(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return ItemNBTHelper.getCompound((ItemStack)stack, (String)"Fireworks", (boolean)false).func_74771_c("Flight");
    }

    private boolean hasExplosions(ItemStack stack) {
        return ItemNBTHelper.getCompound((ItemStack)stack, (String)"Fireworks", (boolean)false).func_74764_b("Explosions");
    }

    public boolean func_194133_a(int x, int y) {
        return true;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        NonNullList list = NonNullList.func_191197_a((int)2, (Object)Ingredient.field_193370_a);
        list.set(0, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151152_bP)}));
        list.set(1, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151152_bP)}));
        return list;
    }
}

