/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import appeng.hooks.TickHandler;
import appeng.items.AEBaseItem;
import appeng.me.Grid;
import appeng.me.GridNode;
import appeng.me.cache.TickManagerCache;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.tile.networking.TileController;
import appeng.util.Platform;
import java.util.HashSet;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ToolDebugCard
extends AEBaseItem {
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (Platform.isClient()) {
            return EnumActionResult.PASS;
        }
        if (player.func_70093_af()) {
            int grids = 0;
            int totalNodes = 0;
            for (Grid g : TickHandler.INSTANCE.getGridList()) {
                ++grids;
                totalNodes += g.getNodes().size();
            }
            this.outputMsg((ICommandSender)player, "Grids: " + grids);
            this.outputMsg((ICommandSender)player, "Total Nodes: " + totalNodes);
        } else {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof IGridHost) {
                GridNode node = (GridNode)((IGridHost)te).getGridNode(AEPartLocation.fromFacing(side));
                if (node != null) {
                    Grid g = node.getInternalGrid();
                    IGridNode center = g.getPivot();
                    this.outputMsg((ICommandSender)player, "This Node: " + node.toString());
                    this.outputMsg((ICommandSender)player, "Center Node: " + center.toString());
                    IPathingGrid pg = (IPathingGrid)g.getCache(IPathingGrid.class);
                    if (pg.getControllerState() == ControllerState.CONTROLLER_ONLINE) {
                        HashSet<IGridNode> next = new HashSet<IGridNode>();
                        next.add(node);
                        int maxLength = 10000;
                        int length = 0;
                        block1: while (!next.isEmpty()) {
                            HashSet<IGridNode> current = next;
                            next = new HashSet();
                            for (IGridNode n : current) {
                                if (n.getMachine() instanceof TileController) break block1;
                                for (IGridConnection c : n.getConnections()) {
                                    next.add(c.getOtherSide(n));
                                }
                            }
                            if (++length <= 10000) continue;
                            break;
                        }
                        this.outputMsg((ICommandSender)player, "Cable Distance: " + length);
                    }
                    if (center.getMachine() instanceof PartP2PTunnel) {
                        this.outputMsg((ICommandSender)player, "Freq: " + ((PartP2PTunnel)center.getMachine()).getFrequency());
                    }
                    TickManagerCache tmc = (TickManagerCache)g.getCache(ITickManager.class);
                    for (Class<? extends IGridHost> c : g.getMachineClasses()) {
                        int o = 0;
                        long nanos = 0L;
                        for (IGridNode oj : g.getMachines(c)) {
                            ++o;
                            nanos += tmc.getAvgNanoTime(oj);
                        }
                        if (nanos < 0L) {
                            this.outputMsg((ICommandSender)player, c.getSimpleName() + " - " + o);
                            continue;
                        }
                        this.outputMsg((ICommandSender)player, c.getSimpleName() + " - " + o + "; " + this.timeMeasurement(nanos));
                    }
                } else {
                    this.outputMsg((ICommandSender)player, "No Node Available.");
                }
            } else {
                this.outputMsg((ICommandSender)player, "Not Networked Block");
            }
            if (te instanceof IPartHost) {
                IPart center = ((IPartHost)te).getPart(AEPartLocation.INTERNAL);
                ((IPartHost)te).markForUpdate();
                if (center != null) {
                    GridNode n = (GridNode)center.getGridNode();
                    this.outputMsg((ICommandSender)player, "Node Channels: " + n.usedChannels());
                    for (IGridConnection gc : n.getConnections()) {
                        AEPartLocation fd = gc.getDirection(n);
                        if (fd == AEPartLocation.INTERNAL) continue;
                        this.outputMsg((ICommandSender)player, fd.toString() + ": " + gc.getUsedChannels());
                    }
                }
            }
            if (te instanceof IAEPowerStorage) {
                IGridNode node;
                IAEPowerStorage ps = (IAEPowerStorage)te;
                this.outputMsg((ICommandSender)player, "Energy: " + ps.getAECurrentPower() + " / " + ps.getAEMaxPower());
                if (te instanceof IGridHost && (node = ((IGridHost)te).getGridNode(AEPartLocation.fromFacing(side))) != null && node.getGrid() != null) {
                    IEnergyGrid eg = (IEnergyGrid)node.getGrid().getCache(IEnergyGrid.class);
                    this.outputMsg((ICommandSender)player, "GridEnergy: " + eg.getStoredPower() + " : " + eg.getEnergyDemand(Double.MAX_VALUE));
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private void outputMsg(ICommandSender player, String string) {
        player.func_145747_a((ITextComponent)new TextComponentString(string));
    }

    private String timeMeasurement(long nanos) {
        long ms = nanos / 100000L;
        if (nanos <= 100000L) {
            return nanos + "ns";
        }
        return (float)ms / 10.0f + "ms";
    }
}

