/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.sgextraparts.lib;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.IPartPosition;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.tool.part.IPartProperties;
import net.silentchaos512.gems.api.tool.part.ToolPartMain;
import net.silentchaos512.gems.item.tool.ItemGemBow;

public class ToolPartSGEP
extends ToolPartMain {
    IPartProperties properties;
    Map<String, ModelResourceLocation> modelMap = Maps.newHashMap();

    public ToolPartSGEP(IPartProperties prop) {
        super("sgextraparts:" + prop.getName().toLowerCase(), prop.getCraftingStack());
        this.craftingOreDictName = prop.getCraftingOreName();
        this.tier = prop.getTier();
        this.properties = prop;
    }

    public int getColor(ItemStack toolOrArmor, IPartPosition position, int animationFrame) {
        return this.properties.getColor();
    }

    public String getDisplayName(ItemStack stack) {
        if (stack.func_82837_s()) {
            return stack.func_82833_r();
        }
        return this.properties.getName();
    }

    public String getDisplayNamePrefix(ItemStack partRep) {
        return this.properties.getNamePrefix();
    }

    public ModelResourceLocation getModel(ItemStack tool, ToolPartPosition pos, int frame) {
        Item item = tool.func_77973_b();
        String name = item.getRegistryName().func_110623_a();
        name = "silentgems:" + name.toLowerCase() + "/" + name;
        boolean isBow = item instanceof ItemGemBow;
        String num = isBow ? "" : "15";
        String frameNum = isBow && frame == 3 ? "_3" : "";
        switch (pos) {
            case HEAD: {
                name = name + num + frameNum;
                break;
            }
            case ROD_DECO: {
                name = name + "_deco";
                break;
            }
            default: {
                return null;
            }
        }
        if (this.modelMap.containsKey(name)) {
            return this.modelMap.get(name);
        }
        ModelResourceLocation model = new ModelResourceLocation(name.toLowerCase(), "inventory");
        this.modelMap.put(name, model);
        return model;
    }

    public int getDurability() {
        return this.properties.getDurability();
    }

    public float getHarvestSpeed() {
        return this.properties.getMiningSpeed();
    }

    public int getHarvestLevel() {
        return this.properties.getHarvestLevel();
    }

    public float getMeleeDamage() {
        return this.properties.getMeleeDamage();
    }

    public float getMagicDamage() {
        return this.properties.getMagicDamage();
    }

    public int getEnchantability() {
        return this.properties.getEnchantability();
    }

    public float getMeleeSpeed() {
        return this.properties.getMeleeSpeed();
    }

    public float getChargeSpeed() {
        return this.properties.getChargeSpeed();
    }

    public float getProtection() {
        return this.properties.getProtection();
    }

    public EnumMaterialTier getTier() {
        return this.tier;
    }
}

