/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.recipe;

import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.api.item.ItemEngraving;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class EngraverRecipes {
    private static final EngraverRecipes engravingBase = new EngraverRecipes();
    private final List<ItemStack> coins = new ArrayList<ItemStack>();
    private final Map<ItemEngraving, ItemStack> engravings = new HashMap<ItemEngraving, ItemStack>();
    private final Map<ItemStack, ItemStack> engravingList = new HashMap<ItemStack, ItemStack>();
    private final Map<ItemStack, Float> experienceList = new HashMap<ItemStack, Float>();

    public static EngraverRecipes instance() {
        return engravingBase;
    }

    private EngraverRecipes() {
    }

    public void addCoin(Item coin) {
        this.addCoin(new ItemStack(coin, 1, Short.MAX_VALUE));
    }

    public void addCoin(ItemStack coin) {
        this.coins.add(coin);
    }

    public void addEngraving(Item coin, ItemEngraving engraving, float xp) {
        this.addEngraving(new ItemStack(coin), engraving, xp);
    }

    public void addEngraving(ItemStack coin, ItemEngraving engraving, float xp) {
        this.engravings.put(engraving, coin);
        this.engravingList.put(new ItemStack((Item)engraving), coin);
        this.experienceList.put(coin, Float.valueOf(xp));
    }

    public ItemStack getEngravingResult(ItemStack stack) {
        return this.coins.stream().filter(i -> this.areStacksEqual(stack, (ItemStack)i)).findFirst().orElse(ItemStack.field_190927_a);
    }

    public ItemStack getEngravingResult(ItemStack par2, ItemEngraving par1) {
        for (ItemStack stack : this.coins) {
            if (!this.areStacksEqual(par2, stack) || this.engravings.get(par1) == null || (par2.func_77973_b() == ACItems.coin || par1 != ACItems.blank_engraving) && (par2.func_77973_b() != ACItems.coin || par1 == ACItems.blank_engraving)) continue;
            return this.engravings.get(par1);
        }
        return ItemStack.field_190927_a;
    }

    private boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return !(stack2.func_77973_b() != stack1.func_77973_b() && stack1.func_77973_b() != ACItems.coin || stack2.func_77952_i() != Short.MAX_VALUE && stack2.func_77952_i() != stack1.func_77952_i());
    }

    public List<ItemStack> getCoinList() {
        return this.coins;
    }

    public Map<ItemEngraving, ItemStack> getEngravings() {
        return this.engravings;
    }

    public Map<ItemStack, ItemStack> getEngravingList() {
        return this.engravingList;
    }

    public float getExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        return this.experienceList.entrySet().stream().filter(e -> this.areStacksEqual(stack, (ItemStack)e.getKey())).map(e -> Float.valueOf(((Float)e.getValue()).floatValue())).findFirst().orElse(Float.valueOf(0.0f)).floatValue();
    }
}

