/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks;

import com.shinoow.abyssalcraft.common.blocks.tile.TileEntityTieredEnergyPedestal;
import com.shinoow.abyssalcraft.lib.ACTabs;
import com.shinoow.abyssalcraft.lib.util.blocks.BlockUtil;
import com.shinoow.abyssalcraft.lib.util.blocks.SingletonInventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTieredEnergyPedestal
extends BlockContainer {
    public static final PropertyEnum<EnumDimType> DIMENSION = PropertyEnum.func_177709_a((String)"dimension", EnumDimType.class);

    public BlockTieredEnergyPedestal() {
        super(Material.field_151576_e);
        this.func_149663_c("tieredenergypedestal");
        this.func_149711_c(6.0f);
        this.func_149752_b(12.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(ACTabs.tabDecoration);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DIMENSION, (Comparable)((Object)EnumDimType.OVERWORLD)));
        this.setHarvestLevel("pickaxe", 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    }

    public void func_149666_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        par3List.add((Object)new ItemStack((Block)this, 1, 0));
        par3List.add((Object)new ItemStack((Block)this, 1, 1));
        par3List.add((Object)new ItemStack((Block)this, 1, 2));
        par3List.add((Object)new ItemStack((Block)this, 1, 3));
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityTieredEnergyPedestal();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumDimType)((Object)state.func_177229_b(DIMENSION))).getMeta();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return SingletonInventoryUtil.handleBlockActivation(world, pos, player, player.func_184586_b(hand));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        BlockUtil.dropTileEntityAsItemWithExtra(world, pos, state, (Block)this);
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("PotEnergy") && (tile = worldIn.func_175625_s(pos)) != null && tile instanceof TileEntityTieredEnergyPedestal) {
            NBTTagCompound data = new NBTTagCompound();
            tile.func_189515_b(data);
            data.func_74776_a("PotEnergy", stack.func_77978_p().func_74760_g("PotEnergy"));
            tile.func_145839_a(data);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DIMENSION, (Comparable)((Object)EnumDimType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDimType)((Object)state.func_177229_b(DIMENSION))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{DIMENSION}).build();
    }

    public static enum EnumDimType implements IStringSerializable
    {
        OVERWORLD(0, "overworld"),
        ABYSSAL_WASTELAND(1, "abyssal_wasteland"),
        DREADLANDS(2, "dreadlands"),
        OMOTHOL(3, "omothol");

        private static final EnumDimType[] META_LOOKUP;
        private int meta;
        private String name;

        private EnumDimType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumDimType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public String toString() {
            return this.func_176610_l();
        }

        static {
            META_LOOKUP = new EnumDimType[EnumDimType.values().length];
            EnumDimType[] enumDimTypeArray = EnumDimType.values();
            int n = enumDimTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumDimType type;
                EnumDimType.META_LOOKUP[type.getMeta()] = type = enumDimTypeArray[i];
            }
        }
    }
}

