/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks.tile;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.energy.IEnergyContainer;
import com.shinoow.abyssalcraft.api.energy.IEnergyContainerItem;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.api.entity.IOmotholEntity;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.lib.ACLib;
import com.shinoow.abyssalcraft.lib.util.blocks.ISingletonInventory;
import com.shinoow.abyssalcraft.lib.util.items.IStaffOfRending;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityRendingPedestal
extends TileEntity
implements IEnergyContainer,
ITickable,
ISidedInventory,
ISingletonInventory {
    private float energy;
    private NonNullList<ItemStack> containerItemStacks = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    int ticksExisted;
    int shadowEnergy;
    int abyssalEnergy;
    int dreadEnergy;
    int omotholEnergy;
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74760_g("PotEnergy");
        this.containerItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbttagcompound, this.containerItemStacks);
        this.shadowEnergy = nbttagcompound.func_74762_e("energyShadow");
        this.abyssalEnergy = nbttagcompound.func_74762_e("energyAbyssal");
        this.dreadEnergy = nbttagcompound.func_74762_e("energyDread");
        this.omotholEnergy = nbttagcompound.func_74762_e("energyOmothol");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74776_a("PotEnergy", this.energy);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbttagcompound, this.containerItemStacks);
        nbttagcompound.func_74768_a("energyShadow", this.shadowEnergy);
        nbttagcompound.func_74768_a("energyAbyssal", this.abyssalEnergy);
        nbttagcompound.func_74768_a("energyDread", this.dreadEnergy);
        nbttagcompound.func_74768_a("energyOmothol", this.omotholEnergy);
        return nbttagcompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_73660_a() {
        ItemStack output;
        ItemStack stack;
        ++this.ticksExisted;
        ItemStack input = this.func_70301_a(0);
        if (!input.func_190926_b() && input.func_77973_b() instanceof IEnergyContainerItem && !this.field_145850_b.field_72995_K && ((IEnergyContainerItem)input.func_77973_b()).canTransferPE(input) && this.canAcceptPE()) {
            this.addEnergy(((IEnergyContainerItem)input.func_77973_b()).consumeEnergy(input, 1.0f));
        }
        if (!(stack = this.func_70301_a(1)).func_190926_b() && stack.func_77973_b() instanceof IStaffOfRending && this.ticksExisted % 40 == 0 && !this.field_145850_b.field_72995_K) {
            IStaffOfRending staff = (IStaffOfRending)stack.func_77973_b();
            if (staff.getEnergy(stack, "Shadow") > 0) {
                this.increaseEnergy(0, staff.getEnergy(stack, "Shadow"));
                staff.setEnergy(0, stack, "Shadow");
            }
            if (staff.getEnergy(stack, "Abyssal") > 0) {
                this.increaseEnergy(1, staff.getEnergy(stack, "Abyssal"));
                staff.setEnergy(0, stack, "Abyssal");
            }
            if (staff.getEnergy(stack, "Dread") > 0) {
                this.increaseEnergy(2, staff.getEnergy(stack, "Dread"));
                staff.setEnergy(0, stack, "Dread");
            }
            if (staff.getEnergy(stack, "Omothol") > 0) {
                this.increaseEnergy(3, staff.getEnergy(stack, "Omothol"));
                staff.setEnergy(0, stack, "Omothol");
            }
            for (EntityLivingBase target : this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(15.0, 3.0, 15.0))) {
                if (target.func_70668_bt() == AbyssalCraftAPI.SHADOW && target.func_184222_aU()) {
                    if (target.field_70128_L || !(this.getContainedEnergy() >= target.func_110138_aP() / 2.0f) || !target.func_70097_a(DamageSource.field_76376_m, (float)staff.getDrainAmount(stack))) continue;
                    this.consumeEnergy(target.func_110138_aP() / 2.0f);
                    this.increaseEnergy(0, staff.getDrainAmount(stack));
                    continue;
                }
                if (this.field_145850_b.field_73011_w.getDimension() == ACLib.abyssal_wasteland_id && EntityUtil.isCoraliumPlagueCarrier(target) && target.func_184222_aU()) {
                    if (target.field_70128_L || !(this.getContainedEnergy() >= target.func_110138_aP() / 2.0f) || !target.func_70097_a(DamageSource.field_76376_m, (float)staff.getDrainAmount(stack))) continue;
                    this.consumeEnergy(target.func_110138_aP() / 2.0f);
                    this.increaseEnergy(1, staff.getDrainAmount(stack));
                    continue;
                }
                if (this.field_145850_b.field_73011_w.getDimension() == ACLib.dreadlands_id && EntityUtil.isDreadPlagueCarrier(target) && target.func_184222_aU()) {
                    if (target.field_70128_L || !(this.getContainedEnergy() >= target.func_110138_aP() / 2.0f) || !target.func_70097_a(DamageSource.field_76376_m, (float)staff.getDrainAmount(stack))) continue;
                    this.consumeEnergy(target.func_110138_aP() / 2.0f);
                    this.increaseEnergy(2, staff.getDrainAmount(stack));
                    continue;
                }
                if (this.field_145850_b.field_73011_w.getDimension() != ACLib.omothol_id || !(target instanceof IOmotholEntity) || target.func_70668_bt() == AbyssalCraftAPI.SHADOW || !target.func_184222_aU() || target.field_70128_L || !(this.getContainedEnergy() >= target.func_110138_aP() / 2.0f) || !target.func_70097_a(DamageSource.field_76376_m, (float)staff.getDrainAmount(stack))) continue;
                this.consumeEnergy(target.func_110138_aP() / 2.0f);
                this.increaseEnergy(3, staff.getDrainAmount(stack));
            }
            for (EntityLivingBase target : this.field_145850_b.func_72872_a(MultiPartEntityPart.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(15.0, 3.0, 15.0))) {
                if (!(target.field_70259_a instanceof EntityLiving)) continue;
                if (((EntityLiving)target.field_70259_a).func_70668_bt() == AbyssalCraftAPI.SHADOW && target.func_184222_aU()) {
                    if (target.field_70128_L || !(this.getContainedEnergy() >= ((EntityLiving)target.field_70259_a).func_110138_aP() / 2.0f) || !target.func_70097_a(DamageSource.field_76376_m, (float)staff.getDrainAmount(stack))) continue;
                    this.consumeEnergy(((EntityLiving)target.field_70259_a).func_110138_aP() / 2.0f);
                    this.increaseEnergy(0, staff.getDrainAmount(stack));
                    continue;
                }
                if (this.field_145850_b.field_73011_w.getDimension() == ACLib.abyssal_wasteland_id && EntityUtil.isCoraliumPlagueCarrier((EntityLivingBase)((EntityLiving)target.field_70259_a)) && target.func_184222_aU()) {
                    if (target.field_70128_L || !(this.getContainedEnergy() >= ((EntityLiving)target.field_70259_a).func_110138_aP() / 2.0f) || !target.func_70097_a(DamageSource.field_76376_m, (float)staff.getDrainAmount(stack))) continue;
                    this.consumeEnergy(((EntityLiving)target.field_70259_a).func_110138_aP() / 2.0f);
                    this.increaseEnergy(1, staff.getDrainAmount(stack));
                    continue;
                }
                if (this.field_145850_b.field_73011_w.getDimension() == ACLib.dreadlands_id && EntityUtil.isDreadPlagueCarrier((EntityLivingBase)((EntityLiving)target.field_70259_a)) && target.func_184222_aU()) {
                    if (target.field_70128_L || !(this.getContainedEnergy() >= ((EntityLiving)target.field_70259_a).func_110138_aP() / 2.0f) || !target.func_70097_a(DamageSource.field_76376_m, (float)staff.getDrainAmount(stack))) continue;
                    this.consumeEnergy(((EntityLiving)target.field_70259_a).func_110138_aP() / 2.0f);
                    this.increaseEnergy(2, staff.getDrainAmount(stack));
                    continue;
                }
                if (this.field_145850_b.field_73011_w.getDimension() != ACLib.omothol_id || !(target.field_70259_a instanceof IOmotholEntity) || ((EntityLiving)target.field_70259_a).func_70668_bt() == AbyssalCraftAPI.SHADOW || !target.func_184222_aU() || target.field_70128_L || !(this.getContainedEnergy() >= ((EntityLiving)target.field_70259_a).func_110138_aP() / 2.0f) || !target.func_70097_a(DamageSource.field_76376_m, (float)staff.getDrainAmount(stack))) continue;
                this.consumeEnergy(((EntityLiving)target.field_70259_a).func_110138_aP() / 2.0f);
                this.increaseEnergy(3, staff.getDrainAmount(stack));
            }
        }
        if (this.getEnergy(0) >= 200) {
            this.setEnergy(0, 0);
            output = this.func_70301_a(2);
            if (!output.func_190926_b() && output.func_77973_b() == ACItems.shadow_gem) {
                output.func_190917_f(1);
            } else {
                this.func_70299_a(2, new ItemStack(ACItems.shadow_gem));
            }
        }
        if (this.getEnergy(1) >= 100) {
            this.setEnergy(1, 0);
            output = this.func_70301_a(3);
            if (!output.func_190926_b() && output.func_77973_b() == ACItems.essence && output.func_77952_i() == 0) {
                output.func_190917_f(1);
            } else {
                this.func_70299_a(3, new ItemStack(ACItems.essence, 1, 0));
            }
        }
        if (this.getEnergy(2) >= 100) {
            this.setEnergy(2, 0);
            output = this.func_70301_a(4);
            if (!output.func_190926_b() && output.func_77973_b() == ACItems.essence && output.func_77952_i() == 1) {
                output.func_190917_f(1);
            } else {
                this.func_70299_a(4, new ItemStack(ACItems.essence, 1, 1));
            }
        }
        if (this.getEnergy(3) >= 100) {
            this.setEnergy(3, 0);
            output = this.func_70301_a(5);
            if (!output.func_190926_b() && output.func_77973_b() == ACItems.essence && output.func_77952_i() == 2) {
                output.func_190917_f(1);
            } else {
                this.func_70299_a(5, new ItemStack(ACItems.essence, 1, 2));
            }
        }
    }

    @Override
    public float getContainedEnergy() {
        return this.energy;
    }

    @Override
    public int getMaxEnergy() {
        return 5000;
    }

    @Override
    public void addEnergy(float energy) {
        this.energy += energy;
        if (this.energy > (float)this.getMaxEnergy()) {
            this.energy = this.getMaxEnergy();
        }
    }

    @Override
    public float consumeEnergy(float energy) {
        if (energy < this.energy) {
            this.energy -= energy;
            return energy;
        }
        float ret = this.energy;
        this.energy = 0.0f;
        return ret;
    }

    @Override
    public boolean canAcceptPE() {
        return this.getContainedEnergy() < (float)this.getMaxEnergy();
    }

    @Override
    public boolean canTransferPE() {
        return false;
    }

    @Override
    public TileEntity getContainerTile() {
        return this;
    }

    public int getEnergy(int type) {
        switch (type) {
            case 0: {
                return this.shadowEnergy;
            }
            case 1: {
                return this.abyssalEnergy;
            }
            case 2: {
                return this.dreadEnergy;
            }
            case 3: {
                return this.omotholEnergy;
            }
        }
        return 0;
    }

    public void increaseEnergy(int type, int amount) {
        switch (type) {
            case 0: {
                this.shadowEnergy += amount;
                break;
            }
            case 1: {
                this.abyssalEnergy += amount;
                break;
            }
            case 2: {
                this.dreadEnergy += amount;
                break;
            }
            case 3: {
                this.omotholEnergy += amount;
            }
        }
    }

    public void setEnergy(int type, int amount) {
        switch (type) {
            case 0: {
                this.shadowEnergy = amount;
                break;
            }
            case 1: {
                this.abyssalEnergy = amount;
                break;
            }
            case 2: {
                this.dreadEnergy = amount;
                break;
            }
            case 3: {
                this.omotholEnergy = amount;
            }
        }
    }

    public String func_70005_c_() {
        return "container.abyssalcraft.rendingpedestal";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.containerItemStacks.size();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.containerItemStacks.get(index);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return ItemStackHelper.func_188382_a(this.containerItemStacks, (int)var1, (int)var2);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.containerItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.containerItemStacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 1) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 0: {
                return stack.func_77973_b() instanceof IEnergyContainerItem;
            }
            case 1: {
                return stack.func_77973_b() instanceof IStaffOfRending;
            }
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[4];
            nArray2[0] = 2;
            nArray2[1] = 3;
            nArray2[2] = 4;
            nArray = nArray2;
            nArray2[3] = 5;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction == EnumFacing.DOWN && index > 1;
    }

    public int func_174887_a_(int id) {
        if (id < 4) {
            return this.getEnergy(id);
        }
        if (id == 4) {
            return (int)this.energy;
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (id < 4) {
            this.setEnergy(id, value);
        }
        if (id == 4) {
            this.energy = value;
        }
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN) {
            return (T)this.handlerBottom;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN || super.hasCapability(capability, facing);
    }

    @Override
    public ItemStack getItem() {
        return this.func_70301_a(1);
    }

    @Override
    public void setItem(ItemStack item) {
        this.func_70299_a(1, item);
    }

    @Override
    public boolean shouldItemRotate() {
        return false;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.containerItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

