/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.inventory;

import com.shinoow.abyssalcraft.api.APIUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;

public class InventoryConfigurator
implements IInventory {
    private String name;
    private NonNullList<ItemStack> inventory;
    private final ItemStack invItem;
    private final EnumHand hand;

    public InventoryConfigurator(ItemStack stack, EnumHand hand) {
        this.invItem = stack;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        this.name = stack.func_82833_r();
        this.hand = hand;
        this.readFromNBT(stack.func_77978_p());
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)slot, (int)amount);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int slot) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)slot);
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory.set(slot, (Object)itemstack);
        if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return this.name.length() > 0;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
        }
        this.writeToNBT(this.invItem.func_77978_p());
    }

    public boolean func_70300_a(EntityPlayer player) {
        return APIUtils.areStacksEqual(player.func_184586_b(this.hand), this.invItem);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    public void readFromNBT(NBTTagCompound tagcompound) {
        this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)tagcompound, this.inventory);
    }

    public void writeToNBT(NBTTagCompound tagcompound) {
        ItemStackHelper.func_191282_a((NBTTagCompound)tagcompound, this.inventory);
    }

    public int func_174887_a_(int id) {
        if (id == 0) {
            return this.invItem.func_77978_p().func_74767_n("FilterSubtype") ? 1 : 0;
        }
        if (id == 1) {
            return this.invItem.func_77978_p().func_74767_n("FilterNBT") ? 1 : 0;
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (id == 0) {
            this.invItem.func_77978_p().func_74757_a("FilterSubtype", value == 1);
        } else if (id == 1) {
            this.invItem.func_77978_p().func_74757_a("FilterNBT", value == 1);
        }
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

