/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.utils.FMLRemapper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MCRegistryRemapping
implements MCRegistry {
    protected MCRegistry parent;
    protected FMLRemapper remapper;

    public MCRegistryRemapping(MCRegistry parent, FMLRemapper remapper) {
        this.parent = parent;
        this.remapper = remapper;
    }

    @Override
    public Item itemFromID(ResourceLocation itemID) {
        return this.parent.itemFromID(this.remapper.mapItem(itemID));
    }

    @Override
    public ResourceLocation idFromItem(Item item) {
        return this.parent.idFromItem(item);
    }

    @Override
    public void modifyItemStackCompound(NBTTagCompound compound, ResourceLocation itemID) {
        ResourceLocation mapped = this.remapper.remapItem(itemID);
        if (mapped != null) {
            itemID = mapped;
            compound.func_74778_a("id", mapped.toString());
        }
        this.parent.modifyItemStackCompound(compound, itemID);
    }

    @Override
    public Block blockFromID(ResourceLocation blockID) {
        return this.parent.blockFromID(this.remapper.mapBlock(blockID));
    }

    @Override
    public ResourceLocation idFromBlock(Block block) {
        return this.parent.idFromBlock(block);
    }

    @Override
    public TileEntity loadTileEntity(World world, NBTTagCompound compound) {
        ResourceLocation remap = this.remapper.remapTileEntity(new ResourceLocation(compound.func_74779_i("id")));
        if (remap != null) {
            NBTTagCompound copy = compound.func_74737_b();
            copy.func_74778_a("id", remap.toString());
            return this.parent.loadTileEntity(world, copy);
        }
        return this.parent.loadTileEntity(world, compound);
    }
}

