/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.selector;

import ivorius.reccomplex.world.gen.feature.selector.StructureSelector;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CachedStructureSelectors<S extends StructureSelector> {
    private Map<Pair<Integer, ResourceLocation>, S> structureSelectors = new HashMap<Pair<Integer, ResourceLocation>, S>();
    private BiFunction<Biome, WorldProvider, S> selectorSupplier;

    public CachedStructureSelectors(BiFunction<Biome, WorldProvider, S> selectorSupplier) {
        this.selectorSupplier = selectorSupplier;
    }

    public S get(Biome biome, WorldProvider provider) {
        ImmutablePair pair = new ImmutablePair((Object)provider.getDimension(), Biome.field_185377_q.func_177774_c((Object)biome));
        StructureSelector structureSelector = (StructureSelector)this.structureSelectors.get(pair);
        if (structureSelector == null || !structureSelector.isValid(biome, provider)) {
            structureSelector = (StructureSelector)this.selectorSupplier.apply(biome, provider);
            this.structureSelectors.put((Pair<Integer, ResourceLocation>)pair, structureSelector);
        }
        return (S)structureSelector;
    }

    public void clear() {
        this.structureSelectors.clear();
    }
}

