/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch;

import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randompatches.config.RPConfig;
import com.therandomlabs.randompatches.core.Patch;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.TRLUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class NetHandlerPlayServerPatch
extends Patch {
    public static final String TIMEOUTS_CONFIG = NetHandlerPlayServerPatch.getName(RPConfig.Timeouts.class);
    public static final String SPEED_LIMITS_CONFIG = NetHandlerPlayServerPatch.getName(RPConfig.SpeedLimits.class);
    public static final String SEND_PACKET = NetHandlerPlayServerPatch.getName("sendPacket", "func_147359_a");

    @Override
    public boolean apply(ClassNode node) {
        NetHandlerPlayServerPatch.patchUpdate(NetHandlerPlayServerPatch.findInstructions(node, "update", "func_73660_a"));
        if (!RandomPatches.SPONGEFORGE_INSTALLED && !RandomPatches.ICE_AND_FIRE_INSTALLED) {
            NetHandlerPlayServerPatch.patchProcessPlayer(NetHandlerPlayServerPatch.findInstructions(node, "processPlayer", "func_147347_a"));
            NetHandlerPlayServerPatch.patchProcessVehicleMove(NetHandlerPlayServerPatch.findInstructions(node, "processVehicleMove", "func_184338_a"));
        }
        return true;
    }

    private static void patchUpdate(InsnList instructions) {
        LdcInsnNode keepAliveInterval = null;
        JumpInsnNode jumpIfKeepAlivePending = null;
        MethodInsnNode sendPacket = null;
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (keepAliveInterval == null) {
                if (instruction.getOpcode() != 18) continue;
                keepAliveInterval = (LdcInsnNode)instruction;
                if (TRLUtils.MC_VERSION_NUMBER > 11) {
                    if (Long.valueOf(15000L).equals(keepAliveInterval.cst) || Long.valueOf(25000L).equals(keepAliveInterval.cst)) continue;
                    keepAliveInterval = null;
                    continue;
                }
                if (Long.valueOf(40L).equals(keepAliveInterval.cst)) continue;
                keepAliveInterval = null;
                continue;
            }
            if (TRLUtils.MC_VERSION_NUMBER < 12) break;
            if (jumpIfKeepAlivePending == null) {
                if (instruction.getOpcode() != 153 || instruction.getPrevious().getOpcode() != 180) continue;
                jumpIfKeepAlivePending = (JumpInsnNode)instruction;
                continue;
            }
            if (instruction.getOpcode() != 182) continue;
            sendPacket = (MethodInsnNode)instruction;
            if (SEND_PACKET.equals(sendPacket.name)) break;
            sendPacket = null;
        }
        instructions.insert((AbstractInsnNode)keepAliveInterval, (AbstractInsnNode)new FieldInsnNode(178, TIMEOUTS_CONFIG, TRLUtils.MC_VERSION_NUMBER > 11 ? "keepAlivePacketIntervalMillis" : "keepAlivePacketIntervalLong", "J"));
        instructions.remove((AbstractInsnNode)keepAliveInterval);
        if (TRLUtils.MC_VERSION_NUMBER < 12) {
            return;
        }
        LabelNode label = new LabelNode();
        InsnList newInstructions = new InsnList();
        newInstructions.add((AbstractInsnNode)new VarInsnNode(22, 1));
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/network/NetHandlerPlayServer", "field_194402_f", "J"));
        newInstructions.add((AbstractInsnNode)new InsnNode(101));
        newInstructions.add((AbstractInsnNode)new FieldInsnNode(178, TIMEOUTS_CONFIG, "readTimeoutMillis", "J"));
        newInstructions.add((AbstractInsnNode)new InsnNode(148));
        newInstructions.add((AbstractInsnNode)new JumpInsnNode(155, label));
        instructions.insert((AbstractInsnNode)jumpIfKeepAlivePending, newInstructions);
        instructions.insert((AbstractInsnNode)sendPacket, (AbstractInsnNode)label);
    }

    private static void patchProcessPlayer(InsnList instructions) {
        LdcInsnNode elytra = null;
        LdcInsnNode normal = null;
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 18) continue;
            LdcInsnNode ldc = (LdcInsnNode)instruction;
            if (elytra == null) {
                if (!Float.valueOf(300.0f).equals(ldc.cst)) continue;
                elytra = ldc;
                continue;
            }
            if (!Float.valueOf(100.0f).equals(ldc.cst)) continue;
            normal = ldc;
            break;
        }
        instructions.insert(elytra, (AbstractInsnNode)new FieldInsnNode(178, SPEED_LIMITS_CONFIG, "maxPlayerElytraSpeed", "F"));
        instructions.remove(elytra);
        instructions.insert((AbstractInsnNode)normal, (AbstractInsnNode)new FieldInsnNode(178, SPEED_LIMITS_CONFIG, "maxPlayerSpeed", "F"));
        instructions.remove((AbstractInsnNode)normal);
    }

    private static void patchProcessVehicleMove(InsnList instructions) {
        LdcInsnNode speed = null;
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 18) continue;
            LdcInsnNode ldc = (LdcInsnNode)instruction;
            if (!Double.valueOf(100.0).equals(ldc.cst)) continue;
            speed = ldc;
            break;
        }
        instructions.insert(speed, (AbstractInsnNode)new FieldInsnNode(178, SPEED_LIMITS_CONFIG, "maxPlayerVehicleSpeed", "D"));
        instructions.remove(speed);
    }
}

