/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.api;

import flaxbeard.cyberware.Cyberware;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.ISpecialBattery;
import flaxbeard.cyberware.api.item.HotkeyHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IHudjack;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.misc.NNLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CyberwareUserDataImpl
implements ICyberwareUserData {
    public static final Capability.IStorage<ICyberwareUserData> STORAGE = new CyberwareUserDataStorage();
    private NonNullList<NonNullList<ItemStack>> cyberwaresBySlot = NonNullList.func_191196_a();
    private boolean[] missingEssentials = new boolean[ICyberware.EnumSlot.values().length * 2];
    private int power_stored = 0;
    private int power_production = 0;
    private int power_lastProduction = 0;
    private int power_consumption = 0;
    private int power_lastConsumption = 0;
    private int power_capacity = 0;
    private Map<ItemStack, Integer> power_buffer = new HashMap<ItemStack, Integer>();
    private Map<ItemStack, Integer> power_lastBuffer = new HashMap<ItemStack, Integer>();
    private NonNullList<ItemStack> nnlPowerOutages = NonNullList.func_191196_a();
    private List<Integer> ticksPowerOutages = new ArrayList<Integer>();
    private int missingEssence = 0;
    private NonNullList<ItemStack> specialBatteries = NonNullList.func_191196_a();
    private NonNullList<ItemStack> activeItems = NonNullList.func_191196_a();
    private NonNullList<ItemStack> hudjackItems = NonNullList.func_191196_a();
    private Map<Integer, ItemStack> hotkeys = new HashMap<Integer, ItemStack>();
    private NBTTagCompound hudData;
    private boolean hasOpenedRadialMenu = false;
    private int hudColor = 65535;
    private float[] hudColorFloat = new float[]{0.0f, 1.0f, 1.0f};
    private boolean canGiveOut = true;
    private boolean isImmune = false;

    public CyberwareUserDataImpl() {
        this.hudData = new NBTTagCompound();
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            NonNullList nnlCyberwaresInSlot = NonNullList.func_191196_a();
            for (int indexSlot = 0; indexSlot < 10; ++indexSlot) {
                nnlCyberwaresInSlot.add((Object)ItemStack.field_190927_a);
            }
            this.cyberwaresBySlot.add((Object)nnlCyberwaresInSlot);
        }
        this.resetWare(null);
    }

    @Override
    public void resetWare(EntityLivingBase entityLivingBase) {
        for (NonNullList nnlCyberwaresInSlot : this.cyberwaresBySlot) {
            for (ItemStack item : nnlCyberwaresInSlot) {
                if (!CyberwareAPI.isCyberware(item)) continue;
                CyberwareAPI.getCyberware(item).onRemoved(entityLivingBase, item);
            }
        }
        this.missingEssence = 0;
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            NonNullList nnlCyberwaresInSlot = NonNullList.func_191196_a();
            NonNullList<ItemStack> startItems = CyberwareConfig.getStartingItems(slot);
            for (ItemStack startItem : startItems) {
                nnlCyberwaresInSlot.add((Object)startItem.func_77946_l());
            }
            this.cyberwaresBySlot.set(slot.ordinal(), (Object)nnlCyberwaresInSlot);
        }
        this.missingEssentials = new boolean[ICyberware.EnumSlot.values().length * 2];
        this.updateCapacity();
    }

    @Override
    public List<ItemStack> getPowerOutages() {
        return this.nnlPowerOutages;
    }

    @Override
    public List<Integer> getPowerOutageTimes() {
        return this.ticksPowerOutages;
    }

    @Override
    public int getCapacity() {
        int specialCap = 0;
        for (ItemStack item : this.specialBatteries) {
            ISpecialBattery battery = (ISpecialBattery)((Object)CyberwareAPI.getCyberware(item));
            specialCap += battery.getCapacity(item);
        }
        return this.power_capacity + specialCap;
    }

    @Override
    public int getStoredPower() {
        int specialStored = 0;
        for (ItemStack item : this.specialBatteries) {
            ISpecialBattery battery = (ISpecialBattery)((Object)CyberwareAPI.getCyberware(item));
            specialStored += battery.getStoredEnergy(item);
        }
        return this.power_stored + specialStored;
    }

    @Override
    public float getPercentFull() {
        if (this.getCapacity() == 0) {
            return -1.0f;
        }
        return (float)this.getStoredPower() / (float)this.getCapacity();
    }

    @Override
    public boolean isAtCapacity(ItemStack stack) {
        return this.isAtCapacity(stack, 0);
    }

    @Override
    public boolean isAtCapacity(ItemStack stack, int buffer) {
        int leftOverSpaceNormal = this.power_capacity - this.power_stored;
        if (leftOverSpaceNormal > buffer) {
            return false;
        }
        int leftOverSpaceSpecial = 0;
        for (ItemStack batteryStack : this.specialBatteries) {
            ISpecialBattery battery = (ISpecialBattery)((Object)CyberwareAPI.getCyberware(batteryStack));
            int spaceInThisSpecial = battery.add(batteryStack, stack, buffer + 1, true);
            if (leftOverSpaceNormal + (leftOverSpaceSpecial += spaceInThisSpecial) <= buffer) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addPower(int amount, ItemStack inputter) {
        Integer amountExisting;
        if (amount < 0) {
            throw new IllegalArgumentException("Amount must be positive!");
        }
        ItemStack stack = ItemStack.field_190927_a;
        if (!inputter.func_190926_b()) {
            stack = inputter.func_77942_o() || inputter.func_190916_E() != 1 ? new ItemStack(inputter.func_77973_b(), 1, inputter.func_77952_i()) : inputter;
        }
        this.power_buffer.put(stack, amount + ((amountExisting = this.power_buffer.get(stack)) == null ? 0 : amountExisting));
        this.power_production += amount;
    }

    @Override
    public boolean usePower(ItemStack stack, int amount) {
        return this.usePower(stack, amount, true);
    }

    private int ComputeSum(@Nonnull Map<ItemStack, Integer> map) {
        int total = 0;
        for (ItemStack key : map.keySet()) {
            total += map.get(key).intValue();
        }
        return total;
    }

    private void subtractFromBufferLast(int amount) {
        for (ItemStack key : this.power_lastBuffer.keySet()) {
            int get = this.power_lastBuffer.get(key);
            int amountToSubtract = Math.min(get, amount);
            this.power_lastBuffer.put(key, get - amountToSubtract);
            if ((amount -= amountToSubtract) > 0) continue;
            break;
        }
    }

    @Override
    public boolean usePower(ItemStack stack, int amount, boolean isPassive) {
        if (this.isImmune) {
            return true;
        }
        if (!this.canGiveOut) {
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                this.setOutOfPower(stack);
            }
            return false;
        }
        this.power_consumption += amount;
        int sumPowerBufferLast = this.ComputeSum(this.power_lastBuffer);
        int amountAvailable = this.power_stored + sumPowerBufferLast;
        int amountAvailableSpecial = 0;
        if (amountAvailable < amount) {
            int extract;
            ISpecialBattery battery;
            int amountMissing = amount - amountAvailable;
            for (ItemStack batteryStack : this.specialBatteries) {
                battery = (ISpecialBattery)((Object)CyberwareAPI.getCyberware(batteryStack));
                extract = battery.extract(batteryStack, amountMissing, true);
                amountAvailableSpecial += extract;
                if ((amountMissing -= extract) > 0) continue;
                break;
            }
            if (amountAvailableSpecial + amountAvailable >= amount) {
                ItemStack batteryStack;
                amountMissing = amount - amountAvailable;
                Iterator iterator = this.specialBatteries.iterator();
                while (iterator.hasNext() && (amountMissing -= (extract = (battery = (ISpecialBattery)((Object)CyberwareAPI.getCyberware(batteryStack = (ItemStack)iterator.next()))).extract(batteryStack, amountMissing, false))) > 0) {
                }
                amount -= amountAvailableSpecial;
            }
        }
        if (amountAvailable < amount) {
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                this.setOutOfPower(stack);
            }
            if (isPassive) {
                this.canGiveOut = false;
            }
            return false;
        }
        int leftAfterBuffer = Math.max(0, amount - sumPowerBufferLast);
        this.subtractFromBufferLast(amount);
        this.power_stored -= leftAfterBuffer;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void setOutOfPower(ItemStack stack) {
        EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        if (entityPlayer != null && !stack.func_190926_b()) {
            int indexFound = -1;
            int indexLoop = 0;
            for (ItemStack stackExisting : this.nnlPowerOutages) {
                if (!stackExisting.func_190926_b() && stackExisting.func_77973_b() == stack.func_77973_b() && stackExisting.func_77952_i() == stack.func_77952_i()) {
                    indexFound = indexLoop;
                    break;
                }
                ++indexLoop;
            }
            if (indexFound != -1) {
                this.nnlPowerOutages.remove(indexFound);
                this.ticksPowerOutages.remove(indexFound);
            }
            this.nnlPowerOutages.add((Object)stack);
            this.ticksPowerOutages.add(entityPlayer.field_70173_aa);
            if (this.nnlPowerOutages.size() >= 8) {
                this.nnlPowerOutages.remove(0);
                this.ticksPowerOutages.remove(0);
            }
        }
    }

    @Override
    public NonNullList<ItemStack> getInstalledCyberware(ICyberware.EnumSlot slot) {
        return (NonNullList)this.cyberwaresBySlot.get(slot.ordinal());
    }

    @Override
    public boolean hasEssential(ICyberware.EnumSlot slot) {
        return !this.missingEssentials[slot.ordinal() * 2];
    }

    @Override
    public boolean hasEssential(ICyberware.EnumSlot slot, ICyberware.ISidedLimb.EnumSide side) {
        return !this.missingEssentials[slot.ordinal() * 2 + (side == ICyberware.ISidedLimb.EnumSide.LEFT ? 0 : 1)];
    }

    @Override
    public void setHasEssential(ICyberware.EnumSlot slot, boolean hasLeft, boolean hasRight) {
        this.missingEssentials[slot.ordinal() * 2] = !hasLeft;
        this.missingEssentials[slot.ordinal() * 2 + 1] = !hasRight;
    }

    @Override
    public void setInstalledCyberware(EntityLivingBase entityLivingBase, ICyberware.EnumSlot slot, @Nonnull List<ItemStack> cyberwaresToInstall) {
        while (cyberwaresToInstall.size() > 10) {
            cyberwaresToInstall.remove(cyberwaresToInstall.size() - 1);
        }
        while (cyberwaresToInstall.size() < 10) {
            cyberwaresToInstall.add(ItemStack.field_190927_a);
        }
        this.setInstalledCyberware(entityLivingBase, slot, NNLUtil.fromArray(cyberwaresToInstall.toArray(new ItemStack[0])));
    }

    @Override
    public void updateCapacity() {
        this.power_capacity = 0;
        this.specialBatteries = NonNullList.func_191196_a();
        this.activeItems = NonNullList.func_191196_a();
        this.hudjackItems = NonNullList.func_191196_a();
        this.hotkeys = new HashMap<Integer, ItemStack>();
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            for (ItemStack itemStackCyberware : this.getInstalledCyberware(slot)) {
                if (!CyberwareAPI.isCyberware(itemStackCyberware)) continue;
                ICyberware cyberware = CyberwareAPI.getCyberware(itemStackCyberware);
                if (cyberware instanceof IMenuItem && ((IMenuItem)((Object)cyberware)).hasMenu(itemStackCyberware)) {
                    this.activeItems.add((Object)itemStackCyberware);
                    int hotkey = HotkeyHelper.getHotkey(itemStackCyberware);
                    if (hotkey != -1) {
                        this.hotkeys.put(hotkey, itemStackCyberware);
                    }
                }
                if (cyberware instanceof IHudjack) {
                    this.hudjackItems.add((Object)itemStackCyberware);
                }
                if (cyberware instanceof ISpecialBattery) {
                    this.specialBatteries.add((Object)itemStackCyberware);
                    continue;
                }
                this.power_capacity += cyberware.getCapacity(itemStackCyberware);
            }
        }
        this.power_stored = Math.min(this.power_stored, this.power_capacity);
    }

    @Override
    public void setInstalledCyberware(EntityLivingBase entityLivingBase, ICyberware.EnumSlot slot, NonNullList<ItemStack> cyberwaresToInstall) {
        if (cyberwaresToInstall.size() != ((NonNullList)this.cyberwaresBySlot.get(slot.ordinal())).size()) {
            Cyberware.logger.error(String.format("Invalid number of cyberware to install: found %d, expecting %d", cyberwaresToInstall.size(), ((NonNullList)this.cyberwaresBySlot.get(slot.ordinal())).size()));
        }
        NonNullList cyberwaresInstalled = (NonNullList)this.cyberwaresBySlot.get(slot.ordinal());
        if (entityLivingBase != null) {
            boolean found;
            for (ItemStack itemStackInstalled : cyberwaresInstalled) {
                if (!CyberwareAPI.isCyberware(itemStackInstalled)) continue;
                found = false;
                for (ItemStack itemStackToInstall : cyberwaresToInstall) {
                    if (!CyberwareAPI.areCyberwareStacksEqual(itemStackToInstall, itemStackInstalled) || itemStackToInstall.func_190916_E() != itemStackInstalled.func_190916_E()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                CyberwareAPI.getCyberware(itemStackInstalled).onRemoved(entityLivingBase, itemStackInstalled);
            }
            for (ItemStack itemStackToInstall : cyberwaresToInstall) {
                if (!CyberwareAPI.isCyberware(itemStackToInstall)) continue;
                found = false;
                for (ItemStack oldWare : cyberwaresInstalled) {
                    if (!CyberwareAPI.areCyberwareStacksEqual(itemStackToInstall, oldWare) || itemStackToInstall.func_190916_E() != oldWare.func_190916_E()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                CyberwareAPI.getCyberware(itemStackToInstall).onAdded(entityLivingBase, itemStackToInstall);
            }
        }
        this.cyberwaresBySlot.set(slot.ordinal(), cyberwaresToInstall);
    }

    @Override
    public boolean isCyberwareInstalled(ItemStack cyberware) {
        return this.getCyberwareRank(cyberware) > 0;
    }

    @Override
    public int getCyberwareRank(ItemStack cyberwareTemplate) {
        ItemStack cyberwareFound = this.getCyberware(cyberwareTemplate);
        if (!cyberwareFound.func_190926_b()) {
            return cyberwareFound.func_190916_E();
        }
        return 0;
    }

    @Override
    public ItemStack getCyberware(ItemStack cyberware) {
        for (ItemStack itemStack : this.getInstalledCyberware(CyberwareAPI.getCyberware(cyberware).getSlot(cyberware))) {
            if (itemStack.func_190926_b() || itemStack.func_77973_b() != cyberware.func_77973_b() || itemStack.func_77952_i() != cyberware.func_77952_i()) continue;
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagList listSlots = new NBTTagList();
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            NBTTagList listCyberwares = new NBTTagList();
            for (ItemStack cyberware : this.getInstalledCyberware(slot)) {
                NBTTagCompound tagCompoundCyberware = new NBTTagCompound();
                if (!cyberware.func_190926_b()) {
                    cyberware.func_77955_b(tagCompoundCyberware);
                }
                listCyberwares.func_74742_a((NBTBase)tagCompoundCyberware);
            }
            listSlots.func_74742_a((NBTBase)listCyberwares);
        }
        tagCompound.func_74782_a("cyberware", (NBTBase)listSlots);
        NBTTagList listEssentials = new NBTTagList();
        for (boolean missingEssential : this.missingEssentials) {
            listEssentials.func_74742_a((NBTBase)new NBTTagByte((byte)(missingEssential ? 1 : 0)));
        }
        tagCompound.func_74782_a("discard", (NBTBase)listEssentials);
        tagCompound.func_74782_a("powerBuffer", (NBTBase)this.serializeMap(this.power_buffer));
        tagCompound.func_74782_a("powerBufferLast", (NBTBase)this.serializeMap(this.power_lastBuffer));
        tagCompound.func_74768_a("powerCap", this.power_capacity);
        tagCompound.func_74768_a("storedPower", this.power_stored);
        tagCompound.func_74768_a("missingEssence", this.missingEssence);
        tagCompound.func_74782_a("hud", (NBTBase)this.hudData);
        tagCompound.func_74768_a("color", this.hudColor);
        tagCompound.func_74757_a("hasOpenedRadialMenu", this.hasOpenedRadialMenu);
        return tagCompound;
    }

    private NBTTagList serializeMap(@Nonnull Map<ItemStack, Integer> map) {
        NBTTagList listMap = new NBTTagList();
        for (ItemStack stack : map.keySet()) {
            NBTTagCompound tagCompoundEntry = new NBTTagCompound();
            tagCompoundEntry.func_74757_a("null", stack.func_190926_b());
            if (!stack.func_190926_b()) {
                NBTTagCompound tagCompoundItem = new NBTTagCompound();
                stack.func_77955_b(tagCompoundItem);
                tagCompoundEntry.func_74782_a("item", (NBTBase)tagCompoundItem);
            }
            tagCompoundEntry.func_74768_a("value", map.get(stack).intValue());
            listMap.func_74742_a((NBTBase)tagCompoundEntry);
        }
        return listMap;
    }

    private Map<ItemStack, Integer> deserializeMap(@Nonnull NBTTagList listMap) {
        HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
        for (int index = 0; index < listMap.func_74745_c(); ++index) {
            NBTTagCompound tagCompoundEntry = listMap.func_150305_b(index);
            boolean isNull = tagCompoundEntry.func_74767_n("null");
            ItemStack stack = ItemStack.field_190927_a;
            if (!isNull) {
                stack = new ItemStack(tagCompoundEntry.func_74775_l("item"));
            }
            map.put(stack, tagCompoundEntry.func_74762_e("value"));
        }
        return map;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tagCompound) {
        this.power_buffer = this.deserializeMap(tagCompound.func_150295_c("powerBuffer", 10));
        this.power_capacity = tagCompound.func_74762_e("powerCap");
        this.power_lastBuffer = this.deserializeMap((NBTTagList)tagCompound.func_74781_a("powerBufferLast"));
        this.power_stored = tagCompound.func_74762_e("storedPower");
        this.missingEssence = tagCompound.func_74764_b("essence") ? this.getMaxEssence() - tagCompound.func_74762_e("essence") : tagCompound.func_74762_e("missingEssence");
        this.hudData = tagCompound.func_74775_l("hud");
        this.hasOpenedRadialMenu = tagCompound.func_74767_n("hasOpenedRadialMenu");
        NBTTagList listEssentials = (NBTTagList)tagCompound.func_74781_a("discard");
        for (int indexEssential = 0; indexEssential < listEssentials.func_74745_c(); ++indexEssential) {
            this.missingEssentials[indexEssential] = ((NBTTagByte)listEssentials.func_179238_g(indexEssential)).func_150290_f() > 0;
        }
        NBTTagList listSlots = (NBTTagList)tagCompound.func_74781_a("cyberware");
        for (int indexBodySlot = 0; indexBodySlot < listSlots.func_74745_c(); ++indexBodySlot) {
            ICyberware.EnumSlot slot = ICyberware.EnumSlot.values()[indexBodySlot];
            NBTTagList listCyberwares = (NBTTagList)listSlots.func_179238_g(indexBodySlot);
            NonNullList nnlCyberwaresOfType = NonNullList.func_191196_a();
            for (int indexInventorySlot = 0; indexInventorySlot < 10; ++indexInventorySlot) {
                nnlCyberwaresOfType.add((Object)ItemStack.field_190927_a);
            }
            int countInventorySlots = Math.min(listCyberwares.func_74745_c(), nnlCyberwaresOfType.size());
            for (int indexInventorySlot = 0; indexInventorySlot < countInventorySlots; ++indexInventorySlot) {
                nnlCyberwaresOfType.set(indexInventorySlot, (Object)new ItemStack(listCyberwares.func_150305_b(indexInventorySlot)));
            }
            this.setInstalledCyberware(null, slot, (NonNullList<ItemStack>)nnlCyberwaresOfType);
        }
        int color = 65535;
        if (tagCompound.func_74764_b("color")) {
            color = tagCompound.func_74762_e("color");
        }
        this.setHudColor(color);
        this.updateCapacity();
    }

    private void storePower(Map<ItemStack, Integer> map) {
        for (ItemStack itemStackSpecialBattery : this.specialBatteries) {
            ISpecialBattery specialBattery = (ISpecialBattery)((Object)CyberwareAPI.getCyberware(itemStackSpecialBattery));
            for (Map.Entry<ItemStack, Integer> entryBuffer : map.entrySet()) {
                int amountBuffer = entryBuffer.getValue();
                int amountTaken = specialBattery.add(itemStackSpecialBattery, entryBuffer.getKey(), amountBuffer, false);
                entryBuffer.setValue(amountBuffer - amountTaken);
            }
        }
        this.power_stored = Math.min(this.power_capacity, this.power_stored + this.ComputeSum(map));
    }

    @Override
    public void resetBuffer() {
        this.canGiveOut = true;
        this.storePower(this.power_lastBuffer);
        this.power_lastBuffer = this.power_buffer;
        this.power_buffer = new HashMap<ItemStack, Integer>(this.power_buffer.size());
        this.isImmune = false;
        this.power_lastConsumption = this.power_consumption;
        this.power_lastProduction = this.power_production;
        this.power_production = 0;
        this.power_consumption = 0;
    }

    @Override
    public void setImmune() {
        this.isImmune = true;
    }

    @Override
    @Deprecated
    public int getEssence() {
        return this.getMaxEssence() - this.missingEssence;
    }

    @Override
    @Deprecated
    public int getMaxEssence() {
        return CyberwareConfig.ESSENCE;
    }

    @Override
    @Deprecated
    public void setEssence(int essence) {
        this.missingEssence = this.getMaxEssence() - essence;
    }

    @Override
    public int getMaxTolerance(@Nonnull EntityLivingBase entityLivingBase) {
        return (int)entityLivingBase.func_110140_aT().func_111151_a(CyberwareAPI.TOLERANCE_ATTR).func_111126_e();
    }

    @Override
    public int getTolerance(@Nonnull EntityLivingBase entityLivingBase) {
        return this.getMaxTolerance(entityLivingBase) - this.missingEssence;
    }

    @Override
    public void setTolerance(@Nonnull EntityLivingBase entityLivingBase, int amount) {
        this.missingEssence = this.getMaxTolerance(entityLivingBase) - amount;
    }

    @Override
    public int getNumActiveItems() {
        return this.activeItems.size();
    }

    @Override
    public List<ItemStack> getActiveItems() {
        return this.activeItems;
    }

    @Override
    public List<ItemStack> getHudjackItems() {
        return this.hudjackItems;
    }

    @Override
    public void removeHotkey(int i) {
        this.hotkeys.remove(i);
    }

    @Override
    public void addHotkey(int i, ItemStack stack) {
        this.hotkeys.put(i, stack);
    }

    @Override
    public ItemStack getHotkey(int i) {
        if (!this.hotkeys.containsKey(i)) {
            return ItemStack.field_190927_a;
        }
        return this.hotkeys.get(i);
    }

    @Override
    public Iterable<Integer> getHotkeys() {
        return this.hotkeys.keySet();
    }

    @Override
    public void setHudData(NBTTagCompound tagCompound) {
        this.hudData = tagCompound;
    }

    @Override
    public NBTTagCompound getHudData() {
        return this.hudData;
    }

    @Override
    public boolean hasOpenedRadialMenu() {
        return this.hasOpenedRadialMenu;
    }

    @Override
    public void setOpenedRadialMenu(boolean hasOpenedRadialMenu) {
        this.hasOpenedRadialMenu = hasOpenedRadialMenu;
    }

    @Override
    public void setHudColor(int hexVal) {
        float r = (float)(hexVal >> 16 & 0xFF) / 255.0f;
        float g = (float)(hexVal >> 8 & 0xFF) / 255.0f;
        float b = (float)(hexVal & 0xFF) / 255.0f;
        this.setHudColor(new float[]{r, g, b});
    }

    @Override
    public int getHudColorHex() {
        return this.hudColor;
    }

    @Override
    public void setHudColor(float[] color) {
        this.hudColorFloat = color;
        int ri = Math.round(color[0] * 255.0f);
        int gi = Math.round(color[1] * 255.0f);
        int bi = Math.round(color[2] * 255.0f);
        int rp = ri << 16 & 0xFF0000;
        int gp = gi << 8 & 0xFF00;
        int bp = bi & 0xFF;
        this.hudColor = rp | gp | bp;
    }

    @Override
    public float[] getHudColor() {
        return this.hudColorFloat;
    }

    @Override
    public int getProduction() {
        return this.power_lastProduction;
    }

    @Override
    public int getConsumption() {
        return this.power_lastConsumption;
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        public static final ResourceLocation NAME = new ResourceLocation("cyberware", "cyberware");
        private final ICyberwareUserData cyberwareUserData = new CyberwareUserDataImpl();

        public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
            return capability == CyberwareAPI.CYBERWARE_CAPABILITY;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
            if (capability == CyberwareAPI.CYBERWARE_CAPABILITY) {
                return (T)CyberwareAPI.CYBERWARE_CAPABILITY.cast((Object)this.cyberwareUserData);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return this.cyberwareUserData.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound tagCompound) {
            this.cyberwareUserData.deserializeNBT(tagCompound);
        }
    }

    private static class CyberwareUserDataStorage
    implements Capability.IStorage<ICyberwareUserData> {
        private CyberwareUserDataStorage() {
        }

        public NBTBase writeNBT(Capability<ICyberwareUserData> capability, ICyberwareUserData cyberwareUserData, EnumFacing side) {
            return cyberwareUserData.serializeNBT();
        }

        public void readNBT(Capability<ICyberwareUserData> capability, ICyberwareUserData cyberwareUserData, EnumFacing side, NBTBase nbt) {
            if (!(nbt instanceof NBTTagCompound)) {
                throw new IllegalStateException("Cyberware NBT should be a NBTTagCompound!");
            }
            cyberwareUserData.deserializeNBT((NBTTagCompound)nbt);
        }
    }
}

