/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.api.hud;

import flaxbeard.cyberware.api.hud.IHudElement;
import flaxbeard.cyberware.api.hud.IHudSaveData;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;

public abstract class HudElementBase
implements IHudElement {
    private int defaultX = 0;
    private int defaultY = 0;
    private int x = 0;
    private int y = 0;
    private int width = 0;
    private int height = 0;
    private boolean hidden = false;
    private String name;
    private IHudElement.EnumAnchorHorizontal defaultHAnchor = IHudElement.EnumAnchorHorizontal.LEFT;
    private IHudElement.EnumAnchorVertical defaultVAnchor = IHudElement.EnumAnchorVertical.TOP;
    private IHudElement.EnumAnchorHorizontal hAnchor = IHudElement.EnumAnchorHorizontal.LEFT;
    private IHudElement.EnumAnchorVertical vAnchor = IHudElement.EnumAnchorVertical.TOP;

    public HudElementBase(String name) {
        this.name = name;
    }

    @Override
    public void render(EntityPlayer entityPlayer, ScaledResolution resolution, boolean isHUDjackAvailable, boolean isConfigOpen, float partialTicks) {
        int x = this.getX();
        int y = this.getY();
        if (this.getHorizontalAnchor() == IHudElement.EnumAnchorHorizontal.RIGHT) {
            x = resolution.func_78326_a() - x - this.getWidth();
        }
        if (this.getVerticalAnchor() == IHudElement.EnumAnchorVertical.BOTTOM) {
            y = resolution.func_78328_b() - y - this.getHeight();
        }
        this.renderElement(x, y, entityPlayer, resolution, isHUDjackAvailable, isConfigOpen, partialTicks);
    }

    public abstract void renderElement(int var1, int var2, EntityPlayer var3, ScaledResolution var4, boolean var5, boolean var6, float var7);

    public void setDefaultX(int x) {
        this.defaultX = x;
        this.setX(x);
    }

    public void setDefaultY(int y) {
        this.defaultY = y;
        this.setY(y);
    }

    @Override
    public boolean canMove() {
        return true;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean canHide() {
        return true;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public IHudElement.EnumAnchorHorizontal getHorizontalAnchor() {
        return this.hAnchor;
    }

    public void setDefaultHorizontalAnchor(IHudElement.EnumAnchorHorizontal anchor) {
        this.defaultHAnchor = anchor;
        this.setHorizontalAnchor(anchor);
    }

    @Override
    public void setHorizontalAnchor(IHudElement.EnumAnchorHorizontal anchor) {
        this.hAnchor = anchor;
    }

    @Override
    public IHudElement.EnumAnchorVertical getVerticalAnchor() {
        return this.vAnchor;
    }

    public void setDefaultVerticalAnchor(IHudElement.EnumAnchorVertical anchor) {
        this.defaultVAnchor = anchor;
        this.setVerticalAnchor(anchor);
    }

    @Override
    public void setVerticalAnchor(IHudElement.EnumAnchorVertical anchor) {
        this.vAnchor = anchor;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    @Override
    public void reset() {
        this.x = this.defaultX;
        this.y = this.defaultY;
        this.vAnchor = this.defaultVAnchor;
        this.hAnchor = this.defaultHAnchor;
    }

    @Override
    public String getUniqueName() {
        return this.name;
    }

    @Override
    public void save(IHudSaveData data) {
        data.setInteger("x", this.x);
        data.setInteger("y", this.y);
        data.setBoolean("top", this.vAnchor == IHudElement.EnumAnchorVertical.TOP);
        data.setBoolean("left", this.hAnchor == IHudElement.EnumAnchorHorizontal.LEFT);
    }

    @Override
    public void load(IHudSaveData data) {
        this.x = data.getInteger("x");
        this.y = data.getInteger("y");
        this.vAnchor = data.getBoolean("top") ? IHudElement.EnumAnchorVertical.TOP : IHudElement.EnumAnchorVertical.BOTTOM;
        this.hAnchor = data.getBoolean("left") ? IHudElement.EnumAnchorHorizontal.LEFT : IHudElement.EnumAnchorHorizontal.RIGHT;
    }
}

