/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.UpdateConfigPacket;
import java.io.File;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CyberwareConfig {
    public static CyberwareConfig INSTANCE = new CyberwareConfig();
    public static float ENGINEERING_CHANCE = 15.0f;
    public static float SCANNER_CHANCE = 10.0f;
    public static float SCANNER_CHANCE_ADDL = 10.0f;
    public static int SCANNER_TIME = 24000;
    public static int ESSENCE = 100;
    public static int CRITICAL_ESSENCE = 25;
    public static boolean MOBS_ENABLE_CYBER_ZOMBIES = true;
    public static int MOBS_CYBER_ZOMBIE_WEIGHT = 15;
    public static int MOBS_CYBER_ZOMBIE_MIN_PACK = 1;
    public static int MOBS_CYBER_ZOMBIE_MAX_PACK = 1;
    public static HashSet<Integer> MOBS_DIMENSION_IDS = new HashSet();
    public static boolean MOBS_IS_DIMENSION_BLACKLIST = true;
    public static boolean MOBS_APPLY_DIMENSION_TO_SPAWNING = true;
    public static boolean MOBS_APPLY_DIMENSION_TO_BEACON = true;
    public static boolean MOBS_ADD_CLOTHES = true;
    public static float MOBS_CYBER_ZOMBIE_DROP_RARITY = 50.0f;
    public static float MOBS_CLOTH_DROP_RARITY = 50.0f;
    public static int HUDR = 76;
    public static int HUDG = 255;
    public static int HUDB = 0;
    public static boolean ENABLE_FLOAT = false;
    public static float HUDLENS_FLOAT = 0.1f;
    public static float HUDJACK_FLOAT = 0.05f;
    public static boolean SURGERY_CRAFTING = false;
    private static String[][] defaultStartingItems;
    private static String[][] startingItems;
    private static NonNullList<NonNullList<ItemStack>> startingStacks;
    public static boolean DEFAULT_DROP;
    public static boolean DEFAULT_KEEP;
    public static float DROP_CHANCE;
    public static boolean ENABLE_KATANA;
    public static boolean ENABLE_CLOTHES;
    public static boolean ENABLE_CUSTOM_PLAYER_MODEL;
    public static int TESLA_PER_POWER;
    public static int FIST_MINING_LEVEL;
    public static boolean INT_ENDER_IO;
    public static boolean INT_TOUGH_AS_NAILS;
    public static boolean INT_BOTANIA;
    public static boolean INT_MATTER_OVERDRIVE;
    public static Configuration config;
    public static File configDirectory;
    private static final String C_MOBS = "Mobs";
    private static final String C_OTHER = "Other";
    private static final String C_HUD = "HUD";
    private static final String C_MACHINES = "Machines";
    private static final String C_ESSENCE = "Essence";
    private static final String C_GAMERULES = "Gamerules";
    private static final String C_INTEGRATION = "Integration";

    public static void preInit(@Nonnull FMLPreInitializationEvent event) {
        int index;
        configDirectory = event.getModConfigurationDirectory();
        config = new Configuration(new File(event.getModConfigurationDirectory(), "cyberware.cfg"));
        defaultStartingItems = new String[ICyberware.EnumSlot.values().length][0];
        startingItems = defaultStartingItems;
        startingStacks = NonNullList.func_191196_a();
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            NonNullList nnlCyberwaresInSlot = NonNullList.func_191196_a();
            for (int indexSlot = 0; indexSlot < 10; ++indexSlot) {
                nnlCyberwaresInSlot.add((Object)ItemStack.field_190927_a);
            }
            startingStacks.add((Object)nnlCyberwaresInSlot);
        }
        int metadata = 0;
        for (index = 0; index < ICyberware.EnumSlot.values().length; ++index) {
            if (ICyberware.EnumSlot.values()[index].hasEssential()) {
                if (ICyberware.EnumSlot.values()[index].isSided()) {
                    CyberwareConfig.defaultStartingItems[index] = new String[]{"cyberware:body_part 1 " + metadata, "cyberware:body_part 1 " + (metadata + 1)};
                    metadata += 2;
                    continue;
                }
                CyberwareConfig.defaultStartingItems[index] = new String[]{"cyberware:body_part 1 " + metadata};
                ++metadata;
                continue;
            }
            CyberwareConfig.defaultStartingItems[index] = new String[0];
        }
        CyberwareConfig.loadConfig();
        config.load();
        for (index = 0; index < ICyberware.EnumSlot.values().length; ++index) {
            ICyberware.EnumSlot slot = ICyberware.EnumSlot.values()[index];
            CyberwareConfig.startingItems[index] = config.getStringList("Default augments for " + slot.getName() + " slot", "Defaults", defaultStartingItems[index], "Use format 'id amount metadata'");
        }
        config.save();
    }

    public static void loadConfig() {
        config.load();
        MOBS_ENABLE_CYBER_ZOMBIES = config.getBoolean("CyberZombies are enabled", C_MOBS, MOBS_ENABLE_CYBER_ZOMBIES, "");
        MOBS_CYBER_ZOMBIE_WEIGHT = config.getInt("CyberZombies spawning weight", C_MOBS, MOBS_CYBER_ZOMBIE_WEIGHT, 0, Integer.MAX_VALUE, "Vanilla Zombie = 100, Enderman = 10, Witch = 5");
        MOBS_CYBER_ZOMBIE_MIN_PACK = config.getInt("CyberZombies minimum pack size", C_MOBS, MOBS_CYBER_ZOMBIE_MIN_PACK, 0, Integer.MAX_VALUE, "Vanilla Zombie = 4, Enderman = 1, Witch = 1");
        MOBS_CYBER_ZOMBIE_MAX_PACK = config.getInt("CyberZombies maximum pack size", C_MOBS, MOBS_CYBER_ZOMBIE_MAX_PACK, 0, Integer.MAX_VALUE, "Vanilla Zombie = 4, Enderman = 4, Witch = 1");
        int[] dimensionIds = config.get(C_MOBS, "Dimensions ids", new int[0]).getIntList();
        MOBS_DIMENSION_IDS = new HashSet(dimensionIds.length);
        for (int dimensionId : dimensionIds) {
            MOBS_DIMENSION_IDS.add(dimensionId);
        }
        MOBS_IS_DIMENSION_BLACKLIST = config.getBoolean("Dimension ids is a blacklist?", C_MOBS, MOBS_IS_DIMENSION_BLACKLIST, "");
        MOBS_APPLY_DIMENSION_TO_SPAWNING = config.getBoolean("Dimension ids applies to natural spawning?", C_MOBS, MOBS_APPLY_DIMENSION_TO_SPAWNING, "");
        MOBS_APPLY_DIMENSION_TO_BEACON = config.getBoolean("Dimension ids applies to beacon, radio & cranial broadcaster?", C_MOBS, MOBS_APPLY_DIMENSION_TO_BEACON, "");
        MOBS_ADD_CLOTHES = config.getBoolean("Add Cyberware clothing to mobs", C_MOBS, MOBS_ADD_CLOTHES, "");
        MOBS_CYBER_ZOMBIE_DROP_RARITY = config.getFloat("Percent chance a CyberZombie drops a cyberware", C_MOBS, MOBS_CYBER_ZOMBIE_DROP_RARITY, 0.0f, 100.0f, "");
        MOBS_CLOTH_DROP_RARITY = config.getFloat("Percent chance a Cyberware clothing is dropped", C_MOBS, MOBS_CLOTH_DROP_RARITY, 0.0f, 100.0f, "");
        SURGERY_CRAFTING = config.getBoolean("Enable crafting recipe for Robosurgeon", C_OTHER, SURGERY_CRAFTING, "Normally only found in Nether fortresses");
        TESLA_PER_POWER = config.getInt("RF/Tesla per internal power unit", C_OTHER, TESLA_PER_POWER, 0, Integer.MAX_VALUE, "");
        ESSENCE = config.getInt("Maximum Essence", C_ESSENCE, ESSENCE, 0, Integer.MAX_VALUE, "");
        CRITICAL_ESSENCE = config.getInt("Critical Essence value, where rejection begins", C_ESSENCE, CRITICAL_ESSENCE, 0, Integer.MAX_VALUE, "");
        DEFAULT_DROP = config.getBoolean("Default for gamerule cyberware_dropCyberware", C_GAMERULES, DEFAULT_DROP, "Determines if players drop their Cyberware on death. Does not change settings on existing worlds, use /gamerule for that. Overridden if cyberware_keepCyberware is true");
        DEFAULT_KEEP = config.getBoolean("Default for gamerule cyberware_keepCyberware", C_GAMERULES, DEFAULT_KEEP, "Determines if players keep their Cyberware between lives. Does not change settings on existing worlds, use /gamerule for that.");
        DROP_CHANCE = config.getFloat("Chance of successful drop", C_GAMERULES, DROP_CHANCE, 0.0f, 100.0f, "If dropCyberware enabled, chance for a piece of Cyberware to successfuly drop instead of being destroyed.");
        ENGINEERING_CHANCE = config.getFloat("Chance of blueprint from Engineering Table", C_MACHINES, ENGINEERING_CHANCE, 0.0f, 100.0f, "");
        SCANNER_CHANCE = config.getFloat("Chance of blueprint from Scanner", C_MACHINES, SCANNER_CHANCE, 0.0f, 100.0f, "");
        SCANNER_CHANCE_ADDL = config.getFloat("Additive chance for Scanner per extra item", C_MACHINES, SCANNER_CHANCE_ADDL, 0.0f, 100.0f, "");
        SCANNER_TIME = config.getInt("Ticks taken per Scanner operation", C_MACHINES, SCANNER_TIME, 0, Integer.MAX_VALUE, "24000 is one Minecraft day, 1200 is one real-life minute");
        ENABLE_KATANA = config.getBoolean("Enable Katana", C_OTHER, ENABLE_KATANA, "");
        ENABLE_CLOTHES = config.getBoolean("Enable Trench Coat, Mirror Shades, and Biker Jacket", C_OTHER, ENABLE_CLOTHES, "");
        ENABLE_CUSTOM_PLAYER_MODEL = config.getBoolean("Enable changes to player model (missing skin, missing limbs, Cybernetic limbs)", C_OTHER, ENABLE_CUSTOM_PLAYER_MODEL, "");
        ENABLE_FLOAT = config.getBoolean("Enable hudlens and hudjack float.", C_HUD, ENABLE_FLOAT, "Experimental, defaults to false.");
        HUDJACK_FLOAT = config.getFloat("Amount hudjack HUD will 'float' with movement. Set to 0 for no float.", C_HUD, HUDJACK_FLOAT, 0.0f, 100.0f, "");
        HUDLENS_FLOAT = config.getFloat("Amount hudlens HUD will 'float' with movement. Set to 0 for no float.", C_HUD, HUDLENS_FLOAT, 0.0f, 100.0f, "");
        INT_ENDER_IO = config.getBoolean("Enable EnderIO Integration if the mod is Loaded", C_INTEGRATION, INT_ENDER_IO, "Requires EnderIO");
        INT_TOUGH_AS_NAILS = config.getBoolean("Enable Tough As Nails Integration if the mod is Loaded", C_INTEGRATION, INT_TOUGH_AS_NAILS, "Requires Tough as Nails");
        INT_BOTANIA = config.getBoolean("Enable Botania Integration if the mod is Loaded", C_INTEGRATION, INT_BOTANIA, "Requires Botania");
        INT_MATTER_OVERDRIVE = config.getBoolean("Enable Matter Overdrive Integration if the mod is Loaded", C_INTEGRATION, INT_MATTER_OVERDRIVE, "Requires Matter Overdrive");
        FIST_MINING_LEVEL = config.getInt("Configure the mining level for the reinforced fist", C_OTHER, FIST_MINING_LEVEL, 1, 3, "");
        config.save();
    }

    public static void postInit() {
        int index = 0;
        for (String[] items : startingItems) {
            ICyberware.EnumSlot slot = ICyberware.EnumSlot.values()[index];
            if (items.length > 10) {
                throw new RuntimeException("Cyberware configuration error! Too many items for slot " + slot.getName());
            }
            for (int indexItem = 0; indexItem < items.length; ++indexItem) {
                Item item;
                int quantity;
                int metadata;
                String itemName;
                String itemEncoded = items[indexItem];
                String[] params = itemEncoded.split("\\s+");
                if (params.length == 1) {
                    itemName = params[0];
                    metadata = 0;
                    quantity = 0;
                } else {
                    if (params.length == 3) {
                        itemName = params[0];
                        try {
                            metadata = Integer.parseInt(params[2]);
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException("Cyberware configuration error! Item " + (indexItem + 1) + " for " + slot.getName() + " slot has invalid metadata: '" + params[2] + "'");
                        }
                        try {
                            quantity = Integer.parseInt(params[1]);
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException("Cyberware configuration error! Item " + (indexItem + 1) + " for " + slot.getName() + " slot has invalid quantity: '" + params[1] + "'");
                        }
                    }
                    throw new RuntimeException("Cyberware configuration error! Item " + (indexItem + 1) + " for " + slot.getName() + " slot has too many arguments!");
                }
                try {
                    item = CommandBase.func_147179_f(null, (String)itemName);
                }
                catch (NumberInvalidException e) {
                    throw new RuntimeException("Cyberware configuration error! Item '" + (indexItem + 1) + "' for " + slot.getName() + " slot has a nonexistant item: " + itemName);
                }
                ItemStack stack = new ItemStack(item, quantity, metadata);
                if (!CyberwareAPI.isCyberware(stack)) {
                    throw new RuntimeException("Cyberware configuration error! " + itemName + " is not a valid piece of cyberware!");
                }
                if (CyberwareAPI.getCyberware(stack).getSlot(stack) != slot) {
                    throw new RuntimeException("Cyberware configuration error! " + itemEncoded + " will not fit in slot " + slot.getName());
                }
                ((NonNullList)startingStacks.get(index)).set(indexItem, (Object)stack);
            }
            ++index;
        }
    }

    public static NonNullList<ItemStack> getStartingItems(@Nonnull ICyberware.EnumSlot slot) {
        return (NonNullList)startingStacks.get(slot.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onWorldUnload(@Nonnull WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K && !Minecraft.func_71410_x().func_147114_u().func_147298_b().func_150724_d()) {
            CyberwareConfig.loadConfig();
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(@Nonnull PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer entityPlayer = event.player;
        World world = entityPlayer.field_70170_p;
        if (!world.field_72995_K) {
            CyberwarePacketHandler.INSTANCE.sendTo((IMessage)new UpdateConfigPacket(), (EntityPlayerMP)entityPlayer);
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(@Nonnull ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("cyberware")) {
            CyberwareConfig.loadConfig();
        }
    }

    static {
        DEFAULT_DROP = false;
        DEFAULT_KEEP = false;
        DROP_CHANCE = 100.0f;
        ENABLE_KATANA = true;
        ENABLE_CLOTHES = true;
        ENABLE_CUSTOM_PLAYER_MODEL = true;
        TESLA_PER_POWER = 1;
        FIST_MINING_LEVEL = 2;
        INT_ENDER_IO = true;
        INT_TOUGH_AS_NAILS = true;
        INT_BOTANIA = true;
        INT_MATTER_OVERDRIVE = true;
    }
}

