/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.block.tile;

import cofh.redstoneflux.api.IEnergyReceiver;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.block.tile.PowerContainer;
import java.util.List;
import javax.annotation.Nonnull;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux")
public class TileEntityCharger
extends TileEntity
implements ITickable,
IEnergyReceiver,
IEnergyStorage {
    private PowerContainer container = new PowerContainer();
    @CapabilityInject(value=ITeslaConsumer.class)
    private static Capability TESLA_CONSUMER;
    @CapabilityInject(value=ITeslaProducer.class)
    private static Capability TESLA_PRODUCER;
    @CapabilityInject(value=ITeslaHolder.class)
    private static Capability TESLA_HOLDER;
    private boolean last = false;

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.container.deserializeNBT(tagCompound.func_74775_l("power"));
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74782_a("power", (NBTBase)this.container.serializeNBT());
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound data = pkt.func_148857_g();
        this.func_145839_a(data);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound data = new NBTTagCompound();
        this.func_189515_b(data);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, data);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == TESLA_CONSUMER || capability == TESLA_PRODUCER || capability == TESLA_HOLDER) {
            return (T)this.container;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == TESLA_CONSUMER || capability == TESLA_PRODUCER || capability == TESLA_HOLDER || capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public void func_73660_a() {
        boolean hasPower;
        List entitiesInRange = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)((float)this.field_174879_c.func_177958_n() + 1.0f), (double)((float)this.field_174879_c.func_177956_o() + 2.5f), (double)((float)this.field_174879_c.func_177952_p() + 1.0f)));
        for (EntityLivingBase entityInRange : entitiesInRange) {
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityInRange);
            if (cyberwareUserData == null || cyberwareUserData.isAtCapacity(ItemStack.field_190927_a, 20) || this.container.getStoredPower() < (long)CyberwareConfig.TESLA_PER_POWER) continue;
            if (!this.field_145850_b.field_72995_K) {
                this.container.takePower(CyberwareConfig.TESLA_PER_POWER, false);
            }
            cyberwareUserData.addPower(20, ItemStack.field_190927_a);
            if (entityInRange.field_70173_aa % 5 != 0) continue;
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.0f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 0.0, (double)0.05f, 0.0, new int[]{255, 150, 255});
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.0f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), (double)0.04f, (double)0.05f, (double)0.04f, new int[]{255, 150, 255});
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.0f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), (double)-0.04f, (double)0.05f, (double)0.04f, new int[]{255, 150, 255});
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.0f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), (double)0.04f, (double)0.05f, (double)-0.04f, new int[]{255, 150, 255});
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.0f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), (double)-0.04f, (double)0.05f, (double)-0.04f, new int[]{255, 150, 255});
        }
        boolean bl = hasPower = this.container.getStoredPower() >= (long)CyberwareConfig.TESLA_PER_POWER;
        if (hasPower != this.last && !this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
            this.last = hasPower;
        }
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int getEnergyStored(EnumFacing from) {
        return (int)this.container.getStoredPower();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return (int)this.container.getCapacity();
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return (int)this.container.givePower(maxReceive, simulate);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)this.container.givePower(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)this.container.takePower(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return (int)this.container.getStoredPower();
    }

    public int getMaxEnergyStored() {
        return (int)this.container.getCapacity();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

