/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.integration.tan;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.common.integration.tan.ToughAsNailsIntegration;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.ISyncedOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.stat.capability.IThirst;
import toughasnails.api.temperature.IModifierMonitor;
import toughasnails.api.temperature.Temperature;
import toughasnails.api.temperature.TemperatureScale;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.temperature.modifier.TemperatureModifier;

public class CyberwareModifier
extends TemperatureModifier {
    private final Type cyberwareType;
    private final String description;

    CyberwareModifier(@Nonnull Type type) {
        super("cyberware:" + type.name);
        this.cyberwareType = type;
        this.description = "Cyberware: " + this.cyberwareType.name;
    }

    public Temperature applyPlayerModifiers(@Nonnull EntityPlayer entityPlayer, @Nonnull Temperature temperature, @Nonnull IModifierMonitor iModifierMonitor) {
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
        if (cyberwareUserData == null) {
            return temperature;
        }
        ItemStack itemStackCyberware = cyberwareUserData.getCyberware(this.cyberwareType.getCyberware());
        if (itemStackCyberware.func_190926_b()) {
            return temperature;
        }
        Temperature temperatureToReturn = temperature;
        switch (this.cyberwareType) {
            case SWEAT: {
                boolean needCooling;
                boolean bl = needCooling = temperature.getRange() == TemperatureScale.TemperatureRange.WARM || temperature.getRange() == TemperatureScale.TemperatureRange.HOT;
                if (needCooling && ThirstHelper.getThirstData((EntityPlayer)entityPlayer).getThirst() > 0) {
                    if (SyncedConfig.getBooleanValue((ISyncedOption)GameplayOption.ENABLE_THIRST)) {
                        IThirst data = ThirstHelper.getThirstData((EntityPlayer)entityPlayer);
                        data.setExhaustion(Math.min(data.getExhaustion() + 0.008f, 40.0f));
                    }
                    temperatureToReturn = new Temperature(temperature.getRawValue() + this.cyberwareType.modifier);
                }
                iModifierMonitor.addEntry(new IModifierMonitor.Context(this.getId(), this.getDescription(), temperature, temperatureToReturn));
                break;
            }
            case BLUBBER: {
                temperatureToReturn = new Temperature(temperature.getRawValue() + this.cyberwareType.modifier);
                iModifierMonitor.addEntry(new IModifierMonitor.Context(this.getId(), this.getDescription(), temperature, temperatureToReturn));
            }
        }
        return temperatureToReturn;
    }

    public boolean isPlayerSpecific() {
        return true;
    }

    public String getDescription() {
        return this.description;
    }

    static enum Type {
        SWEAT("Sweat", -4, 0),
        BLUBBER("Blubber", 3, 1);

        private final String name;
        private final int modifier;
        private final int meta;

        private Type(String id, int mod, int meta) {
            this.name = id;
            this.modifier = mod;
            this.meta = meta;
        }

        public ItemStack getCyberware() {
            return new ItemStack((Item)ToughAsNailsIntegration.sweat, 1, this.meta);
        }
    }
}

