/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import com.mojang.realmsclient.gui.ChatFormatting;
import flaxbeard.cyberware.Cyberware;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.item.IBlueprint;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.misc.NNLUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemBlueprint
extends Item
implements IBlueprint {
    public ItemBlueprint(String name) {
        this.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
        this.func_77655_b("cyberware." + name);
        this.func_77637_a(Cyberware.creativeTab);
        this.func_77627_a(true);
        this.func_77625_d(1);
        CyberwareContent.items.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("blueprintItem")) {
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            if (GameSettings.func_100015_a((KeyBinding)settings.field_74311_E)) {
                ItemStack blueprintItem = new ItemStack(tagCompound.func_74775_l("blueprintItem"));
                if (!blueprintItem.func_190926_b() && CyberwareAPI.canDeconstruct(blueprintItem)) {
                    NonNullList<ItemStack> items = NNLUtil.copyList(CyberwareAPI.getComponents(blueprintItem));
                    tooltip.add(I18n.func_135052_a((String)"cyberware.tooltip.blueprint", (Object[])new Object[]{blueprintItem.func_82833_r()}));
                    for (ItemStack item : items) {
                        if (item.func_190926_b()) continue;
                        tooltip.add(item.func_190916_E() + " x " + item.func_82833_r());
                    }
                    return;
                }
            } else {
                tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"cyberware.tooltip.shift_prompt", (Object[])new Object[0]));
                return;
            }
        }
        tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"cyberware.tooltip.craft_blueprint", (Object[])new Object[0]));
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this, 1, 1));
        }
    }

    public static ItemStack getBlueprintForItem(ItemStack stack) {
        if (!stack.func_190926_b() && CyberwareAPI.canDeconstruct(stack)) {
            ItemStack toBlue = stack.func_77946_l();
            toBlue.func_190920_e(1);
            if (toBlue.func_77984_f()) {
                toBlue.func_77964_b(0);
            }
            toBlue.func_77982_d(null);
            ItemStack ret = new ItemStack(CyberwareContent.blueprint);
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74782_a("blueprintItem", (NBTBase)toBlue.func_77955_b(new NBTTagCompound()));
            ret.func_77982_d(tagCompound);
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public String func_77653_i(ItemStack stack) {
        ItemStack blueprintItem;
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("blueprintItem") && !(blueprintItem = new ItemStack(tagCompound.func_74775_l("blueprintItem"))).func_190926_b()) {
            return I18n.func_135052_a((String)"item.cyberware.blueprint.not_blank.name", (Object[])new Object[]{blueprintItem.func_82833_r()}).trim();
        }
        return ("" + I18n.func_135052_a((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[0])).trim();
    }

    @Override
    public ItemStack getResult(ItemStack stack, NonNullList<ItemStack> craftingItems) {
        ItemStack blueprintItem;
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("blueprintItem") && !(blueprintItem = new ItemStack(tagCompound.func_74775_l("blueprintItem"))).func_190926_b() && CyberwareAPI.canDeconstruct(blueprintItem)) {
            NonNullList<ItemStack> requiredItems = NNLUtil.copyList(CyberwareAPI.getComponents(blueprintItem));
            for (ItemStack requiredItem : requiredItems) {
                ItemStack required = requiredItem.func_77946_l();
                boolean satisfied = false;
                for (ItemStack crafting : craftingItems) {
                    if (crafting.func_190926_b() || required.func_190926_b()) continue;
                    if (crafting.func_77973_b() == required.func_77973_b() && crafting.func_77952_i() == required.func_77952_i() && (!required.func_77942_o() || ItemStack.func_77970_a((ItemStack)required, (ItemStack)crafting))) {
                        required.func_190918_g(crafting.func_190916_E());
                    }
                    if (required.func_190916_E() > 0) continue;
                    satisfied = true;
                    break;
                }
                if (satisfied) continue;
                return ItemStack.field_190927_a;
            }
            return blueprintItem;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NonNullList<ItemStack> consumeItems(ItemStack stack, NonNullList<ItemStack> craftingItems) {
        ItemStack blueprintItem;
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("blueprintItem") && !(blueprintItem = new ItemStack(tagCompound.func_74775_l("blueprintItem"))).func_190926_b() && CyberwareAPI.canDeconstruct(blueprintItem)) {
            NonNullList<ItemStack> requiredItems = NNLUtil.copyList(CyberwareAPI.getComponents(blueprintItem));
            NonNullList newCrafting = NonNullList.func_191196_a();
            newCrafting.addAll(craftingItems);
            block0: for (ItemStack requiredItem : requiredItems) {
                ItemStack required = requiredItem.func_77946_l();
                for (int c = 0; c < newCrafting.size(); ++c) {
                    ItemStack crafting = (ItemStack)newCrafting.get(c);
                    if (crafting.func_190926_b() || required.func_190926_b()) continue;
                    if (crafting.func_77973_b() == required.func_77973_b() && crafting.func_77952_i() == required.func_77952_i() && (!required.func_77942_o() || ItemStack.func_77970_a((ItemStack)required, (ItemStack)crafting))) {
                        int toSubtract = Math.min(required.func_190916_E(), crafting.func_190916_E());
                        required.func_190918_g(toSubtract);
                        crafting.func_190918_g(toSubtract);
                        if (crafting.func_190916_E() <= 0) {
                            crafting = ItemStack.field_190927_a;
                        }
                        newCrafting.set(c, (Object)crafting);
                    }
                    if (required.func_190916_E() <= 0) continue block0;
                }
            }
            return newCrafting;
        }
        throw new IllegalStateException("Consuming items when items shouldn't be consumed!");
    }

    @Override
    public NonNullList<ItemStack> getRequirementsForDisplay(ItemStack stack) {
        ItemStack blueprintItem;
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("blueprintItem") && !(blueprintItem = new ItemStack(tagCompound.func_74775_l("blueprintItem"))).func_190926_b() && CyberwareAPI.canDeconstruct(blueprintItem)) {
            return CyberwareAPI.getComponents(blueprintItem);
        }
        return NonNullList.func_191196_a();
    }

    @Override
    public ItemStack getIconForDisplay(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("blueprintItem")) {
            return new ItemStack(tagCompound.func_74775_l("blueprintItem"));
        }
        return ItemStack.field_190927_a;
    }
}

