/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.item.ItemCyberware;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.SwitchHeldItemAndRotationPacket;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemMuscleUpgrade
extends ItemCyberware
implements IMenuItem {
    private static final int META_WIRED_REFLEXES = 0;
    private static final int META_MUSCLE_REPLACEMENTS = 1;
    private static final UUID idMuscleSpeedAttribute = UUID.fromString("f0ab4766-4be1-11e6-beb8-9e71128cae77");
    private static final UUID idMuscleDamageAttribute = UUID.fromString("f63d6916-4be1-11e6-beb8-9e71128cae77");
    private static final HashMultimap<String, AttributeModifier> multimapMuscleSpeedAttribute = HashMultimap.create();
    private static final HashMultimap<String, AttributeModifier> multimapMuscleDamageAttribute;
    private Set<UUID> setIsStrengthPowered = new HashSet<UUID>();
    private static final float[] f;

    public ItemMuscleUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onAdded(EntityLivingBase entityLivingBase, ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            entityLivingBase.func_110140_aT().func_111147_b(multimapMuscleSpeedAttribute);
        } else if (stack.func_77952_i() == 1) {
            entityLivingBase.func_110140_aT().func_111147_b(multimapMuscleDamageAttribute);
        }
    }

    @Override
    public void onRemoved(EntityLivingBase entityLivingBase, ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            entityLivingBase.func_110140_aT().func_111148_a(multimapMuscleSpeedAttribute);
        } else if (stack.func_77952_i() == 1) {
            entityLivingBase.func_110140_aT().func_111148_a(multimapMuscleDamageAttribute);
        }
    }

    @Override
    public int installedStackSize(ItemStack stack) {
        return stack.func_77952_i() == 0 ? 3 : 1;
    }

    @SubscribeEvent
    public void handleHurt(LivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (!(entityLivingBase instanceof EntityPlayer)) {
            return;
        }
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData == null) {
            return;
        }
        ItemStack itemStackWiredReflexes = cyberwareUserData.getCyberware(this.getCachedStack(0));
        int rank = itemStackWiredReflexes.func_190916_E();
        if (rank > 1 && EnableDisableHelper.isEnabled(itemStackWiredReflexes) && this.setIsStrengthPowered.contains(entityLivingBase.func_110124_au())) {
            EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
            if (event.getSource() instanceof EntityDamageSource && !(event.getSource() instanceof EntityDamageSourceIndirect)) {
                EntityDamageSource source = (EntityDamageSource)event.getSource();
                Entity attacker = source.func_76346_g();
                int lastAttacked = entityPlayer.func_110142_aN().field_94555_c;
                if (entityPlayer.field_70173_aa - lastAttacked > 120) {
                    int indexWeapon = -1;
                    ItemStack itemMainhand = entityPlayer.func_184614_ca();
                    if (!itemMainhand.func_190926_b() && (entityPlayer.func_184605_cv() > 0 || itemMainhand.func_77973_b() instanceof ItemSword || itemMainhand.func_77973_b().getAttributeModifiers(EntityEquipmentSlot.MAINHAND, itemMainhand).containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()))) {
                        indexWeapon = entityPlayer.field_71071_by.field_70461_c;
                    }
                    if (indexWeapon == -1) {
                        double mostDamage = 0.0;
                        for (int indexHotbar = 0; indexHotbar < 10; ++indexHotbar) {
                            double damage;
                            Multimap modifiers;
                            ItemStack potentialWeapon;
                            if (indexHotbar == entityPlayer.field_71071_by.field_70461_c || (potentialWeapon = (ItemStack)entityPlayer.field_71071_by.field_70462_a.get(indexHotbar)).func_190926_b() || !(modifiers = potentialWeapon.func_77973_b().getAttributeModifiers(EntityEquipmentSlot.MAINHAND, potentialWeapon)).containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()) || !((damage = ((AttributeModifier)modifiers.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).iterator().next()).func_111164_d()) > mostDamage) && indexWeapon != -1) continue;
                            mostDamage = damage;
                            indexWeapon = indexHotbar;
                        }
                    }
                    if (indexWeapon != -1) {
                        entityPlayer.field_71071_by.field_70461_c = indexWeapon;
                        CyberwarePacketHandler.INSTANCE.sendTo((IMessage)new SwitchHeldItemAndRotationPacket(indexWeapon, entityPlayer.func_145782_y(), rank > 2 && attacker != null ? attacker.func_145782_y() : -1), (EntityPlayerMP)entityPlayer);
                        WorldServer worldServer = (WorldServer)entityPlayer.field_70170_p;
                        for (EntityPlayer trackingPlayer : worldServer.func_73039_n().getTrackingPlayers((Entity)entityPlayer)) {
                            CyberwarePacketHandler.INSTANCE.sendTo((IMessage)new SwitchHeldItemAndRotationPacket(indexWeapon, entityPlayer.func_145782_y(), rank > 2 && attacker != null ? attacker.func_145782_y() : -1), (EntityPlayerMP)trackingPlayer);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void handleLivingUpdate(CyberwareUpdateEvent event) {
        boolean isPowered;
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = event.getCyberwareUserData();
        ItemStack itemStackMuscleReplacement = cyberwareUserData.getCyberware(this.getCachedStack(1));
        if (!itemStackMuscleReplacement.func_190926_b()) {
            boolean wasPowered = this.setIsStrengthPowered.contains(entityLivingBase.func_110124_au());
            boolean bl = isPowered = entityLivingBase.field_70173_aa % 20 == 0 ? cyberwareUserData.usePower(itemStackMuscleReplacement, this.getPowerConsumption(itemStackMuscleReplacement)) : wasPowered;
            if (isPowered) {
                if (!entityLivingBase.func_70090_H() && entityLivingBase.field_70122_E && Math.abs(entityLivingBase.field_70702_br) + Math.abs(entityLivingBase.field_191988_bg) > 0.0f && Math.abs(entityLivingBase.field_70159_w) + Math.abs(entityLivingBase.field_70179_y) > 0.0) {
                    float boost = 0.51f;
                    entityLivingBase.func_191958_b(entityLivingBase.field_70702_br * boost, 0.0f, entityLivingBase.field_191988_bg * boost, 0.075f);
                }
                if (entityLivingBase.field_70173_aa % 20 == 0) {
                    this.onAdded(entityLivingBase, itemStackMuscleReplacement);
                }
                if (!wasPowered) {
                    this.setIsStrengthPowered.add(entityLivingBase.func_110124_au());
                }
            } else if (entityLivingBase.field_70173_aa % 20 == 0) {
                this.onRemoved(entityLivingBase, itemStackMuscleReplacement);
                this.setIsStrengthPowered.remove(entityLivingBase.func_110124_au());
            }
        } else if (entityLivingBase.field_70173_aa % 20 == 0) {
            this.onRemoved(entityLivingBase, itemStackMuscleReplacement);
            this.setIsStrengthPowered.remove(entityLivingBase.func_110124_au());
        }
        if (entityLivingBase.field_70173_aa % 20 == 0) {
            ItemStack itemStackWiredReflexes = cyberwareUserData.getCyberware(this.getCachedStack(0));
            if (!itemStackWiredReflexes.func_190926_b() && EnableDisableHelper.isEnabled(itemStackWiredReflexes)) {
                isPowered = cyberwareUserData.usePower(itemStackWiredReflexes, this.getPowerConsumption(itemStackWiredReflexes));
                if (isPowered) {
                    this.onAdded(entityLivingBase, itemStackWiredReflexes);
                } else {
                    this.onRemoved(entityLivingBase, itemStackWiredReflexes);
                }
            } else {
                this.onRemoved(entityLivingBase, itemStackWiredReflexes);
            }
        }
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77952_i() == 0 ? 2 : 3;
    }

    @Override
    protected int getUnmodifiedEssenceCost(ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            switch (stack.func_190916_E()) {
                case 1: {
                    return 9;
                }
                case 2: {
                    return 10;
                }
                case 3: {
                    return 11;
                }
            }
        }
        return super.getUnmodifiedEssenceCost(stack);
    }

    @Override
    public boolean hasMenu(ItemStack stack) {
        return stack.func_77952_i() == 0;
    }

    @Override
    public void use(Entity entity, ItemStack stack) {
        EnableDisableHelper.toggle(stack);
    }

    @Override
    public String getUnlocalizedLabel(ItemStack stack) {
        return EnableDisableHelper.getUnlocalizedLabel(stack);
    }

    @Override
    public float[] getColor(ItemStack stack) {
        return (float[])(EnableDisableHelper.isEnabled(stack) ? f : null);
    }

    @Override
    public boolean isEssential(ItemStack stack) {
        return stack.func_77952_i() == 1;
    }

    @Override
    public boolean isIncompatible(ItemStack stack, ItemStack other) {
        return stack.func_77952_i() == 1 && CyberwareAPI.getCyberware(other).isEssential(other);
    }

    static {
        multimapMuscleSpeedAttribute.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(idMuscleSpeedAttribute, "Muscle speed upgrade", 1.5, 0));
        multimapMuscleDamageAttribute = HashMultimap.create();
        multimapMuscleDamageAttribute.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(idMuscleDamageAttribute, "Muscle damage upgrade", 3.0, 0));
        f = new float[]{1.0f, 0.0f, 0.0f};
    }
}

